/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private volatile boolean myDumb = false;
    private final DumbService.DumbModeListener myPublisher;
    private final Queue<DumbModeTask> myUpdatesQueue = new Queue(5);
    private final Map<DumbModeTask, ProgressIndicatorEx> myProgresses = ContainerUtil.newConcurrentMap();
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private ThreadLocal<Boolean> myAlternativeResolution = new ThreadLocal();

    public DumbServiceImpl(Project project) {
        this.myProject = project;
        this.myPublisher = (DumbService.DumbModeListener)project.getMessageBus().syncPublisher(DUMB_MODE);
    }

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/DumbServiceImpl", "getInstance"));
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public void queueTask(@NotNull DumbModeTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "queueTask"));
        }
        this.scheduleCacheUpdate(task, true);
    }

    public void cancelTask(@NotNull DumbModeTask task) {
        ProgressIndicatorEx indicator;
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "cancelTask"));
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task);
        }
        if ((indicator = this.myProgresses.get(task)) != null) {
            indicator.cancel();
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdatesQueue.clear();
        this.myRunWhenSmartQueue.clear();
        for (DumbModeTask task : new ArrayList<DumbModeTask>(this.myProgresses.keySet())) {
            this.cancelTask(task);
            Disposer.dispose((Disposable)task);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return Boolean.TRUE.equals(this.myAlternativeResolution.get());
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        assert (this.isAlternativeResolveEnabled() != enabled) : "Nested alternative resolution mode is not supported";
        this.myAlternativeResolution.set(enabled);
    }

    public boolean isDumb() {
        return this.myDumb;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myDumb = true;
            this.myPublisher.enteredDumbMode();
        } else {
            this.updateFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenSmart(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "runWhenSmart"));
        }
        if (!this.isDumb()) {
            runnable.run();
        } else {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myRunWhenSmartQueue.addLast((Object)runnable);
            }
        }
    }

    public void queueCacheUpdate(@NotNull Collection<CacheUpdater> updaters) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "com/intellij/openapi/project/DumbServiceImpl", "queueCacheUpdate"));
        }
        this.scheduleCacheUpdate(new CacheUpdateRunner(this.myProject, new ArrayList<CacheUpdater>(updaters)), false);
    }

    public void queueCacheUpdateInDumbMode(@NotNull Collection<CacheUpdater> updaters) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "com/intellij/openapi/project/DumbServiceImpl", "queueCacheUpdateInDumbMode"));
        }
        this.scheduleCacheUpdate(new CacheUpdateRunner(this.myProject, new ArrayList<CacheUpdater>(updaters)), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCacheUpdate(final @NotNull DumbModeTask task, boolean forceDumbMode) {
        Application application;
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl", "scheduleCacheUpdate"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task, new Throwable());
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment() || !forceDumbMode && !this.myDumb && application.isReadAccessAllowed()) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.pushState();
            }
            AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task");
            try {
                task.performInDumbMode((ProgressIndicator)(indicator != null ? indicator : new EmptyProgressIndicator()));
            }
            finally {
                token.finish();
                if (indicator != null) {
                    indicator.popState();
                }
                Disposer.dispose((Disposable)task);
            }
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new DumbAwareRunnable(){

            public void run() {
                boolean startSuccess;
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                ProgressIndicatorBase indicator = new ProgressIndicatorBase(){

                    @Override
                    protected void delegateRunningChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action) {
                        if (action == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/DumbServiceImpl$1$1", "delegateRunningChange"));
                        }
                    }
                };
                DumbServiceImpl.this.myProgresses.put(task, indicator);
                Disposer.register((Disposable)task, (Disposable)new Disposable(){

                    public void dispose() {
                        application.assertIsDispatchThread();
                        DumbServiceImpl.this.myProgresses.remove(task);
                    }
                });
                DumbServiceImpl.this.myUpdatesQueue.addLast((Object)task);
                if (!DumbServiceImpl.this.myDumb && !(startSuccess = ((Boolean)application.runWriteAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        DumbServiceImpl.this.myDumb = true;
                        try {
                            DumbServiceImpl.this.myPublisher.enteredDumbMode();
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                        try {
                            DumbServiceImpl.this.startBackgroundProcess();
                        }
                        catch (Throwable e) {
                            LOG.error("Failed to start background index update task", e);
                            return false;
                        }
                        return true;
                    }
                })).booleanValue())) {
                    DumbServiceImpl.this.updateFinished();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        this.myDumb = false;
        if (this.myProject.isDisposed()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        finally {
            while (!this.myDumb) {
                Runnable runnable;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    public void showDumbModeNotification(final @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/project/DumbServiceImpl", "showDumbModeNotification"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(DumbServiceImpl.this.myProject);
                if (ideFrame != null) {
                    StatusBarEx statusBar = (StatusBarEx)ideFrame.getStatusBar();
                    statusBar.notifyProgressByBalloon(MessageType.WARNING, message, null, null);
                }
            }
        });
    }

    public void waitForSmartMode() {
        if (!this.isDumb()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.runWhenSmart(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dumbUnawareContent", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/project/DumbServiceImpl", "wrapGently"));
        }
        final DumbUnawareHider wrapper = new DumbUnawareHider(dumbUnawareContent);
        wrapper.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper.setContentVisible(true);
            }
        });
        return wrapper;
    }

    public void smartInvokeLater(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbServiceImpl.this.runWhenSmart(runnable);
            }

            public String toString() {
                return runnable.toString();
            }
        }, this.myProject.getDisposed());
    }

    public void smartInvokeLater(final @NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/project/DumbServiceImpl", "smartInvokeLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbServiceImpl.this.runWhenSmart(runnable);
            }
        }, modalityState, this.myProject.getDisposed());
    }

    private void startBackgroundProcess() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator visibleIndicator) {
                if (visibleIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl$7", "run"));
                }
                ShutDownTracker shutdownTracker = ShutDownTracker.getInstance();
                Thread self = Thread.currentThread();
                AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks");
                try {
                    Pair pair;
                    shutdownTracker.registerStopperThread(self);
                    if (visibleIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)visibleIndicator).addStateDelegate(new AppIconProgress());
                    }
                    DumbModeTask task = null;
                    while ((pair = DumbServiceImpl.this.getNextTask(task)) != null) {
                        task = (DumbModeTask)pair.first;
                        ProgressIndicatorEx taskIndicator = (ProgressIndicatorEx)pair.second;
                        if (visibleIndicator instanceof ProgressIndicatorEx) {
                            taskIndicator.addStateDelegate((ProgressIndicatorEx)visibleIndicator);
                        }
                        DumbServiceImpl.runSingleTask(task, taskIndicator);
                    }
                }
                catch (Throwable unexpected) {
                    LOG.error(unexpected);
                }
                finally {
                    shutdownTracker.unregisterStopperThread(self);
                    token.finish();
                }
            }
        });
    }

    private static void runSingleTask(final DumbModeTask task, final ProgressIndicatorEx taskIndicator) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task);
        }
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                try {
                    taskIndicator.checkCanceled();
                    taskIndicator.setIndeterminate(true);
                    taskIndicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                    task.performInDumbMode((ProgressIndicator)taskIndicator);
                }
                catch (ProcessCanceledException ignored) {
                }
                catch (Throwable unexpected) {
                    LOG.error(unexpected);
                }
            }
        }, (ProgressIndicator)taskIndicator);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> getNextTask(final @Nullable DumbModeTask prevTask) {
        final Ref result = Ref.create();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ProgressIndicatorEx indicator;
                DumbModeTask queuedTask;
                if (DumbServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                if (prevTask != null) {
                    Disposer.dispose((Disposable)prevTask);
                }
                while (true) {
                    if (DumbServiceImpl.this.myUpdatesQueue.isEmpty()) {
                        DumbServiceImpl.this.updateFinished();
                        return;
                    }
                    queuedTask = (DumbModeTask)DumbServiceImpl.this.myUpdatesQueue.pullFirst();
                    indicator = (ProgressIndicatorEx)DumbServiceImpl.this.myProgresses.get(queuedTask);
                    if (!indicator.isCanceled()) break;
                    Disposer.dispose((Disposable)queuedTask);
                }
                result.set((Object)Pair.create((Object)queuedTask, (Object)indicator));
            }
        });
        return (Pair)result.get();
    }

    private class AppIconProgress
    extends ProgressIndicatorBase {
        private double lastFraction;

        private AppIconProgress() {
        }

        @Override
        public void setFraction(final double fraction) {
            if (fraction - this.lastFraction < 0.01) {
                return;
            }
            this.lastFraction = fraction;
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppIcon.getInstance().setProgress(DumbServiceImpl.this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true);
                }
            });
        }

        @Override
        public void finish(@NotNull TaskInfo task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl$AppIconProgress", "finish"));
            }
            if (this.lastFraction != 0.0) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AppIcon appIcon = AppIcon.getInstance();
                        if (appIcon.hideProgress(DumbServiceImpl.this.myProject, "indexUpdate")) {
                            appIcon.requestAttention(DumbServiceImpl.this.myProject, false);
                            appIcon.setOkBadge(DumbServiceImpl.this.myProject, true);
                        }
                    }
                });
            }
        }
    }
}

