/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    public static final String NAME = ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    private ClasspathPanelImpl myPanel;
    private ClasspathFormatPanel myClasspathFormatPanel;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.myClasspathFormatPanel != null && this.myClasspathFormatPanel.isModified();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        this.myPanel.stopEditing();
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.myClasspathFormatPanel != null) {
            this.myClasspathFormatPanel.apply();
        }
    }

    @Override
    public void canApply() throws ConfigurationException {
        super.canApply();
        if (this.myClasspathFormatPanel != null) {
            ClasspathStorage.getProvider(this.myClasspathFormatPanel.getSelectedClasspathFormat()).assertCompatible((ModuleRootModel)this.getModel());
        }
    }

    @Override
    public JComponent createComponentImpl() {
        this.myPanel = new ClasspathPanelImpl(this.getState());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel.add((Component)this.myPanel, "Center");
        ModuleJdkConfigurable jdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getState().getRootModel();
            }
        };
        panel.add((Component)jdkConfigurable.createComponent(), "North");
        jdkConfigurable.reset();
        this.registerDisposable(jdkConfigurable);
        List<ClasspathStorageProvider> providers = ClasspathStorage.getProviders();
        if (providers.size() > 1) {
            this.myClasspathFormatPanel = new ClasspathFormatPanel(providers);
            panel.add((Component)this.myClasspathFormatPanel, "South");
        }
        return panel;
    }

    @Deprecated
    public void flushChangesToModel() {
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/ui/configuration/ClasspathEditor", "selectOrderEntry"));
        }
        this.myPanel.selectOrderEntry(entry);
    }

    @Override
    public void moduleStateChanged() {
        if (this.myPanel != null) {
            this.myPanel.initFromModel();
        }
    }

    public void beforeRootsChange(ModuleRootEvent event) {
    }

    public void rootsChanged(ModuleRootEvent event) {
        if (this.myPanel != null) {
            this.myPanel.rootsChanged();
        }
    }

    public void setSdk(Sdk newJDK) {
        ModifiableRootModel model = this.getModel();
        if (newJDK != null) {
            model.setSdk(newJDK);
        } else {
            model.inheritSdk();
        }
        if (this.myPanel != null) {
            this.myPanel.forceInitFromModel();
        }
    }

    private class ClasspathFormatPanel
    extends JPanel {
        private final JComboBox cbClasspathFormat;
        private final Map<String, String> formatIdToDescr;

        private ClasspathFormatPanel(List<ClasspathStorageProvider> providers) {
            super(new GridBagLayout());
            this.formatIdToDescr = new HashMap<String, String>();
            this.add((Component)new JLabel(ProjectBundle.message((String)"project.roots.classpath.format.label", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 6, 6, 0), 0, 0));
            for (ClasspathStorageProvider provider : providers) {
                this.formatIdToDescr.put(provider.getID(), provider.getDescription());
            }
            Object[] items = this.formatIdToDescr.values().toArray();
            this.cbClasspathFormat = new JComboBox<Object>(items);
            this.updateClasspathFormat();
            this.add((Component)this.cbClasspathFormat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        }

        private void updateClasspathFormat() {
            this.cbClasspathFormat.setSelectedItem(this.formatIdToDescr.get(this.getModuleClasspathFormat()));
        }

        private String getSelectedClasspathFormat() {
            String selected = (String)this.cbClasspathFormat.getSelectedItem();
            for (Map.Entry<String, String> entry : this.formatIdToDescr.entrySet()) {
                if (!entry.getValue().equals(selected)) continue;
                return entry.getKey();
            }
            throw new IllegalStateException(selected);
        }

        @NotNull
        private String getModuleClasspathFormat() {
            String string = ClassPathStorageUtil.getStorageType(ClasspathEditor.this.getModel().getModule());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ClasspathEditor$ClasspathFormatPanel", "getModuleClasspathFormat"));
            }
            return string;
        }

        boolean isModified() {
            return this.cbClasspathFormat != null && !this.getSelectedClasspathFormat().equals(this.getModuleClasspathFormat());
        }

        void apply() throws ConfigurationException {
            String storageID = this.getSelectedClasspathFormat();
            ClasspathStorage.getProvider(storageID).assertCompatible((ModuleRootModel)ClasspathEditor.this.getModel());
            ClasspathStorage.setStorageType((ModuleRootModel)ClasspathEditor.this.getModel(), storageID);
        }
    }
}

