/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

class TableItem {
    private final String myUrl;
    private final CellAppearanceEx myCellAppearance;

    public TableItem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/TableItem", "<init>"));
        }
        this.myUrl = file.getUrl();
        this.myCellAppearance = FileAppearanceService.getInstance().forVirtualFile(file);
    }

    public TableItem(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/TableItem", "<init>"));
        }
        this.myUrl = url;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        this.myCellAppearance = file != null ? FileAppearanceService.getInstance().forVirtualFile(file) : FileAppearanceService.getInstance().forInvalidUrl(url);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/TableItem", "getUrl"));
        }
        return string;
    }

    @NotNull
    public CellAppearanceEx getCellAppearance() {
        CellAppearanceEx cellAppearanceEx = this.myCellAppearance;
        if (cellAppearanceEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/TableItem", "getCellAppearance"));
        }
        return cellAppearanceEx;
    }
}

