/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="UpdatesConfigurable", storages={@Storage(file="$APP_CONFIG$/updates.xml", roamingType=RoamingType.DISABLED), @Storage(file="$APP_CONFIG$/other.xml", deprecated=true)})
public class UpdateSettings
implements PersistentStateComponent<Element>,
UserUpdateSettings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateSettings");
    public JDOMExternalizableStringList myPluginHosts = new JDOMExternalizableStringList();
    public JDOMExternalizableStringList myKnownUpdateChannels = new JDOMExternalizableStringList();
    public JDOMExternalizableStringList myIgnoredBuildNumbers = new JDOMExternalizableStringList();
    public JDOMExternalizableStringList myOutdatedPlugins = new JDOMExternalizableStringList();
    public boolean CHECK_NEEDED = true;
    public long LAST_TIME_CHECKED = 0L;
    public String LAST_BUILD_CHECKED = "";
    public String UPDATE_CHANNEL_TYPE = "release";
    public boolean SECURE_CONNECTION = false;

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    public UpdateSettings() {
        this.updateDefaultChannel();
    }

    private void updateDefaultChannel() {
        if (ApplicationInfoImpl.getShadowInstance().isEAP()) {
            this.UPDATE_CHANNEL_TYPE = "eap";
        }
    }

    public Element getState() {
        Element element = new Element("state");
        try {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
        }
        return element;
    }

    public void loadState(Element state) {
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)state);
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
        }
        this.updateDefaultChannel();
    }

    @Override
    @NotNull
    public List<String> getKnownChannelsIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String channel : this.myKnownUpdateChannels) {
            ids.add(channel);
        }
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getKnownChannelsIds"));
        }
        return arrayList;
    }

    @Override
    public void setKnownChannelIds(@NotNull List<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "setKnownChannelIds"));
        }
        this.myKnownUpdateChannels.clear();
        for (String id : ids) {
            this.myKnownUpdateChannels.add((Object)id);
        }
    }

    public void forgetChannelId(String id) {
        this.myKnownUpdateChannels.remove((Object)id);
    }

    @Override
    public List<String> getIgnoredBuildNumbers() {
        return this.myIgnoredBuildNumbers;
    }

    @Override
    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        ChannelStatus channelStatus = ChannelStatus.fromCode(this.UPDATE_CHANNEL_TYPE);
        if (channelStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getSelectedChannelStatus"));
        }
        return channelStatus;
    }

    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>((Collection<String>)this.myPluginHosts);
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        return hosts;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.LAST_TIME_CHECKED = 0L;
    }

    public void saveLastCheckedInfo() {
        this.LAST_TIME_CHECKED = System.currentTimeMillis();
        this.LAST_BUILD_CHECKED = ApplicationInfo.getInstance().getBuild().asString();
    }

    public boolean canUseSecureConnection() {
        return this.SECURE_CONNECTION && NetUtils.isSniEnabled();
    }
}

