/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.InitializableFilter;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;

public class GeneratorFilter
implements ElementFilter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.filters.GeneratorFilter");
    private final ContextGetter myGetter;
    private final Class myFilterClass;
    private SoftReference<PsiElement> myCachedElement = new SoftReference(null);
    private SoftReference<ElementFilter> myCachedFilter = new SoftReference(null);

    public GeneratorFilter(Class filterClass, ContextGetter getter) {
        this.myFilterClass = filterClass;
        this.myGetter = getter;
    }

    public boolean isClassAcceptable(Class hintClass) {
        ElementFilter filter = this.getFilter();
        return filter == null || filter.isClassAcceptable(hintClass);
    }

    private ElementFilter getFilter() {
        return (ElementFilter)this.myCachedFilter.get();
    }

    private ElementFilter getFilter(PsiElement context) {
        ElementFilter filter = (ElementFilter)this.myCachedFilter.get();
        if (this.myCachedElement.get() != context || filter == null) {
            filter = this.generateFilter(context);
            this.myCachedFilter = new SoftReference((Object)filter);
            this.myCachedElement = new SoftReference((Object)context);
        }
        return filter;
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element == null) {
            return false;
        }
        ElementFilter filter = this.getFilter(context);
        return filter != null && filter.isAcceptable(element, context);
    }

    private ElementFilter generateFilter(PsiElement context) {
        try {
            ElementFilter elementFilter = (ElementFilter)this.myFilterClass.newInstance();
            Object[] initArgument = this.myGetter.get(context, null);
            if (ReflectionUtil.isAssignable(InitializableFilter.class, (Class)this.myFilterClass) && initArgument != null) {
                ((InitializableFilter)elementFilter).init(initArgument);
                return elementFilter;
            }
            LOG.error("Filter initialization failed!");
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }
}

