/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    private String replacement;
    private List<ParameterInfo> parameterizations;
    private final Map<String, ScriptSupport> replacementVarsMap = new HashMap<String, ScriptSupport>();
    private final ReplaceOptions options;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        StructuralSearchProfile profile;
        this.options = options;
        String _replacement = options.getReplacement();
        FileType fileType = options.getMatchOptions().getFileType();
        Template template = TemplateManager.getInstance(project).createTemplate("", "", _replacement);
        int segmentsCount = template.getSegmentsCount();
        this.replacement = template.getTemplateText();
        for (int i = 0; i < segmentsCount; ++i) {
            int pos;
            int offset = template.getSegmentOffset(i);
            String name = template.getSegmentName(i);
            ParameterInfo info = new ParameterInfo();
            info.setStartIndex(offset);
            info.setName(name);
            info.setReplacementVariable(options.getVariableDefinition(name) != null);
            for (pos = offset - 1; pos >= 0 && pos < this.replacement.length() && Character.isWhitespace(this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info.setHasCommaBefore(true);
                }
                info.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && Character.isWhitespace(this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info.setArgumentContext(true);
                    info.setHasCommaAfter(ch == ',');
                }
            }
            info.setAfterDelimiterPos(pos);
            if (this.parameterizations == null) {
                this.parameterizations = new ArrayList<ParameterInfo>();
            }
            this.parameterizations.add(info);
        }
        StructuralSearchProfile structuralSearchProfile = profile = this.parameterizations != null ? StructuralSearchUtil.getProfileByFileType(fileType) : null;
        if (profile != null) {
            try {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(_replacement, PatternTreeContext.Block, fileType, options.getMatchOptions().getDialect(), options.getMatchOptions().getPatternContext(), project, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    profile.provideAdditionalReplaceOptions(patternNode, options, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException();
            }
        }
    }

    private static void fill(MatchResult r, Map<String, MatchResult> m) {
        List<MatchResult> allSons;
        if (r.getName() != null && m.get(r.getName()) == null) {
            m.put(r.getName(), r);
        }
        if (!r.isScopeMatch() || !r.isMultipleMatch()) {
            for (MatchResult matchResult : r.getAllSons()) {
                ReplacementBuilder.fill(matchResult, m);
            }
        } else if (r.hasSons() && (allSons = r.getAllSons()).size() > 0) {
            ReplacementBuilder.fill(allSons.get(0), m);
        }
    }

    String process(MatchResult match, ReplacementInfoImpl replacementInfo, FileType type) {
        if (this.parameterizations == null) {
            return this.replacement;
        }
        StringBuilder result = new StringBuilder(this.replacement);
        HashMap<String, MatchResult> matchMap = new HashMap<String, MatchResult>();
        ReplacementBuilder.fill(match, matchMap);
        int offset = 0;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        for (ParameterInfo info : this.parameterizations) {
            MatchResult r = matchMap.get(info.getName());
            if (info.isReplacementVariable()) {
                offset = Replacer.insertSubstitution(result, offset, info, this.generateReplacement(info, match));
                continue;
            }
            if (r != null) {
                offset = profile != null ? profile.handleSubstitution(info, r, result, offset, matchMap) : StructuralSearchProfile.defaultHandleSubstitution(info, r, result, offset);
                continue;
            }
            if (info.isHasCommaBefore()) {
                result.delete(info.getBeforeDelimiterPos() + offset, info.getBeforeDelimiterPos() + 1 + offset);
                --offset;
            } else if (info.isHasCommaAfter()) {
                result.delete(info.getAfterDelimiterPos() + offset, info.getAfterDelimiterPos() + 1 + offset);
                --offset;
            } else if (info.isVariableInitializerContext()) {
                result.delete(info.getBeforeDelimiterPos() + offset, info.getAfterDelimiterPos() + offset - 1);
                offset -= info.getAfterDelimiterPos() - info.getBeforeDelimiterPos() - 1;
            } else if (profile != null) {
                offset = profile.processAdditionalOptions(info, offset, result, r);
            }
            offset = Replacer.insertSubstitution(result, offset, info, "");
        }
        replacementInfo.variableMap = (HashMap)matchMap.clone();
        matchMap.clear();
        return result.toString();
    }

    private String generateReplacement(ParameterInfo info, MatchResult match) {
        ScriptSupport scriptSupport = this.replacementVarsMap.get(info.getName());
        if (scriptSupport == null) {
            String constraint = this.options.getVariableDefinition(info.getName()).getScriptCodeConstraint();
            scriptSupport = new ScriptSupport(StringUtil.stripQuotesAroundValue((String)constraint), info.getName());
            this.replacementVarsMap.put(info.getName(), scriptSupport);
        }
        return scriptSupport.evaluate((MatchResultImpl)match, null);
    }

    @Nullable
    public ParameterInfo findParameterization(String name) {
        if (this.parameterizations == null) {
            return null;
        }
        for (ParameterInfo info : this.parameterizations) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public void clear() {
        this.replacement = null;
        if (this.parameterizations != null) {
            this.parameterizations.clear();
            this.parameterizations = null;
        }
    }

    public void addParametrization(@NotNull ParameterInfo e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder", "addParametrization"));
        }
        assert (this.parameterizations != null);
        this.parameterizations.add(e);
    }
}

