/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.IdeView;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.HeavyIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

class HeavyIdeaTestFixtureImpl
extends BaseFixture
implements HeavyIdeaTestFixture {
    @NonNls
    private static final String PROJECT_FILE_SUFFIX = ".ipr";
    private Project myProject;
    private final Set<File> myFilesToDelete;
    private IdeaTestApplication myApplication;
    private final Set<ModuleFixtureBuilder> myModuleFixtureBuilders;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private final String myName;

    public HeavyIdeaTestFixtureImpl(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl", "<init>"));
        }
        this.myFilesToDelete = new HashSet<File>();
        this.myModuleFixtureBuilders = new LinkedHashSet<ModuleFixtureBuilder>();
        this.myName = name;
    }

    protected void addModuleFixtureBuilder(ModuleFixtureBuilder builder) {
        this.myModuleFixtureBuilders.add(builder);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        this.setUpProject();
        EncodingManager.getInstance();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        InjectedLanguageManagerImpl.pushInjectors(this.getProject());
    }

    @Override
    public void tearDown() throws Exception {
        Project project = this.getProject();
        LightPlatformTestCase.doTearDown(project, this.myApplication, false);
        for (ModuleFixtureBuilder moduleFixtureBuilder : this.myModuleFixtureBuilders) {
            moduleFixtureBuilder.getFixture().tearDown();
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Disposer.dispose((Disposable)HeavyIdeaTestFixtureImpl.this.myProject);
                        HeavyIdeaTestFixtureImpl.this.myProject = null;
                    }
                });
            }
        });
        for (File fileToDelete : this.myFilesToDelete) {
            boolean deleted = FileUtil.delete((File)fileToDelete);
            Assert.assertTrue((String)("Can't delete " + fileToDelete), (boolean)deleted);
        }
        super.tearDown();
        this.myEditorListenerTracker.checkListenersLeak();
        this.myThreadTracker.checkLeak();
        LightPlatformTestCase.checkEditorsReleased();
        PlatformTestCase.cleanupApplicationCaches(project);
        InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project);
    }

    private void setUpProject() throws Exception {
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                File tempDirectory = FileUtil.createTempDirectory((String)HeavyIdeaTestFixtureImpl.this.myName, (String)"");
                PlatformTestCase.synchronizeTempDirVfs(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory));
                HeavyIdeaTestFixtureImpl.this.myFilesToDelete.add(tempDirectory);
                File projectFile = new File(tempDirectory, HeavyIdeaTestFixtureImpl.this.myName + HeavyIdeaTestFixtureImpl.PROJECT_FILE_SUFFIX);
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
                HeavyIdeaTestFixtureImpl.this.myProject = PlatformTestCase.createProject(projectFile, buffer.toString());
                for (ModuleFixtureBuilder moduleFixtureBuilder : HeavyIdeaTestFixtureImpl.this.myModuleFixtureBuilders) {
                    moduleFixtureBuilder.getFixture().setUp();
                }
                StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject);
                sm.runStartupActivities();
                sm.startCacheUpdate();
                sm.runPostStartupActivities();
                ProjectManagerEx.getInstanceEx().openTestProject(HeavyIdeaTestFixtureImpl.this.myProject);
                LightPlatformTestCase.clearUncommittedDocuments(HeavyIdeaTestFixtureImpl.this.myProject);
                ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
            }
        }.execute().throwException();
    }

    private void initApplication() throws Exception {
        this.myApplication = IdeaTestApplication.getInstance(null);
        this.myApplication.setDataProvider(new MyDataProvider());
    }

    @Override
    public Project getProject() {
        Assert.assertNotNull((String)"setUp() should be called first", (Object)this.myProject);
        return this.myProject;
    }

    @Override
    public Module getModule() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        return modules.length == 0 ? null : modules[0];
    }

    @Override
    public PsiFile addFileToProject(@NotNull @NonNls String rootPath, final @NotNull @NonNls String relativePath, final @NotNull @NonNls String fileText) throws IOException {
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl", "addFileToProject"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl", "addFileToProject"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl", "addFileToProject"));
        }
        final VirtualFile dir = VfsUtil.createDirectories((String)(rootPath + "/" + PathUtil.getParentPath((String)relativePath)));
        final VirtualFile[] virtualFile = new VirtualFile[1];
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFile[0] = dir.createChildData((Object)this, StringUtil.getShortName((String)relativePath, (char)'/'));
                VfsUtil.saveText((VirtualFile)virtualFile[0], (String)fileText);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            }
        }.execute();
        return (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.getProject()).findFile(virtualFile[0]);
            }
        });
    }

    private class MyDataProvider
    implements DataProvider {
        private MyDataProvider() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return HeavyIdeaTestFixtureImpl.this.myProject;
            }
            if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                if (HeavyIdeaTestFixtureImpl.this.myProject == null) {
                    return null;
                }
                return FileEditorManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getSelectedTextEditor();
            }
            Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
            if (editor != null) {
                FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx(HeavyIdeaTestFixtureImpl.this.myProject);
                return manager.getData(dataId, editor, editor.getCaretModel().getCurrentCaret());
            }
            if (LangDataKeys.IDE_VIEW.is(dataId)) {
                VirtualFile[] contentRoots = ProjectRootManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).getContentRoots();
                final PsiDirectory psiDirectory = PsiManager.getInstance((Project)HeavyIdeaTestFixtureImpl.this.myProject).findDirectory(contentRoots[0]);
                if (contentRoots.length > 0) {
                    return new IdeView(){

                        public void selectElement(PsiElement element) {
                        }

                        @NotNull
                        public PsiDirectory[] getDirectories() {
                            PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                            if (psiDirectoryArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/HeavyIdeaTestFixtureImpl$MyDataProvider$1", "getDirectories"));
                            }
                            return psiDirectoryArray;
                        }

                        public PsiDirectory getOrChooseDirectory() {
                            return psiDirectory;
                        }
                    };
                }
            }
            return null;
        }
    }
}

