/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="RecentsManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class RecentsManager
implements PersistentStateComponent<Element> {
    private final Map<String, LinkedList<String>> myMap = new HashMap();
    private int myRecentsNumberToKeep = 5;
    @NonNls
    private static final String KEY_ELEMENT_NAME = "key";
    @NonNls
    private static final String RECENT_ELEMENT_NAME = "recent";
    @NonNls
    protected static final String NAME_ATTR = "name";

    public static RecentsManager getInstance(Project project) {
        return (RecentsManager)ServiceManager.getService((Project)project, RecentsManager.class);
    }

    @Nullable
    public List<String> getRecentEntries(String key) {
        return this.myMap.get(key);
    }

    public void registerRecentEntry(String key, String recentEntry) {
        LinkedList<String> recents = this.myMap.get(key);
        if (recents == null) {
            recents = new LinkedList();
            this.myMap.put(key, recents);
        }
        this.add(recents, recentEntry);
    }

    private void add(LinkedList<String> recentEntrues, String newEntry) {
        int oldIndex = recentEntrues.indexOf(newEntry);
        if (oldIndex >= 0) {
            recentEntrues.remove(oldIndex);
        } else if (recentEntrues.size() == this.myRecentsNumberToKeep) {
            recentEntrues.removeLast();
        }
        recentEntrues.addFirst(newEntry);
    }

    public void loadState(Element element) {
        this.myMap.clear();
        List keyElements = element.getChildren(KEY_ELEMENT_NAME);
        for (Element keyElement : keyElements) {
            String key = keyElement.getAttributeValue(NAME_ATTR);
            LinkedList<String> recents = new LinkedList<String>();
            List children = keyElement.getChildren(RECENT_ELEMENT_NAME);
            Iterator iterator1 = children.iterator();
            while (iterator1.hasNext()) {
                recents.addLast(((Element)iterator1.next()).getAttributeValue(NAME_ATTR));
            }
            this.myMap.put(key, recents);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        Set<Map.Entry<String, LinkedList<String>>> entries = this.myMap.entrySet();
        for (Map.Entry<String, LinkedList<String>> entry : entries) {
            Element keyElement = new Element(KEY_ELEMENT_NAME);
            keyElement.setAttribute(NAME_ATTR, entry.getKey());
            LinkedList<String> recents = entry.getValue();
            for (String recent : recents) {
                Element recentElement = new Element(RECENT_ELEMENT_NAME);
                recentElement.setAttribute(NAME_ATTR, recent);
                keyElement.addContent(recentElement);
            }
            element.addContent(keyElement);
        }
        return element;
    }

    public void setRecentsNumberToKeep(int recentsNumberToKeep) {
        this.myRecentsNumberToKeep = recentsNumberToKeep;
    }
}

