/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.HtmlTableBuilder;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.RefPainter;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    private static final String STANDARD_LAYER = "Standard";
    private static final String MESSAGE_LAYER = "Message";
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefsPanel myRefsPanel;
    @NotNull
    private final DataPanel myCommitDetailsPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JPanel myMainContentPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private VisiblePack myDataPack;
    @Nullable
    private VcsFullCommitDetails myCurrentCommitDetails;

    DetailsPanel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogGraphTable graphTable, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        this.myLogDataHolder = logDataHolder;
        this.myGraphTable = graphTable;
        this.myColorManager = colorManager;
        this.myDataPack = initialDataPack;
        this.myRefsPanel = new RefsPanel(this.myColorManager);
        this.myCommitDetailsPanel = new DataPanel(logDataHolder.getProject(), logDataHolder.isMultiRoot());
        this.myScrollPane = new JBScrollPane(20, 31);
        this.myMainContentPanel = new JPanel((LayoutManager)new MigLayout("flowy, ins 0, hidemode 3, gapy 0")){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = DetailsPanel.this.myScrollPane.getViewport().getWidth() - 5;
                return size;
            }
        };
        this.myMainContentPanel.setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setViewportView(this.myMainContentPanel);
        this.myMainContentPanel.add((Component)this.myRefsPanel, "");
        this.myMainContentPanel.add((Component)this.myCommitDetailsPanel, "");
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), logDataHolder, 300){

            public Color getBackground() {
                return DetailsPanel.getDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.myMessagePanel = new MessagePanel();
        this.setLayout(new CardLayout());
        this.add((Component)this.myLoadingPanel, STANDARD_LAYER);
        this.add((Component)((Object)this.myMessagePanel), MESSAGE_LAYER);
        this.showMessage("No commits selected");
    }

    @Override
    public Color getBackground() {
        return DetailsPanel.getDetailsBackground();
    }

    private static Color getDetailsBackground() {
        return UIUtil.getTableBackground();
    }

    void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent notUsed) {
        if (notUsed != null && notUsed.getValueIsAdjusting()) {
            return;
        }
        VcsFullCommitDetails newCommitDetails = null;
        int[] rows = this.myGraphTable.getSelectedRows();
        if (rows.length < 1) {
            this.showMessage("No commits selected");
        } else if (rows.length > 1) {
            this.showMessage("Several commits selected");
        } else {
            ((CardLayout)this.getLayout()).show(this, STANDARD_LAYER);
            int row = rows[0];
            GraphTableModel tableModel = (GraphTableModel)this.myGraphTable.getModel();
            VcsFullCommitDetails commitData = (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(row, tableModel);
            if (commitData == null) {
                this.showMessage("No commits selected");
                return;
            }
            if (commitData instanceof LoadingDetails) {
                this.myLoadingPanel.startLoading();
                this.myCommitDetailsPanel.setData(null);
                this.myRefsPanel.setRefs(Collections.<VcsRef>emptyList());
                this.updateDetailsBorder(null);
            } else {
                this.myLoadingPanel.stopLoading();
                this.myCommitDetailsPanel.setData(commitData);
                this.myRefsPanel.setRefs(this.sortRefs((Hash)commitData.getId(), commitData.getRoot()));
                this.updateDetailsBorder(commitData);
                newCommitDetails = commitData;
            }
            List<String> branches = null;
            if (!(commitData instanceof LoadingDetails)) {
                branches = this.myLogDataHolder.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), (Hash)commitData.getId());
            }
            this.myCommitDetailsPanel.setBranches(branches);
            if (!Comparing.equal((Object)this.myCurrentCommitDetails, (Object)newCommitDetails)) {
                this.myCurrentCommitDetails = newCommitDetails;
                this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    private void updateDetailsBorder(@Nullable VcsFullCommitDetails data) {
        if (data == null || !this.myColorManager.isMultipleRoots()) {
            this.myMainContentPanel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            JBColor color = VcsLogGraphTable.getRootBackgroundColor(data.getRoot(), this.myColorManager);
            this.myMainContentPanel.setBorder(new CompoundBorder(new MatteBorder(0, 8, 0, 0, (Color)color), new MatteBorder(0, 5, 0, 0, (Color)new JBColor((NotNullProducer)new NotNullProducer<Color>(){

                @NotNull
                public Color produce() {
                    Color color = DetailsPanel.getDetailsBackground();
                    if (color == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel$3", "produce"));
                    }
                    return color;
                }
            }))));
        }
    }

    private void showMessage(String text) {
        this.myLoadingPanel.stopLoading();
        ((CardLayout)this.getLayout()).show(this, MESSAGE_LAYER);
        this.myMessagePanel.setText(text);
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(hash);
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogDataHolder.getLogProvider(root).getReferenceManager().getLabelsOrderComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        return list;
    }

    private static class MessagePanel
    extends NonOpaquePanel {
        private final JLabel myLabel = new JLabel();

        MessagePanel() {
            super((LayoutManager)new BorderLayout());
            this.myLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(0);
            this.add(this.myLabel);
        }

        void setText(String text) {
            this.myLabel.setText(text);
        }

        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class SingleRefPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private VcsRef myRef;

        SingleRefPanel(@NotNull RefPainter refPainter, @NotNull VcsRef ref) {
            if (refPainter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refPainter", "com/intellij/vcs/log/ui/frame/DetailsPanel$SingleRefPanel", "<init>"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/ui/frame/DetailsPanel$SingleRefPanel", "<init>"));
            }
            this.myRefPainter = refPainter;
            this.myRef = ref;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.draw((Graphics2D)g, Collections.singleton(this.myRef), 0, this.getWidth());
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.myRefPainter.getComponentWidth(this.myRef.getName(), this.getFontMetrics(RefPainter.DEFAULT_FONT));
            return new Dimension(width, 26);
        }
    }

    private static class RefsPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private List<VcsRef> myRefs;

        RefsPanel(@NotNull VcsLogColorManager colorManager) {
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "<init>"));
            }
            super(new FlowLayout(3, 0, 2));
            this.myRefPainter = new RefPainter(colorManager, false);
            this.myRefs = Collections.emptyList();
            this.setOpaque(false);
        }

        void setRefs(@NotNull List<VcsRef> refs) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "setRefs"));
            }
            this.removeAll();
            this.myRefs = refs;
            for (VcsRef ref : refs) {
                this.add(new SingleRefPanel(this.myRefPainter, ref));
            }
            this.setVisible(!this.myRefs.isEmpty());
            this.revalidate();
            this.repaint();
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class DataPanel
    extends JEditorPane {
        public static final int BRANCHES_LIMIT = 6;
        public static final int BRANCHES_TABLE_COLUMN_COUNT = 3;
        @NotNull
        public static final String LEFT_ALIGN = "left";
        @NotNull
        private static String SHOW_OR_HIDE_BRANCHES = "Show or Hide Branches";
        @NotNull
        private final Project myProject;
        private final boolean myMultiRoot;
        private String myMainText;
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded;

        DataPanel(@NotNull Project project, boolean multiRoot) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "<init>"));
            }
            super("text/html", "");
            this.myExpanded = false;
            this.myProject = project;
            this.myMultiRoot = multiRoot;
            this.setEditable(false);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && SHOW_OR_HIDE_BRANCHES.equals(e.getDescription())) {
                        DataPanel.this.myExpanded = !DataPanel.this.myExpanded;
                        DataPanel.this.update();
                    } else {
                        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
                    }
                }
            });
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String header = ((Hash)commit.getId()).toShortString() + " " + DataPanel.getAuthorText(commit) + (this.myMultiRoot ? " [" + commit.getRoot().getName() + "]" : "");
                String body = this.getMessageText(commit);
                this.myMainText = header + "<br/>" + body;
            }
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
            this.update();
        }

        private void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + this.myMainText + "<br/>" + "<br/>" + this.getBranchesText() + "</body></html>");
            }
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getBranchesText() {
            if (this.myBranches == null) {
                if ("<i>In branches: loading...</i>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "getBranchesText"));
                }
                return "<i>In branches: loading...</i>";
            }
            if (this.myExpanded) {
                int rowCount = (int)Math.ceil((double)this.myBranches.size() / 3.0);
                HtmlTableBuilder builder = new HtmlTableBuilder();
                for (int i = 0; i < rowCount; ++i) {
                    builder.startRow();
                    if (i == 0) {
                        builder.append("<i>In " + this.myBranches.size() + " branches, </i><a href=\"" + SHOW_OR_HIDE_BRANCHES + "\"><i>hide</i></a>: ");
                    } else {
                        builder.append("");
                    }
                    for (int j = 0; j < 3; ++j) {
                        int index = rowCount * j + i;
                        if (index >= this.myBranches.size()) {
                            builder.append("");
                            continue;
                        }
                        if (index != this.myBranches.size() - 1) {
                            builder.append(this.myBranches.get(index) + "," + StringUtil.repeat((String)"&nbsp;", (int)20), LEFT_ALIGN);
                            continue;
                        }
                        builder.append(this.myBranches.get(index), LEFT_ALIGN);
                    }
                    builder.endRow();
                }
                String string = builder.build();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "getBranchesText"));
                }
                return string;
            }
            String branchText = this.myBranches.size() <= 6 ? StringUtil.join(this.myBranches, (String)", ") : StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myBranches, (int)6), (String)", ") + ", ... <a href=\"" + SHOW_OR_HIDE_BRANCHES + "\"><i>Show All</i></a>";
            String string = "<i>In " + this.myBranches.size() + StringUtil.pluralize((String)" branch", (int)this.myBranches.size()) + ":</i> " + branchText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "getBranchesText"));
            }
            return string;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = Math.max(size.height, 4 * this.getFontMetrics(this.getFont()).getHeight());
            return size;
        }

        private String getMessageText(VcsFullCommitDetails commit) {
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            return "<b>" + this.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject)) + "</b>" + this.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description));
        }

        private String escapeMultipleSpaces(String text) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == ' ') {
                    if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                        result.append(' ');
                        continue;
                    }
                    result.append("&nbsp;");
                    continue;
                }
                result.append(text.charAt(i));
            }
            return result.toString();
        }

        private static String getAuthorText(VcsFullCommitDetails commit) {
            String authorText = commit.getAuthor().getName() + " at " + DateFormatUtil.formatDateTime((long)commit.getAuthorTime());
            if (!commit.getAuthor().equals(commit.getCommitter())) {
                String commitTime = commit.getAuthorTime() != commit.getCommitTime() ? " at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) : "";
                authorText = authorText + " (committed by " + commit.getCommitter().getName() + commitTime + ")";
            } else if (commit.getAuthorTime() != commit.getCommitTime()) {
                authorText = authorText + " (committed at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) + ")";
            }
            return authorText;
        }

        @Override
        public String getSelectedText() {
            Document doc = this.getDocument();
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            try {
                Position p0 = doc.createPosition(start);
                Position p1 = doc.createPosition(end);
                StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
                this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
                MyHtml2Text parser = new MyHtml2Text();
                parser.parse(new StringReader(sw.toString()));
                return parser.getText();
            }
            catch (BadLocationException e) {
                LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            return super.getSelectedText();
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }

        private static class MyHtml2Text
        extends HTMLEditorKit.ParserCallback {
            @NotNull
            private final StringBuilder myBuffer = new StringBuilder();

            private MyHtml2Text() {
            }

            public void parse(Reader in) throws IOException {
                this.myBuffer.setLength(0);
                new ParserDelegator().parse(in, this, Boolean.TRUE);
            }

            @Override
            public void handleText(char[] text, int pos) {
                if (this.myBuffer.length() > 0) {
                    this.myBuffer.append(SystemProperties.getLineSeparator());
                }
                this.myBuffer.append(text);
            }

            public String getText() {
                return this.myBuffer.toString();
            }
        }
    }
}

