/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionPointHighlighter {
    private final Project myProject;
    private RangeHighlighter myRangeHighlighter;
    private Editor myEditor;
    private XSourcePosition mySourcePosition;
    private OpenFileDescriptor myOpenFileDescriptor;
    private boolean myNotTopFrame;
    private GutterIconRenderer myGutterIconRenderer;
    private static final Key<Boolean> EXECUTION_POINT_HIGHLIGHTER_KEY = Key.create((String)"EXECUTION_POINT_HIGHLIGHTER_KEY");
    private final AtomicBoolean updateRequested = new AtomicBoolean();

    public ExecutionPointHighlighter(Project project) {
        this.myProject = project;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        if (colorsManager != null) {
            colorsManager.addEditorColorsListener(new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    ExecutionPointHighlighter.this.update(false);
                }
            }, (Disposable)project);
        }
    }

    public void show(final @NotNull XSourcePosition position, final boolean notTopFrame, final @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "show"));
        }
        this.updateRequested.set(false);
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.updateRequested.set(false);
                ExecutionPointHighlighter.this.mySourcePosition = position;
                ExecutionPointHighlighter.this.clearDescriptor();
                ExecutionPointHighlighter.this.myOpenFileDescriptor = XSourcePositionImpl.createOpenFileDescriptor(ExecutionPointHighlighter.this.myProject, position);
                ExecutionPointHighlighter.this.myGutterIconRenderer = gutterIconRenderer;
                ExecutionPointHighlighter.this.myNotTopFrame = notTopFrame;
                ExecutionPointHighlighter.this.doShow(true);
            }
        });
    }

    public void hide() {
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                ExecutionPointHighlighter.this.updateRequested.set(false);
                ExecutionPointHighlighter.this.removeHighlighter();
                ExecutionPointHighlighter.this.clearDescriptor();
                ExecutionPointHighlighter.this.myEditor = null;
                ExecutionPointHighlighter.this.myGutterIconRenderer = null;
            }
        });
    }

    private void clearDescriptor() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.dispose();
            this.myOpenFileDescriptor = null;
        }
    }

    public void navigateTo() {
        if (this.myOpenFileDescriptor != null) {
            this.myOpenFileDescriptor.navigateInEditor(this.myProject, true);
        }
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myOpenFileDescriptor != null ? this.myOpenFileDescriptor.getFile() : null;
    }

    public void update(final boolean navigate) {
        if (this.updateRequested.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ExecutionPointHighlighter.this.updateRequested.compareAndSet(true, false)) {
                        ExecutionPointHighlighter.this.doShow(navigate);
                    }
                }
            }, this.myProject.getDisposed());
        }
    }

    public void updateGutterIcon(final @NotNull GutterIconRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "updateGutterIcon"));
        }
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                if (ExecutionPointHighlighter.this.myRangeHighlighter != null && ExecutionPointHighlighter.this.myGutterIconRenderer != null) {
                    ExecutionPointHighlighter.this.myRangeHighlighter.setGutterIconRenderer(renderer);
                }
            }
        });
    }

    private void doShow(boolean navigate) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.removeHighlighter();
        OpenFileDescriptor fileDescriptor = this.myOpenFileDescriptor;
        if (!navigate && this.myOpenFileDescriptor != null) {
            fileDescriptor = new OpenFileDescriptor(this.myProject, this.myOpenFileDescriptor.getFile());
        }
        Editor editor = this.myEditor = fileDescriptor == null ? null : XDebuggerUtilImpl.createEditor(fileDescriptor);
        if (this.myEditor != null) {
            this.addHighlighter();
        }
    }

    private void removeHighlighter() {
        if (this.myEditor != null) {
            ExecutionPointHighlighter.adjustCounter(this.myEditor, -1);
        }
        if (this.myRangeHighlighter != null) {
            this.myRangeHighlighter.dispose();
            this.myRangeHighlighter = null;
        }
    }

    private void addHighlighter() {
        ExecutionPointHighlighter.adjustCounter(this.myEditor, 1);
        int line = this.mySourcePosition.getLine();
        Document document = this.myEditor.getDocument();
        if (line < 0 || line >= document.getLineCount()) {
            return;
        }
        if (this.myRangeHighlighter != null) {
            return;
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myRangeHighlighter = DocumentMarkupModel.forDocument(document, this.myProject, true).addLineHighlighter(line, 5999, this.myNotTopFrame ? scheme.getAttributes(DebuggerColors.NOT_TOP_FRAME_ATTRIBUTES) : scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES));
        this.myRangeHighlighter.putUserData(EXECUTION_POINT_HIGHLIGHTER_KEY, (Object)true);
        this.myRangeHighlighter.setGutterIconRenderer(this.myGutterIconRenderer);
    }

    private static void adjustCounter(final @NotNull Editor editor, final int increment) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/ui/ExecutionPointHighlighter", "adjustCounter"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent component = editor.getComponent();
                Object o = component.getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING);
                Integer value = (o instanceof Integer ? (Integer)o : 0) + increment;
                component.putClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING, value > 0 ? value : null);
            }
        });
    }
}

