/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ValueNodeAsyncFunction;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public final class Variables {
    private static final Pattern UNNAMED_FUNCTION_PATTERN = Pattern.compile("^function[\\t ]*\\(");
    private static final Comparator<Variable> NATURAL_NAME_COMPARATOR = new Comparator<Variable>(){

        @Override
        public int compare(@NotNull Variable o1, @NotNull Variable o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/debugger/Variables$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/debugger/Variables$1", "compare"));
            }
            return Variables.naturalCompare(o1.getName(), o2.getName());
        }
    };

    @NotNull
    public static Promise<Void> processVariables(@NotNull VariableContext context, final @NotNull Promise<List<Variable>> variables, final @NotNull Obsolescent obsolescent, final @NotNull PairConsumer<MemberFilter, List<Variable>> consumer) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/Variables", "processVariables"));
        }
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "processVariables"));
        }
        if (obsolescent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obsolescent", "org/jetbrains/debugger/Variables", "processVariables"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/debugger/Variables", "processVariables"));
        }
        Promise promise = context.getMemberFilter().then((AsyncFunction)new ValueNodeAsyncFunction<MemberFilter, Void>(obsolescent){

            @NotNull
            public Promise<Void> fun(final MemberFilter memberFilter) {
                Promise promise = variables.then((Function)new ObsolescentFunction<List<Variable>, Void>(){

                    public boolean isObsolete() {
                        return obsolescent.isObsolete();
                    }

                    public Void fun(List<Variable> variables) {
                        consumer.consume((Object)memberFilter, variables);
                        return null;
                    }
                });
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables$2", "fun"));
                }
                return promise;
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "processVariables"));
        }
        return promise;
    }

    @NotNull
    public static Promise<Void> processScopeVariables(@NotNull Scope scope, final @NotNull XCompositeNode node, final @NotNull VariableContext context, final boolean isLast) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        Promise<Void> promise = Variables.processVariables(context, scope.getVariablesHost().get(), (Obsolescent)node, new PairConsumer<MemberFilter, List<Variable>>(){

            public void consume(final MemberFilter memberFilter, List<Variable> variables) {
                Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
                ArrayList<Variable> properties = new ArrayList<Variable>(variables.size() + additionalVariables.size());
                SmartList functions = new SmartList();
                for (Variable variable : variables) {
                    if (!memberFilter.isMemberVisible(variable, false)) continue;
                    Value value = variable.getValue();
                    if (value != null && value.getType() == ValueType.FUNCTION && value.getValueString() != null && !UNNAMED_FUNCTION_PATTERN.matcher(value.getValueString()).lookingAt()) {
                        functions.add(variable);
                        continue;
                    }
                    properties.add(variable);
                }
                Comparator<Variable> comparator = memberFilter.hasNameMappings() ? new Comparator<Variable>(){

                    @Override
                    public int compare(@NotNull Variable o1, @NotNull Variable o2) {
                        if (o1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/debugger/Variables$3$1", "compare"));
                        }
                        if (o2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/debugger/Variables$3$1", "compare"));
                        }
                        return Variables.naturalCompare(memberFilter.getName(o1), memberFilter.getName(o2));
                    }
                } : NATURAL_NAME_COMPARATOR;
                Collections.sort(properties, comparator);
                Collections.sort(functions, comparator);
                Variables.addAditionalVariables(variables, additionalVariables, properties, memberFilter);
                if (!properties.isEmpty()) {
                    node.addChildren(Variables.createVariablesList(properties, context, memberFilter), functions.isEmpty() && isLast);
                }
                if (!functions.isEmpty()) {
                    node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new VariablesGroup("Functions", (List<Variable>)functions, context)), isLast);
                } else if (isLast && properties.isEmpty()) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "processScopeVariables"));
        }
        return promise;
    }

    @Nullable
    public static List<Variable> processNamedObjectProperties(@NotNull List<Variable> variables, @NotNull XCompositeNode node, @NotNull VariableContext context, @NotNull MemberFilter memberFilter, int maxChildrenToAdd, boolean defaultIsLast) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "processNamedObjectProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/Variables", "processNamedObjectProperties"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/Variables", "processNamedObjectProperties"));
        }
        if (memberFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFilter", "org/jetbrains/debugger/Variables", "processNamedObjectProperties"));
        }
        List<Variable> list = Variables.filterAndSort(variables, memberFilter, true);
        if (list.isEmpty()) {
            if (defaultIsLast) {
                node.addChildren(XValueChildrenList.EMPTY, true);
            }
            return null;
        }
        int to = Math.min(maxChildrenToAdd, list.size());
        boolean isLast = to == list.size();
        node.addChildren(Variables.createVariablesList(list, 0, to, context, memberFilter), defaultIsLast && isLast);
        if (isLast) {
            return null;
        }
        node.tooManyChildren(list.size() - to);
        return list;
    }

    @NotNull
    public static List<Variable> filterAndSort(@NotNull List<Variable> variables, @NotNull MemberFilter memberFilter, boolean filterFunctions) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "filterAndSort"));
        }
        if (memberFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFilter", "org/jetbrains/debugger/Variables", "filterAndSort"));
        }
        if (variables.isEmpty()) {
            List<Variable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "filterAndSort"));
            }
            return list;
        }
        Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
        ArrayList<Variable> result = new ArrayList<Variable>(variables.size() + additionalVariables.size());
        for (Variable variable : variables) {
            if (!memberFilter.isMemberVisible(variable, filterFunctions)) continue;
            result.add(variable);
        }
        Collections.sort(result, NATURAL_NAME_COMPARATOR);
        Variables.addAditionalVariables(variables, additionalVariables, result, memberFilter);
        ArrayList<Variable> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "filterAndSort"));
        }
        return arrayList;
    }

    private static void addAditionalVariables(@NotNull List<? extends Variable> variables, @NotNull Collection<Variable> additionalVariables, @NotNull List<Variable> result, @NotNull MemberFilter memberFilter) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "addAditionalVariables"));
        }
        if (additionalVariables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalVariables", "org/jetbrains/debugger/Variables", "addAditionalVariables"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/Variables", "addAditionalVariables"));
        }
        if (memberFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberFilter", "org/jetbrains/debugger/Variables", "addAditionalVariables"));
        }
        block0: for (Variable variable : additionalVariables) {
            for (Variable variable2 : variables) {
                if (!memberFilter.getName(variable2).equals(memberFilter.getName(variable))) continue;
                continue block0;
            }
            result.add(variable);
        }
    }

    private static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit((char)ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit((char)ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit((char)string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit((char)string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (ch1 == ch2) continue;
            if (ch1 == '_') {
                return 1;
            }
            if (ch2 == '_') {
                return -1;
            }
            return ch1 - ch2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        return string1Length - string2Length;
    }

    @NotNull
    public static XValueChildrenList createVariablesList(@NotNull List<Variable> variables, @NotNull VariableContext variableContext) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContext", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        XValueChildrenList xValueChildrenList = Variables.createVariablesList(variables, variableContext, null);
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        return xValueChildrenList;
    }

    @NotNull
    public static XValueChildrenList createVariablesList(@NotNull List<Variable> variables, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContext", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        XValueChildrenList xValueChildrenList = Variables.createVariablesList(variables, 0, variables.size(), variableContext, memberFilter);
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        return xValueChildrenList;
    }

    @NotNull
    public static XValueChildrenList createVariablesList(@NotNull List<Variable> variables, int from, int to, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        if (variableContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableContext", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        XValueChildrenList list = new XValueChildrenList(to - from);
        NonWatchableVariableContext getterOrSetterContext = null;
        for (int i = from; i < to; ++i) {
            Variable variable = variables.get(i);
            String normalizedName = memberFilter == null ? variable.getName() : memberFilter.getName(variable);
            list.add((XNamedValue)new VariableView(normalizedName, variable, variableContext));
            if (!(variable instanceof ObjectProperty)) continue;
            ObjectProperty property = (ObjectProperty)variable;
            if (property.getGetter() != null) {
                if (getterOrSetterContext == null) {
                    getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                }
                list.add((XNamedValue)new VariableView(new VariableImpl("get " + normalizedName, property.getGetter()), getterOrSetterContext));
            }
            if (property.getSetter() == null) continue;
            if (getterOrSetterContext == null) {
                getterOrSetterContext = new NonWatchableVariableContext(variableContext);
            }
            list.add((XNamedValue)new VariableView(new VariableImpl("set " + normalizedName, property.getSetter()), getterOrSetterContext));
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/Variables", "createVariablesList"));
        }
        return xValueChildrenList;
    }

    private static final class NonWatchableVariableContext
    extends VariableContextWrapper {
        public NonWatchableVariableContext(VariableContext variableContext) {
            super(variableContext, null);
        }

        @Override
        public boolean watchableAsEvaluationExpression() {
            return false;
        }
    }
}

