/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;

class ExecutionStackImpl
extends XExecutionStack {
    private final SuspendContext suspendContext;
    private final Script topFrameScript;
    private CallFrameView topCallFrameView;
    private final DebuggerViewSupport debugProcess;

    public ExecutionStackImpl(@NotNull SuspendContext suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/frame/ExecutionStackImpl", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "org/jetbrains/debugger/frame/ExecutionStackImpl", "<init>"));
        }
        super("");
        this.debugProcess = debugProcess;
        this.suspendContext = suspendContext;
        this.topFrameScript = topFrameScript;
    }

    @Nullable
    public CallFrameView getTopFrame() {
        CallFrame topCallFrame = this.suspendContext.getTopFrame();
        if (this.topCallFrameView == null || this.topCallFrameView.getCallFrame() != topCallFrame) {
            this.topCallFrameView = topCallFrame == null ? null : new CallFrameView(topCallFrame, this.debugProcess, this.topFrameScript);
        }
        return this.topCallFrameView;
    }

    public void computeStackFrames(final int firstFrameIndex, final XExecutionStack.XStackFrameContainer container) {
        SuspendContext suspendContext = this.debugProcess.getVm().getSuspendContextManager().getContext();
        if (suspendContext == null) {
            return;
        }
        suspendContext.getFrames().done((Consumer)new ContextDependentAsyncResultConsumer<CallFrame[]>(suspendContext){

            @Override
            protected void consume(CallFrame[] frames, @NotNull Vm vm) {
                List result;
                if (vm == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vm", "org/jetbrains/debugger/frame/ExecutionStackImpl$1", "consume"));
                }
                int count = frames.length - firstFrameIndex;
                if (count < 1) {
                    result = Collections.emptyList();
                } else {
                    result = new ArrayList(count);
                    for (int i = firstFrameIndex; i < frames.length; ++i) {
                        CallFrame frame = frames[i];
                        Script script = vm.getScriptManager().getScript(frame);
                        if (script == null) continue;
                        result.add(new CallFrameView(frame, ExecutionStackImpl.this.debugProcess, script));
                    }
                }
                container.addStackFrames(result, true);
            }
        });
    }
}

