/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.frame.ExecutionStackImpl;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

public class SuspendContextImpl
extends XSuspendContext {
    private final ExecutionStackImpl executionStack;
    private final SuspendContext suspendContext;

    protected SuspendContextImpl(@NotNull SuspendContext suspendContext, @NotNull DebuggerViewSupport debugProcess, @Nullable Script topFrameScript) {
        if (suspendContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "org/jetbrains/debugger/frame/SuspendContextImpl", "<init>"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "org/jetbrains/debugger/frame/SuspendContextImpl", "<init>"));
        }
        this.executionStack = new ExecutionStackImpl(suspendContext, debugProcess, topFrameScript);
        this.suspendContext = suspendContext;
    }

    public void clearObjectCaches() {
        this.suspendContext.getValueManager().clearCaches();
    }

    @NotNull
    public XExecutionStack getActiveExecutionStack() {
        ExecutionStackImpl executionStackImpl = this.executionStack;
        if (executionStackImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "getActiveExecutionStack"));
        }
        return executionStackImpl;
    }

    @NotNull
    public Promise<String> evaluateExpression(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        CallFrameView frame = this.executionStack.getTopFrame();
        if (frame == null) {
            Promise promise = Promise.reject((String)"Top frame is null");
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
            }
            return promise;
        }
        Promise<String> promise = SuspendContextImpl.evaluateExpression(frame.getCallFrame().getEvaluateContext(), expression);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        return promise;
    }

    @NotNull
    private static Promise<String> evaluateExpression(@NotNull EvaluateContext evaluateContext, @NotNull String expression) {
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        Promise promise = evaluateContext.evaluate(expression).then((AsyncFunction)new AsyncFunction<EvaluateResult, String>(){

            @NotNull
            public Promise<String> fun(EvaluateResult result) {
                Value value = result.value;
                if (value == null) {
                    Promise promise = Promise.resolve((Object)"Log expression result doesn't have value");
                    if (promise == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl$1", "fun"));
                    }
                    return promise;
                }
                if (value instanceof StringValue && ((StringValue)value).isTruncated()) {
                    Promise<String> promise = ((StringValue)value).getFullString();
                    if (promise == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl$1", "fun"));
                    }
                    return promise;
                }
                Promise promise = Promise.resolve((Object)value.getValueString());
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl$1", "fun"));
                }
                return promise;
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/frame/SuspendContextImpl", "evaluateExpression"));
        }
        return promise;
    }
}

