/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;

public abstract class RestService
extends HttpRequestHandler {
    protected static final Logger LOG = Logger.getInstance(RestService.class);
    public static final String PREFIX = "api";
    protected final NotNullLazyValue<Gson> gson = new NotNullLazyValue<Gson>(){

        @NotNull
        protected Gson compute() {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            if (gson == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService$1", "compute"));
            }
            return gson;
        }
    };

    public final boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "isSupported"));
        }
        if (!this.isMethodSupported(request.method())) {
            return false;
        }
        String uri = request.uri();
        if (this.isPrefixlessAllowed() && RestService.checkPrefix((String)uri, (String)this.getServiceName())) {
            return true;
        }
        String serviceName = this.getServiceName();
        int minLength = 1 + PREFIX.length() + 1 + serviceName.length();
        if (uri.length() >= minLength && uri.charAt(0) == '/' && uri.regionMatches(true, 1, PREFIX, 0, PREFIX.length()) && uri.regionMatches(true, 2 + PREFIX.length(), serviceName, 0, serviceName.length())) {
            if (uri.length() == minLength) {
                return true;
            }
            char c = uri.charAt(minLength);
            return c == '/' || c == '?';
        }
        return false;
    }

    protected boolean isPrefixlessAllowed() {
        return false;
    }

    @NotNull
    protected abstract String getServiceName();

    protected abstract boolean isMethodSupported(@NotNull HttpMethod var1);

    public final boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "process"));
        }
        try {
            String error = this.execute(urlDecoder, request, context);
            if (error != null) {
                Responses.sendStatus(HttpResponseStatus.BAD_REQUEST, context.channel(), error, (HttpRequest)request);
            }
        }
        catch (Throwable e) {
            HttpResponseStatus status;
            if (e instanceof MalformedJsonException || e instanceof IllegalStateException && e.getMessage().startsWith("Expected a ")) {
                LOG.warn(e);
                status = HttpResponseStatus.BAD_REQUEST;
            } else {
                LOG.error(e);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
            Responses.sendStatus(status, context.channel(), ExceptionUtil.getThrowableText((Throwable)e), (HttpRequest)request);
        }
        return true;
    }

    @Nullable(value="error text or null if successful")
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    @NotNull
    protected static JsonReader createJsonReader(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(request.content()), CharsetToolkit.UTF8_CHARSET));
        reader.setLenient(true);
        JsonReader jsonReader = reader;
        if (jsonReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService", "createJsonReader"));
        }
        return jsonReader;
    }

    @NotNull
    protected static JsonWriter createJsonWriter(@NotNull BufferExposingByteArrayOutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/ide/RestService", "createJsonWriter"));
        }
        JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)out, CharsetToolkit.UTF8_CHARSET));
        writer.setIndent("  ");
        JsonWriter jsonWriter = writer;
        if (jsonWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/RestService", "createJsonWriter"));
        }
        return jsonWriter;
    }

    @Nullable
    protected static Project getLastFocusedOrOpenedProject() {
        Project project;
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = project = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
        if (project == null) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            return openProjects.length > 0 ? openProjects[0] : null;
        }
        return project;
    }

    protected static void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "sendOk"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "sendOk"));
        }
        RestService.sendStatus(HttpResponseStatus.OK, HttpHeaders.isKeepAlive((HttpMessage)request), context.channel());
    }

    protected static void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/ide/RestService", "sendStatus"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/ide/RestService", "sendStatus"));
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpHeaders.setContentLength((HttpMessage)response, (long)0L);
        Responses.addCommonHeaders((HttpResponse)response);
        Responses.addNoCache((HttpResponse)response);
        if (keepAlive) {
            HttpHeaders.setKeepAlive((HttpMessage)response, (boolean)true);
        }
        Responses.send((HttpResponse)response, channel, !keepAlive);
    }

    protected static void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        if (byteOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteOut", "org/jetbrains/ide/RestService", "send"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/RestService", "send"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/RestService", "send"));
        }
        FullHttpResponse response = Responses.response("application/json", Unpooled.wrappedBuffer((byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size()));
        Responses.addNoCache((HttpResponse)response);
        Responses.send((HttpResponse)response, context.channel(), (HttpRequest)request);
    }

    @Nullable
    protected static String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getStringParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getStringParameter"));
        }
        return (String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name)));
    }

    protected static int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getIntParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getIntParameter"));
        }
        return StringUtilRt.parseInt((String)StringUtil.nullize((String)((String)ContainerUtil.getLastItem((List)((List)urlDecoder.parameters().get(name)))), (boolean)true), (int)-1);
    }

    protected static boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        return RestService.getBooleanParameter(name, urlDecoder, false);
    }

    protected static boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/RestService", "getBooleanParameter"));
        }
        List values = (List)urlDecoder.parameters().get(name);
        if (ContainerUtil.isEmpty((Collection)values)) {
            return defaultValue;
        }
        String value = (String)values.get(values.size() - 1);
        return value.isEmpty() || Boolean.parseBoolean(value);
    }
}

