/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocExternalFilter
extends AbstractExternalFilter {
    private final Project myProject;
    private static final Trinity<Pattern, Pattern, Boolean> ourPackageInfoSettings = Trinity.create((Object)Pattern.compile("package\\s+[^\\s]+\\s+description", 2), (Object)Pattern.compile("START OF BOTTOM NAVBAR", 2), (Object)Boolean.TRUE);
    @NonNls
    protected static final Pattern ourHTMLsuffix = Pattern.compile("[.][hH][tT][mM][lL]?");
    @NonNls
    protected static final Pattern ourParentFolderprefix = Pattern.compile("^[.][.]/");
    @NonNls
    protected static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHTMLFilesuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourHREFselector = Pattern.compile("<A.*?HREF=\"([^>\"]*)\"", 34);
    @NonNls
    private static final Pattern ourMethodHeading = Pattern.compile("<H[34]>(.+?)</H[34]>", 34);
    @NonNls
    protected static final String DOC_ELEMENT_PROTOCOL = "doc_element://";
    @NonNls
    protected static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    private final AbstractExternalFilter.RefConvertor[] myReferenceConvertors = new AbstractExternalFilter.RefConvertor[]{new AbstractExternalFilter.RefConvertor(ourHREFselector){

        @Override
        protected String convertReference(String root, String href) {
            if (BrowserUtil.isAbsoluteURL((String)href)) {
                return href;
            }
            if (StringUtil.startsWithChar((CharSequence)href, (char)'#')) {
                return JavaDocExternalFilter.DOC_ELEMENT_PROTOCOL + root + href;
            }
            String nakedRoot = ourHTMLFilesuffix.matcher(root).replaceAll("/");
            String stripped = ourHTMLsuffix.matcher(href).replaceAll("");
            int len = stripped.length();
            while (len > (len = (stripped = ourParentFolderprefix.matcher(stripped).replaceAll("")).length())) {
            }
            String elementRef = stripped.replaceAll("/", ".");
            String classRef = ourAnchorsuffix.matcher(elementRef).replaceAll("");
            return JavaPsiFacade.getInstance((Project)JavaDocExternalFilter.this.myProject).findClass(classRef, GlobalSearchScope.allScope((Project)JavaDocExternalFilter.this.myProject)) != null ? "psi_element://" + elementRef : JavaDocExternalFilter.DOC_ELEMENT_PROTOCOL + JavaDocExternalFilter.doAnnihilate(nakedRoot + href);
        }
    }};

    public JavaDocExternalFilter(Project project) {
        this.myProject = project;
    }

    @Override
    protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
        return this.myReferenceConvertors;
    }

    @Nullable
    public static String filterInternalDocInfo(String text) {
        if (text == null) {
            return null;
        }
        text = PlatformDocumentationUtil.fixupText(text);
        return text;
    }

    @Override
    @Nullable
    public String getExternalDocInfoForElement(String docURL, final PsiElement element) throws Exception {
        String externalDoc = super.getExternalDocInfoForElement(docURL, element);
        if (externalDoc != null && element instanceof PsiMethod) {
            String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<String>(){

                @Nullable
                public String compute() {
                    PsiClass aClass = ((PsiMethod)element).getContainingClass();
                    return aClass == null ? null : aClass.getQualifiedName();
                }
            });
            Matcher matcher = ourMethodHeading.matcher(externalDoc);
            StringBuilder buffer = new StringBuilder();
            DocumentationManager.createHyperlink(buffer, className, className, false);
            return matcher.replaceFirst("<H3>" + buffer.toString() + "</H3>");
        }
        return externalDoc;
    }

    @Override
    @NotNull
    protected Trinity<Pattern, Pattern, Boolean> getParseSettings(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/codeInsight/javadoc/JavaDocExternalFilter", "getParseSettings"));
        }
        Trinity<Pattern, Pattern, Boolean> trinity = url.endsWith("package-summary.html") ? ourPackageInfoSettings : super.getParseSettings(url);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/javadoc/JavaDocExternalFilter", "getParseSettings"));
        }
        return trinity;
    }
}

