/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtil {
    public static JPanel createSpecialAnnotationsListControl(List<String> list, String borderTitle) {
        return SpecialAnnotationsUtil.createSpecialAnnotationsListControl(list, borderTitle, false);
    }

    public static JPanel createSpecialAnnotationsListControl(final List<String> list, String borderTitle, boolean acceptPatterns) {
        final SortedListModel listModel = new SortedListModel((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        JBList injectionList = new JBList((ListModel)listModel);
        for (String s : list) {
            listModel.add((Object)s);
        }
        injectionList.setSelectionMode(1);
        injectionList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.listChanged();
            }

            private void listChanged() {
                list.clear();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    list.add((String)listModel.getElementAt(i));
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.listChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                this.listChanged();
            }
        });
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)injectionList).setAddAction(new AnActionButtonRunnable((JList)injectionList, listModel){
            final /* synthetic */ JList val$injectionList;
            final /* synthetic */ SortedListModel val$listModel;
            {
                this.val$injectionList = jList;
                this.val$listModel = sortedListModel;
            }

            public void run(AnActionButton button) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.val$injectionList));
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser(InspectionsBundle.message((String)"special.annotations.list.annotation.class", (Object[])new Object[0]), GlobalSearchScope.allScope((Project)project), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass) {
                        return aClass.isAnnotationType();
                    }
                }, null);
                chooser.showDialog();
                PsiClass selected = chooser.getSelected();
                if (selected != null) {
                    this.val$listModel.add((Object)selected.getQualifiedName());
                }
            }
        }).setAddActionName(InspectionsBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0])).disableUpDownActions();
        if (acceptPatterns) {
            toolbarDecorator.setAddIcon(IconUtil.getAddClassIcon()).addExtraAction(new AnActionButton(InspectionsBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), IconUtil.getAddPatternIcon()){

                public void actionPerformed(AnActionEvent e) {
                    String selectedPattern = Messages.showInputDialog((String)InspectionsBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (selectedPattern != null) {
                        listModel.add((Object)selectedPattern);
                    }
                }
            }).setButtonComparator(new String[]{InspectionsBundle.message((String)"special.annotations.list.add.annotation.class", (Object[])new Object[0]), InspectionsBundle.message((String)"special.annotations.list.annotation.pattern", (Object[])new Object[0]), "Remove"});
        }
        if (borderTitle == null) {
            return toolbarDecorator.createPanel();
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)SeparatorFactory.createSeparator((String)borderTitle, null), "North");
        panel.add((Component)toolbarDecorator.createPanel(), "Center");
        return panel;
    }

    public static IntentionAction createAddToSpecialAnnotationsListIntentionAction(final String text, final String family, final List<String> targetList, final String qualifiedName) {
        return new IntentionAction(){

            @NotNull
            public String getText() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtil$5", "getText"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtil$5", "getFamilyName"));
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/util/SpecialAnnotationsUtil$5", "isAvailable"));
                }
                return true;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/util/SpecialAnnotationsUtil$5", "invoke"));
                }
                SpecialAnnotationsUtilBase.doQuickFixInternal(project, targetList, qualifiedName);
            }

            public boolean startInWriteAction() {
                return true;
            }
        };
    }
}

