/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.ZipFileSet;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class ArchiveAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private final String myPrefix;

    public ArchiveAntCopyInstructionCreator(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirPath", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createDirectoryContentCopyInstruction"));
        }
        ZipFileSet zipFileSet = new ZipFileSet(dirPath, this.myPrefix, true);
        if (zipFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createDirectoryContentCopyInstruction"));
        }
        return zipFileSet;
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createFileCopyInstruction"));
        }
        String relativePath = this.myPrefix + "/" + outputFileName;
        ZipFileSet zipFileSet = new ZipFileSet(filePath, relativePath, false);
        if (zipFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createFileCopyInstruction"));
        }
        return zipFileSet;
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "subFolder"));
        }
        ArchiveAntCopyInstructionCreator archiveAntCopyInstructionCreator = new ArchiveAntCopyInstructionCreator(this.myPrefix + "/" + directoryName);
        if (archiveAntCopyInstructionCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "subFolder"));
        }
        return archiveAntCopyInstructionCreator;
    }

    public Generator createSubFolderCommand(@NotNull String directoryName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createSubFolderCommand"));
        }
        return null;
    }

    @NotNull
    public Generator createExtractedDirectoryInstruction(@NotNull String jarPath) {
        if (jarPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarPath", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createExtractedDirectoryInstruction"));
        }
        ZipFileSet zipFileSet = ZipFileSet.createUnpackedSet((String)jarPath, (String)this.myPrefix, (boolean)true);
        if (zipFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator", "createExtractedDirectoryInstruction"));
        }
        return zipFileSet;
    }
}

