/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CompressionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorChangeAction
extends BasicUndoableAction {
    private final int myOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;

    public EditorChangeAction(DocumentEvent e) {
        this((DocumentEx)e.getDocument(), e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    public EditorChangeAction(@NotNull DocumentEx document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/command/impl/EditorChangeAction", "<init>"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/command/impl/EditorChangeAction", "<init>"));
        }
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/command/impl/EditorChangeAction", "<init>"));
        }
        super(new Document[]{document});
        this.myOffset = offset;
        this.myOldString = CompressionUtil.compressStringRawBytes(oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes(newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            this.performUndo();
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myOldTimeStamp);
        this.refreshFileStatus();
    }

    public void performUndo() {
        CharSequence oldString = CompressionUtil.uncompressStringRawBytes(this.myOldString);
        CharSequence newString = CompressionUtil.uncompressStringRawBytes(this.myNewString);
        this.exchangeStrings(newString, oldString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        DocumentUndoProvider.startDocumentUndo(this.getDocument());
        try {
            CharSequence oldString = CompressionUtil.uncompressStringRawBytes(this.myOldString);
            CharSequence newString = CompressionUtil.uncompressStringRawBytes(this.myNewString);
            this.exchangeStrings(oldString, newString);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(this.getDocument());
        }
        this.getDocument().setModificationStamp(this.myNewTimeStamp);
        this.refreshFileStatus();
    }

    private void exchangeStrings(@NotNull CharSequence newString, @NotNull CharSequence oldString) {
        if (newString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newString", "com/intellij/openapi/command/impl/EditorChangeAction", "exchangeStrings"));
        }
        if (oldString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldString", "com/intellij/openapi/command/impl/EditorChangeAction", "exchangeStrings"));
        }
        DocumentEx d = this.getDocument();
        if (newString.length() > 0 && oldString.length() == 0) {
            d.deleteString(this.myOffset, this.myOffset + newString.length());
        } else if (oldString.length() > 0 && newString.length() == 0) {
            d.insertString(this.myOffset, oldString);
        } else if (oldString.length() > 0 && newString.length() > 0) {
            d.replaceString(this.myOffset, this.myOffset + newString.length(), oldString);
        }
    }

    private void refreshFileStatus() {
        VirtualFile f = this.getAffectedDocuments()[0].getFile();
        if (f == null || f instanceof LightVirtualFile) {
            return;
        }
        for (Project each : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManagerImpl statusManager = (FileStatusManagerImpl)FileStatusManager.getInstance((Project)each);
            statusManager.refreshFileStatusFromDocument(f, this.getDocument());
        }
    }

    private DocumentEx getDocument() {
        return (DocumentEx)this.getAffectedDocuments()[0].getDocument();
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "'" + " at: " + this.myOffset;
    }
}

