/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DetachExternalProjectAction
extends ExternalSystemNodeAction<AbstractExternalEntityData>
implements DumbAware {
    public DetachExternalProjectAction() {
        super(AbstractExternalEntityData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(SystemInfoRt.isMac ? AllIcons.ToolbarDecorator.Mac.Remove : AllIcons.ToolbarDecorator.Remove);
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        Object externalData = ((ExternalSystemNode)selectedNodes.get(0)).getData();
        return externalData instanceof ProjectData || externalData instanceof ModuleData;
    }

    @Override
    public void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull AbstractExternalEntityData entityData, @NotNull AnActionEvent e) {
        ProjectNode projectNode;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction", "perform"));
        }
        if (projectSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSystemId", "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction", "perform"));
        }
        if (entityData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityData", "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction", "perform"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction", "perform"));
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)ContainerUtil.getFirstItem((List)selectedNodes);
        assert (externalSystemNode != null);
        ProjectNode projectNode2 = projectNode = externalSystemNode instanceof ProjectNode ? (ProjectNode)externalSystemNode : externalSystemNode.findParent(ProjectNode.class);
        assert (projectNode != null);
        ProjectData projectData = (ProjectData)projectNode.getData();
        assert (projectData != null);
        ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectSystemId).forgetExternalProjects(Collections.singleton(projectData.getLinkedExternalProjectPath()));
        ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId).unlinkExternalProject(projectData.getLinkedExternalProjectPath());
        ExternalProjectsManager.getInstance(project).forgetExternalProjectData(projectSystemId, projectData.getLinkedExternalProjectPath());
        PlatformFacade platformFacade = (PlatformFacade)ServiceManager.getService(PlatformFacade.class);
        ArrayList orphanModules = ContainerUtilRt.newArrayList();
        for (Module module : platformFacade.getModules(project)) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectSystemId, (Module)module)) continue;
            String path = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            if (!projectData.getLinkedExternalProjectPath().equals(path)) continue;
            orphanModules.add(module);
        }
        if (!orphanModules.isEmpty()) {
            ExternalSystemUtil.ruleOrphanModules(orphanModules, project, projectSystemId, new Consumer<Boolean>(){

                public void consume(Boolean result) {
                    if (result != null && result.booleanValue()) {
                        projectNode.getGroup().remove(projectNode);
                    }
                }
            });
        }
    }
}

