/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ToggleTaskActivationAction
extends ExternalSystemToggleAction {
    private final ExternalSystemTaskActivator.Phase myPhase;

    protected ToggleTaskActivationAction(ExternalSystemTaskActivator.Phase phase) {
        this.myPhase = phase;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && !ToggleTaskActivationAction.getTasks(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(AnActionEvent e) {
        return this.hasTask(this.getTaskActivator(e), ToggleTaskActivationAction.getTasks(e).get(0));
    }

    public void setSelected(AnActionEvent e, boolean state) {
        List<TaskData> tasks = ToggleTaskActivationAction.getTasks(e);
        if (state) {
            this.addTasks(this.getTaskActivator(e), tasks);
        } else {
            this.removeTasks(this.getTaskActivator(e), tasks);
        }
    }

    @NotNull
    private static List<TaskData> getTasks(AnActionEvent e) {
        List selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext());
        if (selectedNodes == null) {
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/task/ToggleTaskActivationAction", "getTasks"));
            }
            return list;
        }
        SmartList tasks = new SmartList();
        for (ExternalSystemNode node : selectedNodes) {
            if (node instanceof TaskNode) {
                tasks.add((TaskData)node.getData());
                continue;
            }
            if (node instanceof RunConfigurationNode) {
                RunnerAndConfigurationSettings configurationSettings = ((RunConfigurationNode)node).getSettings();
                ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)configurationSettings.getConfiguration();
                ExternalSystemTaskExecutionSettings taskExecutionSettings = runConfiguration.getSettings();
                tasks.add(new TaskData(taskExecutionSettings.getExternalSystemId(), "run: " + configurationSettings.getName(), taskExecutionSettings.getExternalProjectPath(), null));
                continue;
            }
            List<TaskData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/task/ToggleTaskActivationAction", "getTasks"));
            }
            return list;
        }
        SmartList smartList = tasks;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/action/task/ToggleTaskActivationAction", "getTasks"));
        }
        return smartList;
    }

    protected boolean hasTask(ExternalSystemTaskActivator manager, TaskData taskData) {
        if (taskData == null) {
            return false;
        }
        return manager.isTaskOfPhase(taskData, this.myPhase);
    }

    private void addTasks(ExternalSystemTaskActivator taskActivator, List<TaskData> tasks) {
        taskActivator.addTasks(tasks, this.myPhase);
    }

    private void removeTasks(ExternalSystemTaskActivator taskActivator, List<TaskData> tasks) {
        taskActivator.removeTasks(tasks, this.myPhase);
    }

    private ExternalSystemTaskActivator getTaskActivator(AnActionEvent e) {
        return ExternalProjectsManager.getInstance(this.getProject(e)).getTaskActivator();
    }
}

