/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.stores.DirectoryBasedStorage;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.AbstractSchemesManager;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManagerFactoryImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends AbstractSchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance(SchemesManagerFactoryImpl.class);
    private final String myFileSpec;
    private final SchemeProcessor<E> myProcessor;
    private final RoamingType myRoamingType;
    private final StreamProvider myProvider;
    private final File myIoDir;
    private VirtualFile myDir;
    private String mySchemeExtension;
    private boolean myUpdateExtension;
    private final Set<String> myFilesToDelete;

    public SchemesManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType, @Nullable StreamProvider provider, @NotNull File baseDir) {
        VirtualFileTracker virtualFileTracker;
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        this.mySchemeExtension = ".xml";
        this.myFilesToDelete = new THashSet();
        this.myFileSpec = fileSpec;
        this.myProcessor = processor;
        this.myRoamingType = roamingType;
        this.myProvider = provider;
        this.myIoDir = baseDir;
        if (processor instanceof SchemeExtensionProvider) {
            this.mySchemeExtension = ((SchemeExtensionProvider)processor).getSchemeExtension();
            this.myUpdateExtension = ((SchemeExtensionProvider)processor).isUpgradeNeeded();
        }
        if ((virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class)) != null) {
            String baseDirPath = this.myIoDir.getAbsolutePath().replace(File.separatorChar, '/');
            virtualFileTracker.addTracker("file://" + baseDirPath, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    ExternalizableScheme readScheme;
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "contentsChanged"));
                    }
                    if (event.getRequestor() != null || !SchemesManagerImpl.this.isMy(event)) {
                        return;
                    }
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(event.getFile().getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    if ((readScheme = SchemesManagerImpl.this.readSchemeFromFile(event.getFile(), true, false)) != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                        Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        if (oldCurrentScheme != null && newCurrentScheme == null) {
                            SchemesManagerImpl.this.setCurrentSchemeName(readScheme.getName());
                            newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                        }
                        if (oldCurrentScheme != newCurrentScheme) {
                            SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                        }
                    }
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileCreated"));
                    }
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = SchemesManagerImpl.this.getVirtualDir();
                            if (event.getFile().equals(dir)) {
                                for (VirtualFile file : dir.getChildren()) {
                                    if (!SchemesManagerImpl.this.isMy(file)) continue;
                                    this.schemeCreatedExternally(file);
                                }
                            }
                        } else if (SchemesManagerImpl.this.isMy(event)) {
                            this.schemeCreatedExternally(event.getFile());
                        }
                    }
                }

                private void schemeCreatedExternally(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl$1", "schemeCreatedExternally"));
                    }
                    ExternalizableScheme readScheme = SchemesManagerImpl.this.readSchemeFromFile(file, true, false);
                    if (readScheme != null) {
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                    }
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl$1", "fileDeleted"));
                    }
                    if (event.getRequestor() == null) {
                        if (event.getFile().isDirectory()) {
                            VirtualFile dir = SchemesManagerImpl.this.myDir;
                            if (event.getFile().equals(dir)) {
                                SchemesManagerImpl.this.myDir = null;
                                for (VirtualFile file : dir.getChildren()) {
                                    if (!SchemesManagerImpl.this.isMy(file)) continue;
                                    this.schemeDeletedExternally(file);
                                }
                            }
                        } else if (SchemesManagerImpl.this.isMy(event)) {
                            this.schemeDeletedExternally(event.getFile());
                        }
                    }
                }

                private void schemeDeletedExternally(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl$1", "schemeDeletedExternally"));
                    }
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(file.getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        SchemesManagerImpl.this.removeScheme(scheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    if (oldCurrentScheme != null && newCurrentScheme == null && !SchemesManagerImpl.this.mySchemes.isEmpty()) {
                        SchemesManagerImpl.this.setCurrentSchemeName(((Scheme)SchemesManagerImpl.this.mySchemes.get(0)).getName());
                        newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    }
                    if (oldCurrentScheme != newCurrentScheme) {
                        SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                    }
                }
            }, false, (Disposable)ApplicationManager.getApplication());
        }
    }

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/options/SchemesManagerImpl", "loadBundledScheme"));
        }
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                LOG.error("Cannot read scheme from " + resourceName);
                return;
            }
            this.addNewScheme((Scheme)convertor.convert((Object)JDOMUtil.load((InputStream)URLUtil.openStream((URL)url))), false);
        }
        catch (Throwable e) {
            LOG.error("Cannot read scheme from " + resourceName, e);
        }
    }

    private boolean isMy(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/options/SchemesManagerImpl", "isMy"));
        }
        return this.isMy(event.getFile());
    }

    private boolean isMy(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "isMy"));
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.mySchemeExtension);
    }

    @NotNull
    public Collection<E> loadSchemes() {
        LinkedHashMap<String, E> result = new LinkedHashMap<String, E>();
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            this.readSchemesFromProviders(result);
        } else {
            VirtualFile[] files;
            VirtualFile dir = this.getVirtualDir();
            VirtualFile[] virtualFileArray = files = dir == null ? null : dir.getChildren();
            if (files != null) {
                for (VirtualFile file : files) {
                    E scheme = this.readSchemeFromFile(file, false, true);
                    if (scheme == null) continue;
                    result.put(scheme.getName(), scheme);
                }
            }
        }
        Collection list = result.values();
        for (ExternalizableScheme scheme : list) {
            this.myProcessor.initScheme(scheme);
            this.checkCurrentScheme((Scheme)scheme);
        }
        Collection collection = list;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSchemes"));
        }
        return collection;
    }

    private E findSchemeFor(@NotNull String ioFileName) {
        if (ioFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFileName", "com/intellij/openapi/options/SchemesManagerImpl", "findSchemeFor"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!(scheme instanceof ExternalizableScheme) || !ioFileName.equals(((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName() + this.mySchemeExtension)) continue;
            return (E)((ExternalizableScheme)scheme);
        }
        return null;
    }

    @Nullable
    private static Element loadElementOrNull(@Nullable InputStream stream) {
        try {
            return JDOMUtil.load((InputStream)stream);
        }
        catch (JDOMException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private void readSchemesFromProviders(@NotNull Map<String, E> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemesFromProviders"));
        }
        assert (this.myProvider != null);
        for (String subPath : this.myProvider.listSubFiles(this.myFileSpec, this.myRoamingType)) {
            try {
                String currentFileName;
                Element element = SchemesManagerImpl.loadElementOrNull(this.myProvider.loadContent(this.getFileFullPath(subPath), this.myRoamingType));
                if (element == null) {
                    return;
                }
                E scheme = this.readScheme(element, true);
                boolean fileRenamed = false;
                assert (scheme != null);
                Object existing = this.findSchemeByName(scheme.getName());
                if (existing instanceof ExternalizableScheme && (currentFileName = ((ExternalizableScheme)existing).getExternalInfo().getCurrentFileName()) != null && !currentFileName.equals(subPath)) {
                    this.deleteServerFile(subPath);
                    subPath = currentFileName;
                    fileRenamed = true;
                }
                String fileName = this.checkFileNameIsFree(subPath, scheme.getName());
                if (!fileRenamed && !fileName.equals(subPath)) {
                    this.deleteServerFile(subPath);
                }
                this.loadScheme(scheme, false, fileName);
                scheme.getExternalInfo().markRemote();
                result.put(scheme.getName(), scheme);
            }
            catch (Exception e) {
                LOG.info("Cannot load data from stream provider: " + e.getMessage());
            }
        }
    }

    @NotNull
    private String checkFileNameIsFree(@NotNull String subPath, @NotNull String schemeName) {
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        if (schemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemeName", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        for (Scheme scheme : this.mySchemes) {
            String name;
            if (!(scheme instanceof ExternalizableScheme) || (name = ((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName()) == null || schemeName.equals(scheme.getName()) || subPath.length() != name.length() + this.mySchemeExtension.length() || !subPath.startsWith(name) || !subPath.endsWith(this.mySchemeExtension)) continue;
            String string = UniqueNameGenerator.generateUniqueName((String)FileUtil.sanitizeName((String)schemeName), this.collectAllFileNames());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
            }
            return string;
        }
        String string = subPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "checkFileNameIsFree"));
        }
        return string;
    }

    @NotNull
    private Collection<String> collectAllFileNames() {
        THashSet result = new THashSet();
        for (Scheme scheme : this.mySchemes) {
            ExternalInfo externalInfo;
            if (!(scheme instanceof ExternalizableScheme) || (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName() == null) continue;
            result.add(externalInfo.getCurrentFileName());
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "collectAllFileNames"));
        }
        return tHashSet;
    }

    private void loadScheme(@NotNull E scheme, boolean forceAdd, @NotNull CharSequence fileName) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "loadScheme"));
        }
        String fileNameWithoutExtension = this.createFileName(fileName);
        if (!forceAdd && this.myFilesToDelete.contains(fileNameWithoutExtension)) {
            return;
        }
        Object existing = this.findSchemeByName(scheme.getName());
        if (existing != null) {
            if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                LOG.warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
            }
            this.mySchemes.remove(existing);
            if (existing instanceof ExternalizableScheme) {
                this.myProcessor.onSchemeDeleted((ExternalizableScheme)existing);
            }
        }
        this.addNewScheme(scheme, true);
        scheme.getExternalInfo().setPreviouslySavedName(scheme.getName());
        scheme.getExternalInfo().setCurrentFileName(fileNameWithoutExtension);
    }

    private boolean canRead(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "canRead"));
        }
        if (file.isDirectory()) {
            return false;
        }
        if (this.myUpdateExtension && !".xml".equals(this.mySchemeExtension) && DirectoryStorageData.isStorageFile(file)) {
            return this.myDir.findChild(file.getNameSequence() + this.mySchemeExtension) == null;
        }
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.mySchemeExtension);
    }

    @Nullable
    private E readSchemeFromFile(final @NotNull VirtualFile file, boolean forceAdd, boolean duringLoad) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/options/SchemesManagerImpl", "readSchemeFromFile"));
        }
        if (!this.canRead(file)) {
            return null;
        }
        try {
            Element element;
            try {
                element = JDOMUtil.load((InputStream)file.getInputStream());
            }
            catch (JDOMException e) {
                try {
                    File initialIoFile = new File(this.myIoDir, file.getName());
                    if (initialIoFile.isFile()) {
                        FileUtil.copy((File)initialIoFile, (File)new File(this.myIoDir, file.getName() + ".copy"));
                    }
                }
                catch (IOException e1) {
                    LOG.error((Throwable)e1);
                }
                LOG.error("Error reading file " + file.getPath() + ": " + e.getMessage());
                return null;
            }
            E scheme = this.readScheme(element, duringLoad);
            if (scheme != null) {
                this.loadScheme(scheme, forceAdd, file.getNameSequence());
            }
            return scheme;
        }
        catch (Exception e) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String msg = "Cannot read scheme " + file.getName() + "  from '" + SchemesManagerImpl.this.myFileSpec + "': " + e.getMessage();
                    LOG.info(msg, (Throwable)e);
                    Messages.showErrorDialog((String)msg, (String)"Load Settings");
                }
            });
            return null;
        }
    }

    @Nullable
    private E readScheme(@NotNull Element element, boolean duringLoad) throws InvalidDataException, IOException, JDOMException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/options/SchemesManagerImpl", "readScheme"));
        }
        ExternalizableScheme scheme = this.myProcessor instanceof BaseSchemeProcessor ? ((BaseSchemeProcessor)this.myProcessor).readScheme(element, duringLoad) : this.myProcessor.readScheme(new Document((Element)element.detach()));
        if (scheme != null) {
            scheme.getExternalInfo().setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
        }
        return (E)scheme;
    }

    @NotNull
    private String createFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/options/SchemesManagerImpl", "createFileName"));
        }
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.mySchemeExtension)) {
            fileName = fileName.subSequence(0, fileName.length() - this.mySchemeExtension.length());
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            fileName = fileName.subSequence(0, fileName.length() - ".xml".length());
        }
        String string = ((Object)fileName).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "createFileName"));
        }
        return string;
    }

    public void updateConfigFilesFromStreamProviders() {
    }

    private String getFileFullPath(@NotNull String subPath) {
        if (subPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subPath", "com/intellij/openapi/options/SchemesManagerImpl", "getFileFullPath"));
        }
        return this.myFileSpec + '/' + subPath;
    }

    public void save() {
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.mySchemes) {
            String fileName;
            BaseSchemeProcessor.State state;
            if (!(scheme instanceof ExternalizableScheme)) continue;
            ExternalizableScheme eScheme = (ExternalizableScheme)scheme;
            if (this.myProcessor instanceof BaseSchemeProcessor) {
                state = ((BaseSchemeProcessor)this.myProcessor).getState(eScheme);
            } else {
                BaseSchemeProcessor.State state2 = state = this.myProcessor.shouldBeSaved(eScheme) ? BaseSchemeProcessor.State.POSSIBLY_CHANGED : BaseSchemeProcessor.State.NON_PERSISTENT;
            }
            if (state == BaseSchemeProcessor.State.NON_PERSISTENT) continue;
            hasSchemes = true;
            if (state != BaseSchemeProcessor.State.UNCHANGED) {
                schemesToSave.add(eScheme);
            }
            if ((fileName = eScheme.getExternalInfo().getCurrentFileName()) == null || SchemesManagerImpl.isRenamed(eScheme)) continue;
            nameGenerator.addExistingName(fileName);
        }
        SmartList errors = null;
        VirtualFile dir = this.getVirtualDir();
        if (!hasSchemes) {
            this.myFilesToDelete.clear();
            if (dir != null && dir.exists()) {
                try {
                    StorageUtil.deleteFile((Object)this, dir);
                }
                catch (Throwable e) {
                    errors = new SmartList();
                    errors.add(e);
                }
            }
            return;
        }
        for (ExternalizableScheme scheme : schemesToSave) {
            try {
                this.saveScheme(scheme, nameGenerator);
            }
            catch (Throwable e) {
                if (errors == null) {
                    errors = new SmartList();
                }
                errors.add(e);
            }
        }
        errors = this.deleteFiles(dir, (List<Throwable>)errors);
        CompoundRuntimeException.doThrow(errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScheme(@NotNull E scheme, @NotNull UniqueNameGenerator nameGenerator) throws WriteExternalException, IOException {
        String fileSpec;
        BufferExposingByteArrayOutputStream byteOut;
        int newHash;
        String fileName;
        ExternalInfo externalInfo;
        block21: {
            boolean renamed;
            Element element;
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
            }
            if (nameGenerator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameGenerator", "com/intellij/openapi/options/SchemesManagerImpl", "saveScheme"));
            }
            externalInfo = scheme.getExternalInfo();
            String currentFileNameWithoutExtension = externalInfo.getCurrentFileName();
            Parent parent = this.myProcessor.writeScheme(scheme);
            Element element2 = element = parent == null || parent instanceof Element ? (Element)parent : ((Document)parent).detachRootElement();
            if (JDOMUtil.isEmpty((Element)element)) {
                ContainerUtilRt.addIfNotNull(this.myFilesToDelete, (Object)currentFileNameWithoutExtension);
                return;
            }
            String fileNameWithoutExtension = currentFileNameWithoutExtension;
            if (fileNameWithoutExtension == null || SchemesManagerImpl.isRenamed(scheme)) {
                fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeName((String)scheme.getName()));
            }
            fileName = fileNameWithoutExtension + this.mySchemeExtension;
            newHash = JDOMUtil.getTreeHash((Element)element, (boolean)true);
            if (currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
                return;
            }
            this.myFilesToDelete.remove(fileNameWithoutExtension);
            byteOut = StorageUtil.writeToBytes((Parent)element, "\n");
            boolean bl = renamed = currentFileNameWithoutExtension != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension);
            if (!externalInfo.isRemote()) {
                AccessToken token;
                VirtualFile file = null;
                if (renamed && (file = this.myDir.findChild(currentFileNameWithoutExtension + this.mySchemeExtension)) != null) {
                    token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
                    try {
                        file.rename((Object)this, fileName);
                    }
                    finally {
                        token.finish();
                    }
                }
                if (file == null) {
                    if (this.myDir == null || !this.myDir.isValid()) {
                        this.myDir = DirectoryBasedStorage.createDir(this.myIoDir, (Object)this);
                    }
                    file = DirectoryBasedStorage.getFile(fileName, this.myDir, (Object)this);
                }
                token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
                try {
                    OutputStream out = file.getOutputStream((Object)this);
                    try {
                        byteOut.writeTo(out);
                        break block21;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    token.finish();
                }
            }
            if (renamed) {
                this.myFilesToDelete.add(currentFileNameWithoutExtension);
            }
        }
        externalInfo.setHash(newHash);
        externalInfo.setPreviouslySavedName(scheme.getName());
        externalInfo.setCurrentFileName(this.createFileName(fileName));
        if (this.myProvider != null && this.myProvider.isEnabled() && this.myProvider.isApplicable(fileSpec = this.getFileFullPath(fileName), this.myRoamingType)) {
            this.myProvider.saveContent(fileSpec, byteOut.getInternalBuffer(), byteOut.size(), this.myRoamingType, true);
        }
    }

    private static boolean isRenamed(@NotNull ExternalizableScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "isRenamed"));
        }
        return !scheme.getName().equals(scheme.getExternalInfo().getPreviouslySavedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<Throwable> deleteFiles(@Nullable VirtualFile dir, List<Throwable> errors) {
        if (this.myFilesToDelete.isEmpty()) {
            return errors;
        }
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            for (String nameWithoutExtension : this.myFilesToDelete) {
                this.deleteServerFile(nameWithoutExtension + this.mySchemeExtension);
                if (".xml".equals(this.mySchemeExtension)) continue;
                this.deleteServerFile(nameWithoutExtension + ".xml");
            }
        }
        if (dir != null) {
            AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(DocumentRunnable.IgnoreDocumentRunnable.class);
            try {
                for (VirtualFile file : dir.getChildren()) {
                    if (!this.myFilesToDelete.contains(file.getNameWithoutExtension())) continue;
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException e) {
                        if (errors == null) {
                            errors = new SmartList();
                        }
                        errors.add((Throwable)e);
                    }
                }
                this.myFilesToDelete.clear();
            }
            finally {
                token.finish();
            }
        }
        return errors;
    }

    @Nullable
    private VirtualFile getVirtualDir() {
        VirtualFile virtualFile = this.myDir;
        if (virtualFile == null) {
            this.myDir = virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.myIoDir);
        }
        return virtualFile;
    }

    public File getRootDirectory() {
        return this.myIoDir;
    }

    private void deleteServerFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/options/SchemesManagerImpl", "deleteServerFile"));
        }
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            StorageUtil.delete(this.myProvider, this.getFileFullPath(path), this.myRoamingType);
        }
    }

    @Override
    protected void schemeDeleted(@NotNull Scheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "schemeDeleted"));
        }
        super.schemeDeleted(scheme);
        if (scheme instanceof ExternalizableScheme) {
            ContainerUtilRt.addIfNotNull(this.myFilesToDelete, (Object)((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName());
        }
    }

    @Override
    protected void schemeAdded(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemesManagerImpl", "schemeAdded"));
        }
        if (!(scheme instanceof ExternalizableScheme)) {
            return;
        }
        ExternalInfo externalInfo = ((ExternalizableScheme)scheme).getExternalInfo();
        String fileName = externalInfo.getCurrentFileName();
        if (fileName != null) {
            this.myFilesToDelete.remove(fileName);
        }
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            externalInfo.markRemote();
        }
    }
}

