/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.CacheUpdateSession;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateRunner
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.CacheUpdateRunner");
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create((String)"FAILED_TO_INDEX");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();
    private final Project myProject;
    private final Collection<CacheUpdater> myUpdaters;
    private CacheUpdateSession mySession;

    CacheUpdateRunner(@NotNull Project project, @NotNull Collection<CacheUpdater> updaters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner", "<init>"));
        }
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "com/intellij/openapi/project/CacheUpdateRunner", "<init>"));
        }
        this.myProject = project;
        this.myUpdaters = updaters;
    }

    public String toString() {
        return new ArrayList<CacheUpdater>(this.myUpdaters).toString();
    }

    private int queryNeededFiles(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/CacheUpdateRunner", "queryNeededFiles"));
        }
        return this.getSession(indicator).getFilesToUpdate().size();
    }

    @NotNull
    private CacheUpdateSession getSession(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/CacheUpdateRunner", "getSession"));
        }
        CacheUpdateSession session = this.mySession;
        if (session == null) {
            this.mySession = session = new CacheUpdateSession(this.myUpdaters, indicator);
        }
        CacheUpdateSession cacheUpdateSession = session;
        if (cacheUpdateSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/CacheUpdateRunner", "getSession"));
        }
        return cacheUpdateSession;
    }

    private void processFiles(@NotNull ProgressIndicator indicator, boolean processInReadAction) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/CacheUpdateRunner", "processFiles"));
        }
        try {
            Collection<VirtualFile> files = this.mySession.getFilesToUpdate();
            CacheUpdateRunner.processFiles(indicator, processInReadAction, files, this.myProject, new Consumer<FileContent>(){

                public void consume(FileContent content) {
                    CacheUpdateRunner.this.mySession.processFile(content);
                }
            });
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    public static void processFiles(final ProgressIndicator indicator, boolean processInReadAction, Collection<VirtualFile> files, Project project, Consumer<FileContent> processor) {
        indicator.checkCanceled();
        FileContentQueue queue = new FileContentQueue();
        final double total = files.size();
        queue.queue(files, indicator);
        Consumer<VirtualFile> progressUpdater = new Consumer<VirtualFile>(){
            final Set<VirtualFile> processed = new THashSet();
            private boolean fileNameWasShownAfterRestart;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(VirtualFile virtualFile) {
                indicator.checkCanceled();
                Set<VirtualFile> set = this.processed;
                synchronized (set) {
                    boolean added = this.processed.add(virtualFile);
                    indicator.setFraction((double)this.processed.size() / total);
                    if (!added) {
                        indicator.setText2(virtualFile.getPresentableUrl());
                        this.fileNameWasShownAfterRestart = true;
                    } else if (this.fileNameWasShownAfterRestart) {
                        indicator.setText2("");
                        this.fileNameWasShownAfterRestart = false;
                    }
                }
            }
        };
        while (!project.isDisposed()) {
            indicator.checkCanceled();
            if (!CacheUpdateRunner.processSomeFilesWhileUserIsInactive(queue, progressUpdater, processInReadAction, project, processor)) continue;
        }
        if (project.isDisposed()) {
            indicator.cancel();
            indicator.checkCanceled();
        }
    }

    private void updatingDone() {
        try {
            this.mySession.updatingDone();
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue, @NotNull Consumer<VirtualFile> progressUpdater, boolean processInReadAction, @NotNull Project project, @NotNull Consumer<FileContent> fileProcessor) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (fileProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        final ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                innerIndicator.cancel();
            }
        };
        final Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                application.addApplicationListener((ApplicationListener)canceller);
            }
        }, ModalityState.any());
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
            if (threadsCount <= 0) {
                threadsCount = Math.max(1, Math.min(PROC_COUNT - 1, 4));
            }
            if (threadsCount == 1 || application.isWriteAccessAllowed()) {
                MyRunnable process = new MyRunnable(innerIndicator, queue, isFinished, progressUpdater, processInReadAction, project, fileProcessor);
                ProgressManager.getInstance().runProcess((Runnable)process, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    AtomicBoolean ref;
                    finishedRefs[i] = ref = new AtomicBoolean();
                    MyRunnable process = new MyRunnable(innerIndicator, queue, ref, progressUpdater, processInReadAction, project, fileProcessor);
                    futures[i] = ApplicationManager.getApplication().executeOnPooledThread((Runnable)process);
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished.get();
    }

    private static boolean waitForAll(@NotNull AtomicBoolean[] finishedRefs, @NotNull Future<?>[] futures) {
        if (finishedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishedRefs", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        if (futures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "futures", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            for (Future<?> future : futures) {
                future.get();
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (InterruptedException ignored) {
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        return false;
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/project/CacheUpdateRunner", "performInDumbMode"));
        }
        indicator.checkCanceled();
        indicator.setIndeterminate(true);
        indicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        int count = this.queryNeededFiles(indicator);
        indicator.setIndeterminate(false);
        indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        if (count > 0) {
            this.processFiles(indicator, true);
        }
        this.updatingDone();
    }

    private static class MyRunnable
    implements Runnable {
        private final ProgressIndicatorBase myInnerIndicator;
        private final FileContentQueue myQueue;
        private final AtomicBoolean myFinished;
        private final Consumer<VirtualFile> myProgressUpdater;
        private final boolean myProcessInReadAction;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Consumer<FileContent> myProcessor;

        public MyRunnable(@NotNull ProgressIndicatorBase innerIndicator, @NotNull FileContentQueue queue, @NotNull AtomicBoolean finished, @NotNull Consumer<VirtualFile> progressUpdater, boolean processInReadAction, @NotNull Project project, @NotNull Consumer<FileContent> fileProcessor) {
            if (innerIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerIndicator", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (finished == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finished", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (progressUpdater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (fileProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            this.myInnerIndicator = innerIndicator;
            this.myQueue = queue;
            this.myFinished = finished;
            this.myProgressUpdater = progressUpdater;
            this.myProcessInReadAction = processInReadAction;
            this.myProject = project;
            this.myProcessor = fileProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.myProject.isDisposed() && !this.myInnerIndicator.isCanceled()) {
                try {
                    final FileContent fileContent = this.myQueue.take(this.myInnerIndicator);
                    if (fileContent == null) {
                        this.myFinished.set(true);
                        return;
                    }
                    final Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            MyRunnable.this.myInnerIndicator.checkCanceled();
                            if (!MyRunnable.this.myProject.isDisposed()) {
                                VirtualFile file = fileContent.getVirtualFile();
                                try {
                                    MyRunnable.this.myProgressUpdater.consume((Object)file);
                                    if (file.isValid() && !file.isDirectory() && !Boolean.TRUE.equals(file.getUserData(FAILED_TO_INDEX))) {
                                        MyRunnable.this.myProcessor.consume((Object)fileContent);
                                    }
                                }
                                catch (ProcessCanceledException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    LOG.error("Error while indexing " + file.getPresentableUrl() + "\n" + "To reindex this file IDEA has to be restarted", e);
                                    file.putUserData(FAILED_TO_INDEX, (Object)Boolean.TRUE);
                                }
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(){

                            @Override
                            public void run() {
                                if (MyRunnable.this.myProcessInReadAction) {
                                    if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)) {
                                        throw new ProcessCanceledException();
                                    }
                                } else {
                                    action.run();
                                }
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(this.myInnerIndicator));
                    }
                    catch (ProcessCanceledException e) {
                        this.myQueue.pushback(fileContent);
                        return;
                    }
                    finally {
                        this.myQueue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
            return;
        }
    }
}

