/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.actions.AnnotateRevisionAction;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnnotateCurrentRevisionAction
extends AnnotateRevisionAction {
    @Nullable
    private final List<VcsFileRevision> myRevisions;

    public AnnotateCurrentRevisionAction(@NotNull UpToDateLineNumberProvider getUpToDateLineNumber, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (getUpToDateLineNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getUpToDateLineNumber", "com/intellij/openapi/vcs/actions/AnnotateCurrentRevisionAction", "<init>"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/openapi/vcs/actions/AnnotateCurrentRevisionAction", "<init>"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateCurrentRevisionAction", "<init>"));
        }
        super("Annotate Revision", "Annotate selected revision in new tab", AllIcons.Actions.Annotate, getUpToDateLineNumber, annotation, vcs);
        List revisions = annotation.getRevisions();
        if (revisions == null) {
            this.myRevisions = null;
            return;
        }
        HashMap map = new HashMap();
        for (VcsFileRevision revision : revisions) {
            map.put(revision.getRevisionNumber(), revision);
        }
        this.myRevisions = new ArrayList<VcsFileRevision>(annotation.getLineCount());
        for (int i = 0; i < annotation.getLineCount(); ++i) {
            this.myRevisions.add((VcsFileRevision)map.get(annotation.getLineRevisionNumber(i)));
        }
    }

    @Override
    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }
}

