/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.InlineProgressIndicator;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.TransparentPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class PresentationModeProgressPanel {
    private final InlineProgressIndicator myProgress;
    private JLabel myText;
    private JProgressBar myProgressBar;
    private InplaceButton myCancelButton;
    private JLabel myText2;
    private JPanel myRootPanel;
    private MergingUpdateQueue myUpdateQueue;
    private Update myUpdate;

    public PresentationModeProgressPanel(InlineProgressIndicator progress) {
        this.myProgress = progress;
        this.$$$setupUI$$$();
        JBFont font = JBUI.Fonts.label((float)11.0f);
        this.myText.setFont((Font)font);
        this.myText2.setFont((Font)font);
        this.myText.setIcon(EmptyIcon.create((int)1, (int)16));
        this.myText2.setIcon(EmptyIcon.create((int)1, (int)16));
        this.myUpdateQueue = new MergingUpdateQueue("Presentation Mode Progress", 100, true, null);
        this.myUpdate = new Update("Update UI"){

            public void run() {
                PresentationModeProgressPanel.this.updateImpl();
            }
        };
    }

    public void update() {
        this.myUpdateQueue.queue(this.myUpdate);
    }

    @NotNull
    public Color getTextForeground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel", "getTextForeground"));
        }
        return color;
    }

    private void updateImpl() {
        this.myText.setForeground(this.getTextForeground());
        this.myText2.setForeground(this.getTextForeground());
        if (!StringUtil.equals((CharSequence)this.myText.getText(), (CharSequence)this.myProgress.getText())) {
            this.myText.setText(this.myProgress.getText());
        }
        if (!StringUtil.equals((CharSequence)this.myText2.getText(), (CharSequence)this.myProgress.getText2())) {
            this.myText2.setText(this.myProgress.getText2());
        }
        if ((this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0) != this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setIndeterminate(this.myProgress.isIndeterminate() || this.myProgress.getFraction() == 0.0);
            this.myProgressBar.revalidate();
        }
        if (!this.myProgressBar.isIndeterminate()) {
            this.myProgressBar.setValue((int)(this.myProgress.getFraction() * 99.0) + 1);
        }
    }

    @NotNull
    public JComponent getProgressPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel", "getProgressPanel"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myRootPanel = new TransparentPanel(0.5f);
        IconButton iconButton = new IconButton(this.myProgress.getInfo().getCancelTooltipText(), AllIcons.Process.Stop, AllIcons.Process.StopHovered);
        this.myCancelButton = new InplaceButton(iconButton, new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/PresentationModeProgressPanel$2", "actionPerformed"));
                }
                PresentationModeProgressPanel.this.myProgress.cancel();
            }
        }).setFillBg(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JProgressBar jProgressBar;
        JLabel jLabel2;
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(250, 60));
        jPanel.setPreferredSize(new Dimension(250, 60));
        jPanel.setMaximumSize(new Dimension(250, 60));
        jPanel.setOpaque(false);
        this.myText = jLabel2 = new JLabel();
        jLabel2.setText("");
        jLabel2.setAutoscrolls(true);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(225, -1), new Dimension(225, -1)));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setOpaque(false);
        jProgressBar.setIndeterminate(true);
        jPanel.add((Component)jProgressBar, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, new Dimension(225, -1), new Dimension(225, -1), new Dimension(225, -1)));
        InplaceButton inplaceButton = this.myCancelButton;
        inplaceButton.setOpaque(false);
        jPanel.add((Component)inplaceButton, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myText2 = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, new Dimension(225, -1), new Dimension(225, -1)));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

