/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(final @NotNull OverridingMethodsSearch.SearchParameters p, final @NotNull Processor<PsiMethod> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        final PsiMethod method = p.getMethod();
        SearchScope scope = p.getScope();
        final PsiClass parentClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return method.getContainingClass();
            }
        });
        assert (parentClass != null);
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            public boolean process(final PsiClass inheritor) {
                PsiMethod found = (PsiMethod)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod>(){

                    @Nullable
                    public PsiMethod compute() {
                        return JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, parentClass, method);
                    }
                });
                return found == null || consumer.process((Object)found) && p.isCheckDeep();
            }
        };
        return ClassInheritorsSearch.search((PsiClass)parentClass, (SearchScope)scope, (boolean)true).forEach((Processor)inheritorsProcessor);
    }

    @Nullable
    private static PsiMethod findOverridingMethod(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        PsiMethod derived;
        PsiClass superClass;
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        PsiSubstitutor substitutor = inheritor.isInheritor(parentClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
        MethodSignature signature = method.getSignature(substitutor);
        PsiMethod found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature, (boolean)false);
        if (found != null && JavaOverridingMethodsSearcher.isAcceptable(found, method)) {
            return found;
        }
        if (parentClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(parentClass, true) && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)signature, (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(derived, method)) {
            return derived;
        }
        return null;
    }

    private static boolean isAcceptable(PsiMethod found, PsiMethod method) {
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)found.getProject()).arePackagesTheSame((PsiElement)method.getContainingClass(), (PsiElement)found.getContainingClass()));
    }
}

