/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUnconnectedToPackageInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.unconnected.to.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection", "checkElement"));
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analysisScope", "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection", "checkElement"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/siyeh/ig/packaging/ClassUnconnectedToPackageInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefClass)) {
            return null;
        }
        RefClass refClass = (RefClass)refEntity;
        RefEntity owner = refClass.getOwner();
        if (!(owner instanceof RefPackage)) {
            return null;
        }
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(refClass);
        for (RefClass dependency : dependencies) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependency)) continue;
            return null;
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(refClass);
        for (RefClass dependent : dependents) {
            if (!ClassUnconnectedToPackageInspection.inSamePackage(refClass, dependent)) continue;
            return null;
        }
        PsiClass aClass = refClass.getElement();
        PsiIdentifier identifier = aClass.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("class.unconnected.to.package.problem.descriptor", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0])};
    }

    private static boolean inSamePackage(RefClass class1, RefClass class2) {
        return class1.getOwner() == class2.getOwner();
    }
}

