/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import com.siyeh.ig.telemetry.ResetTelemetryAction;
import com.siyeh.ig.telemetry.TelemetryDisplay;
import com.siyeh.ig.telemetry.UpdateTelemetryViewAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class TelemetryToolWindow {
    @NonNls
    private static final String TOOL_WINDOW_ID = "IG Telemetry";
    private final JPanel contentPanel;

    public TelemetryToolWindow(InspectionGadgetsTelemetry telemetry) {
        TelemetryDisplay telemetryDisplay = new TelemetryDisplay(telemetry);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new UpdateTelemetryViewAction(telemetry, telemetryDisplay));
        toolbarGroup.add((AnAction)new ResetTelemetryAction(telemetry, telemetryDisplay));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar(TOOL_WINDOW_ID, (ActionGroup)toolbarGroup, true);
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.setBackground((Color)JBColor.GRAY);
        JComponent toolbarComponent = toolbar.getComponent();
        this.contentPanel.add((Component)toolbarComponent, "North");
        JComponent displayContentPane = telemetryDisplay.getContentPane();
        this.contentPanel.add((Component)displayContentPane, "Center");
    }

    public void register(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.LEFT);
        toolWindow.setTitle(InspectionGadgetsBundle.message("telemetry.toolwindow.title", new Object[0]));
        ContentManager contentManager = toolWindow.getContentManager();
        ContentFactory contentFactory = contentManager.getFactory();
        Content content = contentFactory.createContent((JComponent)this.contentPanel, "", true);
        contentManager.addContent(content);
        toolWindow.setAvailable(true, null);
    }

    public static void unregister(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.unregisterToolWindow(TOOL_WINDOW_ID);
    }
}

