/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueCallback;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentAsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.ObsolescentConsumer;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Variables;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public final class VariableView
extends XNamedValue
implements VariableContext {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+\\[\\d+\\]$");
    private final VariableContext context;
    private final Variable variable;
    private volatile Value value;
    private MemberFilter memberFilter;
    private volatile List<Variable> remainingChildren;
    private volatile int remainingChildrenOffset;

    public VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        this(variable.getName(), variable, context);
    }

    public VariableView(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/VariableView", "<init>"));
        }
        super(name);
        this.context = context;
        this.variable = variable;
    }

    @NotNull
    public static String getClassName(@NotNull ObjectValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "getClassName"));
        }
        String className = value.getClassName();
        String string = StringUtil.isEmpty((String)className) ? "Object" : className;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getClassName"));
        }
        return string;
    }

    @NotNull
    public static String getObjectValueDescription(@NotNull ObjectValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "getObjectValueDescription"));
        }
        String description = value.getValueString();
        String string = StringUtil.isEmpty((String)description) ? VariableView.getClassName(value) : description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getObjectValueDescription"));
        }
        return string;
    }

    public static void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "setObjectPresentation"));
        }
        node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableView.getObjectValueDescription(value)), value.hasProperties() != ThreeState.NO);
    }

    public static void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, final @NotNull Icon icon, final @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "setArrayPresentation"));
        }
        assert (value.getType() == ValueType.ARRAY);
        if (value instanceof ArrayValue) {
            int length = ((ArrayValue)value).getLength();
            node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value).getClassName()), length > 0);
            return;
        }
        String valueString = value.getValueString();
        if (valueString != null && valueString.endsWith("]") && ARRAY_DESCRIPTION_PATTERN.matcher(valueString).find()) {
            node.setPresentation(icon, null, valueString, true);
        } else {
            context.getEvaluateContext().evaluate("a.length", Collections.singletonMap("a", value), false).done((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node){

                public void consume(EvaluateResult result) {
                    node.setPresentation(icon, null, "Array[" + result.value.getValueString() + ']', true);
                }
            }).rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node){

                public void consume(Throwable error) {
                    node.setPresentation(icon, null, "Internal error: " + error, false);
                }
            });
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull Value value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        ValueType type = value.getType();
        switch (type) {
            case FUNCTION: {
                Icon icon = AllIcons.Nodes.Function;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
                }
                return icon;
            }
            case ARRAY: {
                Icon icon = AllIcons.Debugger.Db_array;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
                }
                return icon;
            }
        }
        Icon icon = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        return icon;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        DebuggerViewSupport debuggerViewSupport = this.context.getViewSupport();
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getViewSupport"));
        }
        return debuggerViewSupport;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return this.context;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        Promise<MemberFilter> promise = this.context.getViewSupport().getMemberFilter(this);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getMemberFilter"));
        }
        return promise;
    }

    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        this.value = this.variable.getValue();
        if (this.value != null) {
            this.computePresentation(this.value, node);
            return;
        }
        if (!(this.variable instanceof ObjectProperty) || ((ObjectProperty)this.variable).getGetter() == null) {
            this.getEvaluateContext().evaluate(this.variable.getName()).done((Consumer)new ObsolescentConsumer<EvaluateResult>((Obsolescent)node){

                public void consume(EvaluateResult result) {
                    if (result.wasThrown) {
                        VariableView.this.setEvaluatedValue(VariableView.this.getViewSupport().transformErrorOnGetUsedReferenceValue(VariableView.this.value, null), null, node);
                    } else {
                        VariableView.this.value = result.value;
                        VariableView.this.computePresentation(result.value, node);
                    }
                }
            }).rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node){

                public void consume(Throwable error) {
                    VariableView.this.setEvaluatedValue(VariableView.this.getViewSupport().transformErrorOnGetUsedReferenceValue(null, error.getMessage()), error.getMessage(), node);
                }
            });
            return;
        }
        node.setPresentation(null, new XValuePresentation(){

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                if (renderer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/debugger/VariableView$5", "renderValue"));
                }
                renderer.renderValue("\u2026");
            }
        }, false);
        node.setFullValueEvaluator(new XFullValueEvaluator(" (invoke getter)"){

            public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/VariableView$6", "startEvaluation"));
                }
                ValueModifier valueModifier = VariableView.this.variable.getValueModifier();
                assert (valueModifier != null);
                valueModifier.evaluateGet(VariableView.this.variable, VariableView.this.getEvaluateContext()).done((Consumer)new ObsolescentConsumer<Value>((Obsolescent)node){

                    public void consume(Value value) {
                        callback.evaluated("");
                        VariableView.this.setEvaluatedValue(value, null, node);
                    }
                });
            }
        }.setShowValuePopup(false));
    }

    private void setEvaluatedValue(@Nullable Value value, @Nullable String error, @NotNull XValueNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "setEvaluatedValue"));
        }
        if (value == null) {
            node.setPresentation(AllIcons.Debugger.Db_primitive, null, error == null ? "Internal Error" : error, false);
        } else {
            this.value = value;
            this.computePresentation(value, node);
        }
    }

    @NotNull
    static String trimFunctionDescription(@NotNull Value value) {
        int endIndex;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
        }
        String presentableValue = value.getValueString();
        if (presentableValue == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
            }
            return "";
        }
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string = presentableValue.substring(0, endIndex);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "trimFunctionDescription"));
        }
        return string;
    }

    private void computePresentation(@NotNull Value value, @NotNull XValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computePresentation"));
        }
        String valueString = value.getValueString();
        switch (value.getType()) {
            case OBJECT: 
            case NODE: {
                this.context.getViewSupport().computeObjectPresentation((ObjectValue)value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case FUNCTION: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableView.trimFunctionDescription(value)), true);
                break;
            }
            case ARRAY: {
                this.context.getViewSupport().computeArrayPresentation(value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case BOOLEAN: 
            case NULL: 
            case UNDEFINED: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XKeywordValuePresentation(valueString), false);
                break;
            }
            case NUMBER: {
                node.setPresentation(this.getIcon(), VariableView.createNumberPresentation(valueString), false);
                break;
            }
            case STRING: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new XStringValuePresentation(valueString), false);
                if ((!(value instanceof StringValue) || !((StringValue)value).isTruncated()) && valueString.length() <= 1000) break;
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value));
                break;
            }
            default: {
                node.setPresentation(this.getIcon(), null, valueString, true);
            }
        }
    }

    @NotNull
    private static XValuePresentation createNumberPresentation(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "createNumberPresentation"));
        }
        Object object = value.equals("NaN") || value.equals("Infinity") ? new XKeywordValuePresentation(value) : new XNumericValuePresentation(value);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "createNumberPresentation"));
        }
        return object;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computeChildren"));
        }
        node.setAlreadySorted(true);
        if (!(this.value instanceof ObjectValue)) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        List<Variable> list = this.remainingChildren;
        if (list != null) {
            int to = Math.min(this.remainingChildrenOffset + 100, list.size());
            boolean isLast = to == list.size();
            node.addChildren(Variables.createVariablesList(list, this.remainingChildrenOffset, to, this, this.memberFilter), isLast);
            if (!isLast) {
                node.tooManyChildren(list.size() - to);
                this.remainingChildrenOffset += 100;
            }
            return;
        }
        final ObjectValue objectValue = (ObjectValue)this.value;
        boolean hasNamedProperties = objectValue.hasProperties() != ThreeState.NO;
        boolean hasIndexedProperties = objectValue.hasIndexedProperties() != ThreeState.NO;
        SmartList promises = new SmartList();
        Promise<Void> additionalProperties = this.getViewSupport().computeAdditionalObjectProperties(objectValue, this.variable, this, node);
        if (additionalProperties != null) {
            promises.add(additionalProperties);
        }
        if (hasIndexedProperties) {
            promises.add(this.computeIndexedProperties((ArrayValue)objectValue, node, !hasNamedProperties && additionalProperties == null));
        }
        if (hasNamedProperties) {
            if (additionalProperties == null || additionalProperties.getState() != Promise.State.PENDING) {
                promises.add(this.computeNamedProperties(objectValue, node, !hasIndexedProperties && additionalProperties == null));
            } else {
                promises.add(additionalProperties.then((AsyncFunction)new ObsolescentAsyncFunction<Void, Void>(){

                    public boolean isObsolete() {
                        return node.isObsolete();
                    }

                    @NotNull
                    public Promise<Void> fun(Void o) {
                        Promise promise = VariableView.this.computeNamedProperties(objectValue, node, true);
                        if (promise == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView$7", "fun"));
                        }
                        return promise;
                    }
                }));
            }
        }
        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
            Promise.all((Collection)promises).processed((Consumer)new ObsolescentConsumer<Void>((Obsolescent)node){

                public void consume(Void aVoid) {
                    node.addChildren(XValueChildrenList.EMPTY, true);
                }
            });
        }
    }

    @NotNull
    private Promise<?> computeIndexedProperties(final @NotNull ArrayValue value, @NotNull XCompositeNode node, final boolean isLastChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "computeIndexedProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computeIndexedProperties"));
        }
        Promise<Void> promise = value.getIndexedProperties(0, value.getLength(), 100, new ObsolescentIndexedVariablesConsumer(node){

            @Override
            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroup.addGroups(value, LazyVariablesGroup.GROUP_FACTORY, groupList, 0, value.getLength(), 100, VariableView.this);
                    this.node.addChildren(groupList, isLastChildren);
                } else {
                    LazyVariablesGroup.addRanges(value, ranges, this.node, VariableView.this, isLastChildren);
                }
            }

            @Override
            public void consumeVariables(@NotNull List<Variable> variables) {
                if (variables == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "org/jetbrains/debugger/VariableView$9", "consumeVariables"));
                }
                this.node.addChildren(Variables.createVariablesList(variables, VariableView.this, null), isLastChildren);
            }
        }, null);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "computeIndexedProperties"));
        }
        return promise;
    }

    @NotNull
    private Promise<Void> computeNamedProperties(final @NotNull ObjectValue value, final @NotNull XCompositeNode node, final boolean isLastChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView", "computeNamedProperties"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computeNamedProperties"));
        }
        Promise<Void> promise = Variables.processVariables(this, value.getProperties(), (Obsolescent)node, new PairConsumer<MemberFilter, List<Variable>>(){

            public void consume(MemberFilter memberFilter, List<Variable> variables) {
                FunctionValue functionValue;
                VariableView.this.memberFilter = memberFilter;
                if (value.getType() == ValueType.ARRAY && !(value instanceof ArrayValue)) {
                    VariableView.this.computeArrayRanges(variables, node);
                    return;
                }
                FunctionValue functionValue2 = functionValue = value instanceof FunctionValue ? (FunctionValue)value : null;
                if (functionValue != null && functionValue.hasScopes() == ThreeState.NO) {
                    functionValue = null;
                }
                VariableView.this.remainingChildren = Variables.processNamedObjectProperties(variables, node, VariableView.this, memberFilter, 100, isLastChildren && functionValue == null);
                if (VariableView.this.remainingChildren != null) {
                    VariableView.this.remainingChildrenOffset = 100;
                }
                if (functionValue != null) {
                    node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.this.context)), isLastChildren);
                }
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "computeNamedProperties"));
        }
        return promise;
    }

    private void computeArrayRanges(@NotNull List<Variable> properties, @NotNull XCompositeNode node) {
        int notGroupedVariablesOffset;
        int bucketSize;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/debugger/VariableView", "computeArrayRanges"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView", "computeArrayRanges"));
        }
        List<Variable> variables = Variables.filterAndSort(properties, this.memberFilter);
        int count = variables.size();
        if (count <= (bucketSize = 100)) {
            node.addChildren(Variables.createVariablesList(variables, this, null), true);
            return;
        }
        while (count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0))) {
            --count;
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, 0, count, bucketSize, this);
        }
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0 && variables.get(notGroupedVariablesOffset - 1).getName().startsWith("__"); --notGroupedVariablesOffset) {
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        for (int i = notGroupedVariablesOffset; i < variables.size(); ++i) {
            Variable variable = variables.get(i);
            groupList.add((XNamedValue)new VariableView(this.memberFilter.getName(variable), variable, this));
        }
        node.addChildren(groupList, true);
    }

    @NotNull
    private Icon getIcon() {
        Icon icon = VariableView.getIcon(this.value);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(){

            public String getInitialValueEditorText() {
                if (VariableView.this.value.getType() == ValueType.STRING) {
                    String string = VariableView.this.value.getValueString();
                    StringBuilder builder = new StringBuilder(string.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string.length(), (String)string, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                return VariableView.this.value.getType().isObjectType() ? null : VariableView.this.value.getValueString();
            }

            public void setValue(@NotNull String expression, final @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/debugger/VariableView$11", "setValue"));
                }
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/VariableView$11", "setValue"));
                }
                ValueModifier valueModifier = VariableView.this.variable.getValueModifier();
                assert (valueModifier != null);
                valueModifier.setValue(VariableView.this.variable, expression, VariableView.this.getEvaluateContext()).done(new Consumer(){

                    public void consume(Object o) {
                        VariableView.this.value = null;
                        callback.valueModified();
                    }
                }).rejected(VariableView.createErrorMessageConsumer((XValueCallback)callback));
            }
        };
    }

    private static Consumer<Throwable> createErrorMessageConsumer(final @NotNull XValueCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/VariableView", "createErrorMessageConsumer"));
        }
        return new Consumer<Throwable>(){

            public void consume(Throwable error) {
                callback.errorOccurred(error.getMessage());
            }
        };
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext = this.context.getEvaluateContext();
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    @Nullable
    public Value getValue() {
        return this.variable.getValue();
    }

    public boolean canNavigateToSource() {
        return this.value instanceof FunctionValue || this.getViewSupport().canNavigateToSource(this.variable, this.context);
    }

    public void computeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigatable", "org/jetbrains/debugger/VariableView", "computeSourcePosition"));
        }
        if (this.value instanceof FunctionValue) {
            ((FunctionValue)this.value).resolve().done((Consumer)new Consumer<FunctionValue>(){

                public void consume(final FunctionValue function) {
                    VariableView.this.getViewSupport().getVm().getScriptManager().getScript(function).done((Consumer)new Consumer<Script>(){

                        public void consume(Script script) {
                            SourceInfo position = script == null ? null : VariableView.this.getViewSupport().getSourceInfo(null, script, function.getOpenParenLine(), function.getOpenParenColumn());
                            navigatable.setSourcePosition((XSourcePosition)(position == null ? null : new XSourcePositionWrapper(position){

                                @NotNull
                                public Navigatable createNavigatable(@NotNull Project project) {
                                    if (project == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/debugger/VariableView$13$1$1", "createNavigatable"));
                                    }
                                    Navigatable result = PsiVisitors.visit(this.myPosition, project, new PsiVisitors.Visitor<Navigatable>(){

                                        @Override
                                        public Navigatable visit(@NotNull PsiElement element, int positionOffset, @NotNull Document document) {
                                            if (element == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/debugger/VariableView$13$1$1$1", "visit"));
                                            }
                                            if (document == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/debugger/VariableView$13$1$1$1", "visit"));
                                            }
                                            PsiElement referenceCandidate = element;
                                            PsiElement psiReference = null;
                                            while ((referenceCandidate = referenceCandidate.getPrevSibling()) != null) {
                                                if (!(referenceCandidate instanceof PsiReference)) continue;
                                                psiReference = referenceCandidate;
                                                break;
                                            }
                                            if (psiReference == null && (referenceCandidate = element.getParent()) != null) {
                                                while ((referenceCandidate = referenceCandidate.getPrevSibling()) != null) {
                                                    if (!(referenceCandidate instanceof PsiReference)) continue;
                                                    psiReference = referenceCandidate;
                                                    break;
                                                }
                                            }
                                            PsiElement navigationElement = psiReference == null ? element.getNavigationElement() : psiReference.getNavigationElement();
                                            return navigationElement instanceof Navigatable ? (Navigatable)navigationElement : null;
                                        }
                                    }, null);
                                    Navigatable navigatable = result == null ? super.createNavigatable(project) : result;
                                    if (navigatable == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView$13$1$1", "createNavigatable"));
                                    }
                                    return navigatable;
                                }
                            }));
                        }
                    });
                }
            });
        } else {
            this.getViewSupport().computeSourcePosition(this.getName(), this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/VariableView", "computeInlineDebuggerData"));
        }
        ThreeState threeState = this.getViewSupport().computeInlineDebuggerData(this.getName(), this.variable, this.context, callback);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableView", "computeInlineDebuggerData"));
        }
        return threeState;
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        SmartList list = new SmartList((Object)this.variable.getName());
        for (VariableContext parent = this.context; parent != null && parent.getName() != null; parent = parent.getParent()) {
            list.add((Object)parent.getName());
        }
        return this.context.getViewSupport().propertyNamesToString((List<String>)list, false);
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    private static class MyFullValueEvaluator
    extends XFullValueEvaluator {
        private final Value value;

        public MyFullValueEvaluator(@NotNull Value value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/VariableView$MyFullValueEvaluator", "<init>"));
            }
            super(value instanceof StringValue ? ((StringValue)value).getLength() : value.getValueString().length());
            this.value = value;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/debugger/VariableView$MyFullValueEvaluator", "startEvaluation"));
            }
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                callback.evaluated(this.value.getValueString());
                return;
            }
            final AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().done((Consumer)new Consumer<String>(){

                public void consume(String s) {
                    if (!callback.isObsolete() && evaluated.compareAndSet(false, true)) {
                        callback.evaluated(MyFullValueEvaluator.this.value.getValueString());
                    }
                }
            }).rejected(VariableView.createErrorMessageConsumer((XValueCallback)callback));
        }
    }

    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        protected final XCompositeNode node;

        protected ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer", "<init>"));
            }
            this.node = node;
        }

        @Override
        public boolean isObsolete() {
            return this.node.isObsolete();
        }
    }

    private static final class ArrayPresentation
    extends XValuePresentation {
        private final String length;
        private final String className;

        private ArrayPresentation(int length, @Nullable String className) {
            this.length = Integer.toString(length);
            this.className = StringUtil.isEmpty((String)className) ? "Array" : className;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/debugger/VariableView$ArrayPresentation", "renderValue"));
            }
            renderer.renderSpecialSymbol(this.className);
            renderer.renderSpecialSymbol("[");
            renderer.renderSpecialSymbol(this.length);
            renderer.renderSpecialSymbol("]");
        }
    }
}

