/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.ListTableModel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.theoryinpractice.testng.MessageInfoException;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.browser.GroupBrowser;
import com.theoryinpractice.testng.configuration.browser.MethodBrowser;
import com.theoryinpractice.testng.configuration.browser.PackageBrowser;
import com.theoryinpractice.testng.configuration.browser.SuiteBrowser;
import com.theoryinpractice.testng.configuration.browser.TestClassBrowser;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestListenerFilter;
import com.theoryinpractice.testng.model.TestNGConfigurationModel;
import com.theoryinpractice.testng.model.TestNGListenersTableModel;
import com.theoryinpractice.testng.model.TestNGParametersTableModel;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestNGConfigurationEditor
extends SettingsEditor<TestNGConfiguration>
implements PanelWithAnchor {
    private final Project project;
    private JPanel panel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> classField;
    private LabeledComponent<JComboBox> moduleClasspath;
    private AlternativeJREPanel alternateJDK;
    private final ConfigurationModuleSelector moduleSelector;
    private JRadioButton suiteTest;
    private JRadioButton packageTest;
    private JRadioButton classTest;
    private JRadioButton methodTest;
    private JRadioButton groupTest;
    private JRadioButton patternTest;
    private final TestNGConfigurationModel model;
    private LabeledComponent<EditorTextFieldWithBrowseButton> methodField;
    private LabeledComponent<EditorTextFieldWithBrowseButton> packageField;
    private LabeledComponent<TextFieldWithBrowseButton.NoPathCompletion> groupField;
    private LabeledComponent<TextFieldWithBrowseButton> suiteField;
    private JComponent anchor;
    private JRadioButton packagesInProject;
    private JRadioButton packagesInModule;
    private JRadioButton packagesAcrossModules;
    private JPanel packagePanel;
    private TestNGParametersTableModel propertiesTableModel;
    private LabeledComponent<TextFieldWithBrowseButton> propertiesFile;
    private LabeledComponent<TextFieldWithBrowseButton> outputDirectory;
    private TableView propertiesTableView;
    private JPanel commonParametersPanel;
    private JList myListenersList;
    private JCheckBox myUseDefaultReportersCheckBox;
    private LabeledComponent<JPanel> myPattern;
    private JPanel myPropertiesPanel;
    private JPanel myListenersPanel;
    TextFieldWithBrowseButton myPatternTextField;
    private final CommonJavaParametersPanel commonJavaParameters;
    private final ArrayList<Map.Entry> propertiesList;
    private TestNGListenersTableModel listenerModel;
    private TestNGConfiguration config;

    public TestNGConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.commonJavaParameters = new CommonJavaParametersPanel();
        this.propertiesList = new ArrayList();
        this.project = project;
        BrowseModuleValueActionListener[] browseListeners = new BrowseModuleValueActionListener[]{new PackageBrowser(project), new TestClassBrowser(project, this), new MethodBrowser(project, this), new GroupBrowser(project, this), new SuiteBrowser(project), new TestClassBrowser(project, this){

            @Override
            protected void onClassChoosen(PsiClass psiClass) {
                JTextField textField = TestNGConfigurationEditor.this.myPatternTextField.getTextField();
                String text = textField.getText();
                textField.setText(text + (text.length() > 0 ? "||" : "") + psiClass.getQualifiedName());
            }

            public void actionPerformed(ActionEvent e) {
                this.showDialog();
            }
        }};
        this.model = new TestNGConfigurationModel(project);
        this.model.setListener(this);
        this.createView();
        this.moduleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        this.commonJavaParameters.setModuleContext(this.moduleSelector.getModule());
        ((JComboBox)this.moduleClasspath.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestNGConfigurationEditor.this.commonJavaParameters.setModuleContext(TestNGConfigurationEditor.this.moduleSelector.getModule());
            }
        });
        this.commonJavaParameters.setHasModuleMacro();
        JPanel panel = (JPanel)this.myPattern.getComponent();
        panel.setLayout(new BorderLayout());
        this.myPatternTextField = new TextFieldWithBrowseButton();
        this.myPatternTextField.setButtonIcon(IconUtil.getAddIcon());
        panel.add((Component)this.myPatternTextField, "Center");
        FixedSizeButton editBtn = new FixedSizeButton();
        editBtn.setIcon(AllIcons.Actions.ShowViewer);
        editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.showTextAreaDialog((JTextField)TestNGConfigurationEditor.this.myPatternTextField.getTextField(), (String)"Configure suite tests", (String)"EditParametersPopupWindow");
            }
        });
        panel.add((Component)editBtn, "East");
        TestNGConfigurationEditor.registerListener(new JRadioButton[]{this.packageTest, this.classTest, this.methodTest, this.groupTest, this.suiteTest, this.patternTest}, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel buttonModel = (ButtonModel)e.getSource();
                if (buttonModel.isSelected()) {
                    if (buttonModel == TestNGConfigurationEditor.this.packageTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.PACKAGE);
                    } else if (buttonModel == TestNGConfigurationEditor.this.classTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.CLASS);
                    } else if (buttonModel == TestNGConfigurationEditor.this.methodTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.METHOD);
                    } else if (buttonModel == TestNGConfigurationEditor.this.groupTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.GROUP);
                    } else if (buttonModel == TestNGConfigurationEditor.this.suiteTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.SUITE);
                    } else if (buttonModel == TestNGConfigurationEditor.this.patternTest.getModel()) {
                        TestNGConfigurationEditor.this.model.setType(TestType.PATTERN);
                    }
                }
            }
        });
        TestNGConfigurationEditor.registerListener(new JRadioButton[]{this.packagesInProject, this.packagesInModule, this.packagesAcrossModules}, null);
        this.packagesInProject.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TestNGConfigurationEditor.this.evaluateModuleClassPath();
            }
        });
        LabeledComponent[] components = new LabeledComponent[]{this.packageField, this.classField, this.methodField, this.groupField, this.suiteField, this.myPattern};
        for (int i = 0; i < components.length; ++i) {
            JComponent field = components[i].getComponent();
            Object document = this.model.getDocument(i);
            if (field instanceof TextFieldWithBrowseButton) {
                ((TextFieldWithBrowseButton)field).getTextField().setDocument((PlainDocument)document);
            } else if (field instanceof EditorTextFieldWithBrowseButton) {
                Document componentDocument = ((EditorTextField)((EditorTextFieldWithBrowseButton)field).getChildComponent()).getDocument();
                this.model.setDocument(i, componentDocument);
            } else {
                field = this.myPatternTextField;
                document = new PlainDocument();
                ((TextFieldWithBrowseButton)field).getTextField().setDocument((javax.swing.text.Document)document);
                this.model.setDocument(i, document);
            }
            browseListeners[i].setField((ComponentWithBrowseButton)field);
        }
        this.model.setType(TestType.CLASS);
        ((TextFieldWithBrowseButton)this.propertiesFile.getComponent()).getTextField().setDocument(this.model.getPropertiesFileDocument());
        ((TextFieldWithBrowseButton)this.outputDirectory.getComponent()).getTextField().setDocument(this.model.getOutputDirectoryDocument());
        this.commonJavaParameters.setProgramParametersLabel(ExecutionBundle.message((String)"junit.configuration.test.runner.parameters.label", (Object[])new Object[0]));
        this.setAnchor((JComponent)this.outputDirectory.getLabel());
        this.alternateJDK.setAnchor((JComponent)this.moduleClasspath.getLabel());
        this.commonJavaParameters.setAnchor((JComponent)this.moduleClasspath.getLabel());
    }

    private void evaluateModuleClassPath() {
        boolean allPackagesInProject = this.packagesInProject.isSelected() && this.packagePanel.isVisible();
        this.moduleClasspath.setEnabled(!allPackagesInProject);
        if (allPackagesInProject) {
            ((JComboBox)this.moduleClasspath.getComponent()).setSelectedItem(null);
        }
    }

    private void redisplay() {
        if (this.packageTest.isSelected()) {
            this.packagePanel.setVisible(true);
            this.packageField.setVisible(true);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
            this.myPattern.setVisible(false);
        } else if (this.classTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(true);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
            this.myPattern.setVisible(false);
        } else if (this.methodTest.isSelected()) {
            this.packagePanel.setVisible(false);
            this.classField.setVisible(true);
            this.methodField.setVisible(true);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
            this.myPattern.setVisible(false);
        } else if (this.groupTest.isSelected()) {
            this.packagePanel.setVisible(true);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(true);
            this.suiteField.setVisible(false);
            this.myPattern.setVisible(false);
        } else if (this.suiteTest.isSelected()) {
            this.packagePanel.setVisible(true);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(true);
            this.myPattern.setVisible(false);
        } else if (this.patternTest.isSelected()) {
            this.packagePanel.setVisible(true);
            this.classField.setVisible(false);
            this.methodField.setVisible(false);
            this.groupField.setVisible(false);
            this.suiteField.setVisible(false);
            this.myPattern.setVisible(true);
        }
    }

    public String getClassName() {
        return ((EditorTextFieldWithBrowseButton)this.classField.getComponent()).getText();
    }

    public JComboBox getModulesComponent() {
        return (JComboBox)this.moduleClasspath.getComponent();
    }

    protected void resetEditorFrom(TestNGConfiguration config) {
        this.config = config;
        this.model.reset(config);
        this.commonJavaParameters.reset((CommonJavaRunConfigurationParameters)config);
        this.getModuleSelector().reset((ModuleBasedConfiguration)config);
        TestData data = config.getPersistantData();
        TestSearchScope scope = data.getScope();
        if (scope == TestSearchScope.SINGLE_MODULE) {
            this.packagesInModule.setSelected(true);
        } else if (scope == TestSearchScope.MODULE_WITH_DEPENDENCIES) {
            this.packagesAcrossModules.setSelected(true);
        } else {
            this.packagesInProject.setSelected(true);
        }
        this.evaluateModuleClassPath();
        this.alternateJDK.init(config.ALTERNATIVE_JRE_PATH, config.ALTERNATIVE_JRE_PATH_ENABLED);
        this.propertiesList.clear();
        this.propertiesList.addAll(data.TEST_PROPERTIES.entrySet());
        this.propertiesTableModel.setParameterList(this.propertiesList);
        this.listenerModel.setListenerList(data.TEST_LISTENERS);
        this.myUseDefaultReportersCheckBox.setSelected(data.USE_DEFAULT_REPORTERS);
    }

    public void applyEditorTo(TestNGConfiguration config) {
        this.model.apply(this.getModuleSelector().getModule(), config);
        this.getModuleSelector().applyTo((ModuleBasedConfiguration)config);
        TestData data = config.getPersistantData();
        if (!this.classTest.isSelected() && !this.methodTest.isSelected()) {
            if (this.packagesInProject.isSelected()) {
                data.setScope(TestSearchScope.WHOLE_PROJECT);
            } else if (this.packagesInModule.isSelected()) {
                data.setScope(TestSearchScope.SINGLE_MODULE);
            } else if (this.packagesAcrossModules.isSelected()) {
                data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
            }
        } else {
            data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        this.commonJavaParameters.applyTo((CommonJavaRunConfigurationParameters)config);
        config.ALTERNATIVE_JRE_PATH = this.alternateJDK.getPath();
        config.ALTERNATIVE_JRE_PATH_ENABLED = this.alternateJDK.isPathEnabled();
        data.TEST_PROPERTIES.clear();
        for (Map.Entry entry : this.propertiesList) {
            data.TEST_PROPERTIES.put((String)entry.getKey(), (String)entry.getValue());
        }
        data.TEST_LISTENERS.clear();
        data.TEST_LISTENERS.addAll(this.listenerModel.getListenerList());
        data.USE_DEFAULT_REPORTERS = this.myUseDefaultReportersCheckBox.isSelected();
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.moduleSelector;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/configuration/TestNGConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.methodField.setAnchor(anchor);
        this.packageField.setAnchor(anchor);
        this.groupField.setAnchor(anchor);
        this.suiteField.setAnchor(anchor);
        this.outputDirectory.setAnchor(anchor);
        this.classField.setAnchor(anchor);
        this.myPattern.setAnchor(anchor);
    }

    private static void registerListener(JRadioButton[] buttons, ChangeListener changelistener) {
        ButtonGroup buttongroup = new ButtonGroup();
        for (JRadioButton button : buttons) {
            button.getModel().addChangeListener(changelistener);
            buttongroup.add(button);
        }
        if (buttongroup.getSelection() == null) {
            buttongroup.setSelected(buttons[0].getModel(), true);
        }
    }

    private void createView() {
        this.commonParametersPanel.add((Component)this.commonJavaParameters, "Center");
        this.packageTest.setSelected(false);
        this.suiteTest.setSelected(false);
        this.suiteTest.setEnabled(true);
        this.groupTest.setSelected(false);
        this.groupTest.setEnabled(true);
        this.classTest.setSelected(false);
        this.classTest.setEnabled(true);
        this.patternTest.setSelected(false);
        this.patternTest.setEnabled(true);
        this.classField.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.project, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                try {
                    if (declaration instanceof PsiClass && new TestClassBrowser(TestNGConfigurationEditor.this.project, TestNGConfigurationEditor.this).getFilter().isAccepted((PsiClass)declaration)) {
                        return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                    }
                }
                catch (MessageInfoException e) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        EditorTextFieldWithBrowseButton methodEditorTextField = new EditorTextFieldWithBrowseButton(this.project, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType());
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/theoryinpractice/testng/configuration/TestNGConfigurationEditor$7", "addCompletionVariants"));
                }
                if (prefix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/theoryinpractice/testng/configuration/TestNGConfigurationEditor$7", "addCompletionVariants"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/theoryinpractice/testng/configuration/TestNGConfigurationEditor$7", "addCompletionVariants"));
                }
                String className = TestNGConfigurationEditor.this.getClassName();
                if (className.trim().length() == 0) {
                    return;
                }
                PsiClass testClass = TestNGConfigurationEditor.this.getModuleSelector().findClass(className);
                if (testClass == null) {
                    return;
                }
                for (PsiMethod psiMethod : testClass.getAllMethods()) {
                    if (!TestNGUtil.hasTest((PsiModifierListOwner)psiMethod)) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)psiMethod.getName()));
                }
            }
        }.apply((EditorTextField)methodEditorTextField.getChildComponent());
        this.methodField.setComponent((JComponent)methodEditorTextField);
        this.groupField.setComponent((JComponent)new TextFieldWithBrowseButton.NoPathCompletion());
        this.suiteField.setComponent((JComponent)new TextFieldWithBrowseButton());
        this.packageField.setVisible(true);
        this.packageField.setEnabled(true);
        this.packageField.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.project, false));
        TextFieldWithBrowseButton outputDirectoryButton = new TextFieldWithBrowseButton();
        this.outputDirectory.setComponent((JComponent)outputDirectoryButton);
        outputDirectoryButton.addBrowseFolderListener("TestNG", "Select test output directory", this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.moduleClasspath.setEnabled(true);
        this.moduleClasspath.setComponent(new JComboBox());
        this.propertiesTableModel = new TestNGParametersTableModel();
        this.listenerModel = new TestNGListenersTableModel();
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        this.propertiesFile.setComponent((JComponent)textFieldWithBrowseButton);
        FileChooserDescriptor propertiesFileDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile virtualFile, boolean showHidden) {
                if (!showHidden && virtualFile.getName().charAt(0) == '.') {
                    return false;
                }
                return virtualFile.isDirectory() || "properties".equals(virtualFile.getExtension());
            }
        };
        textFieldWithBrowseButton.addBrowseFolderListener("TestNG", "Select .properties file for test properties", this.project, propertiesFileDescriptor);
        this.propertiesTableView = new TableView();
        this.propertiesTableView.setModelAndUpdateColumns((ListTableModel)this.propertiesTableModel);
        this.propertiesTableView.setShowGrid(true);
        this.myPropertiesPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.propertiesTableView).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TestNGConfigurationEditor.this.propertiesTableModel.addParameter();
                int index = TestNGConfigurationEditor.this.propertiesTableModel.getRowCount() - 1;
                TestNGConfigurationEditor.this.propertiesTableView.setRowSelectionInterval(index, index);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int idx = TestNGConfigurationEditor.this.propertiesTableView.getSelectedRow() - 1;
                for (int row : TestNGConfigurationEditor.this.propertiesTableView.getSelectedRows()) {
                    TestNGConfigurationEditor.this.propertiesTableModel.removeProperty(row);
                }
                if (idx > -1) {
                    TestNGConfigurationEditor.this.propertiesTableView.setRowSelectionInterval(idx, idx);
                }
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myListenersList = new JBList((ListModel)this.listenerModel);
        this.myListenersPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myListenersList).setAddAction((AnActionButtonRunnable)new AddActionButtonRunnable()).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int idx = TestNGConfigurationEditor.this.myListenersList.getSelectedIndex() - 1;
                for (int row : TestNGConfigurationEditor.this.myListenersList.getSelectedIndices()) {
                    TestNGConfigurationEditor.this.listenerModel.removeListener(row);
                }
                if (idx > -1) {
                    TestNGConfigurationEditor.this.myListenersList.setSelectedIndex(idx);
                }
            }
        }).setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !TestNGConfigurationEditor.this.project.isDefault();
            }
        }).disableUpDownActions().createPanel(), "Center");
    }

    public void onTypeChanged(TestType type) {
        if (type == TestType.PACKAGE) {
            this.packageTest.setSelected(true);
            this.packageField.setEnabled(true);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
            this.myPattern.setEnabled(false);
        } else if (type == TestType.CLASS) {
            this.classTest.setSelected(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(true);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
            this.myPattern.setEnabled(false);
        } else if (type == TestType.METHOD) {
            this.methodTest.setSelected(true);
            this.packageField.setEnabled(false);
            this.classField.setEnabled(true);
            this.methodField.setEnabled(true);
            this.groupField.setEnabled(false);
            this.suiteField.setEnabled(false);
            this.myPattern.setEnabled(false);
        } else if (type == TestType.GROUP) {
            this.groupTest.setSelected(true);
            this.groupField.setEnabled(true);
            this.packageField.setVisible(false);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.suiteField.setEnabled(false);
            this.myPattern.setEnabled(false);
        } else if (type == TestType.SUITE) {
            this.suiteTest.setSelected(true);
            this.suiteField.setEnabled(true);
            this.packageField.setVisible(false);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
            this.myPattern.setEnabled(false);
        } else if (type == TestType.PATTERN) {
            this.patternTest.setSelected(true);
            this.myPattern.setEnabled(true);
            this.suiteField.setEnabled(false);
            this.packageField.setVisible(false);
            this.classField.setEnabled(false);
            this.methodField.setEnabled(false);
            this.groupField.setEnabled(false);
        }
        this.redisplay();
        this.evaluateModuleClassPath();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JRadioButton jRadioButton5;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        LabeledComponent labeledComponent;
        JPanel jPanel3;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        LabeledComponent labeledComponent5;
        LabeledComponent labeledComponent6;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JRadioButton jRadioButton8;
        LabeledComponent labeledComponent7;
        JPanel jPanel4;
        LabeledComponent labeledComponent8;
        LabeledComponent labeledComponent9;
        JPanel jPanel5;
        this.panel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.methodField = labeledComponent9 = new LabeledComponent();
        labeledComponent9.setLabelLocation("West");
        labeledComponent9.setText("M&ethod");
        jPanel6.add((Component)labeledComponent9, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.suiteField = labeledComponent8 = new LabeledComponent();
        labeledComponent8.setLabelLocation("West");
        labeledComponent8.setText("&Suite");
        jPanel6.add((Component)labeledComponent8, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.packagePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:d:noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel6.add((Component)jPanel4, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.packageField = labeledComponent7 = new LabeledComponent();
        labeledComponent7.setLabelLocation("West");
        labeledComponent7.setText("Packa&ge");
        jPanel4.add((Component)labeledComponent7, new CellConstraints(1, 1, 5, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesInProject = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("In whole project");
        jRadioButton8.setMnemonic('W');
        jRadioButton8.setDisplayedMnemonicIndex(3);
        jPanel4.add((Component)jRadioButton8, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesInModule = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("In single module");
        jRadioButton7.setMnemonic('S');
        jRadioButton7.setDisplayedMnemonicIndex(3);
        jPanel4.add((Component)jRadioButton7, new CellConstraints(3, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.packagesAcrossModules = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Across module dependencies");
        jRadioButton6.setMnemonic('D');
        jRadioButton6.setDisplayedMnemonicIndex(14);
        jPanel4.add((Component)jRadioButton6, new CellConstraints(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.classField = labeledComponent6 = new LabeledComponent();
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText("&Class");
        jPanel6.add((Component)labeledComponent6, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.outputDirectory = labeledComponent5 = new LabeledComponent();
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText("&Output directory");
        jPanel6.add((Component)labeledComponent5, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.groupField = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText("&Group");
        jPanel6.add((Component)labeledComponent4, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myPattern = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setVisible(true);
        labeledComponent3.setComponentClass("javax.swing.JPanel");
        labeledComponent3.setText("Pattern");
        jPanel6.add((Component)labeledComponent3, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel5.add((Component)jBTabbedPane, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, new Dimension(200, 200), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("JDK Settings", null, jPanel7, null);
        this.moduleClasspath = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel7.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.alternateJDK = alternativeJREPanel = new AlternativeJREPanel();
        jPanel7.add((Component)alternativeJREPanel, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.commonParametersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 15), null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Parameters", null, jPanel8, null);
        this.propertiesFile = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("&Properties file");
        jPanel8.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPropertiesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Listeners", null, jPanel9, null);
        this.myListenersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel9.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myUseDefaultReportersCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use default reporters");
        jPanel9.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.groupTest = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Group");
        jRadioButton5.setMnemonic('G');
        jRadioButton5.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jRadioButton5, new GridConstraints(0, 2, 1, 1, 9, 0, 3, 0, null, null, null));
        this.classTest = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Class");
        jRadioButton4.setMnemonic('L');
        jRadioButton4.setDisplayedMnemonicIndex(1);
        jPanel10.add((Component)jRadioButton4, new GridConstraints(0, 3, 1, 1, 9, 0, 3, 0, null, null, null));
        this.methodTest = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Method");
        jRadioButton3.setMnemonic('M');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jRadioButton3, new GridConstraints(0, 4, 1, 1, 9, 0, 3, 0, null, null, null));
        this.packageTest = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("All in package");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(7);
        jPanel10.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.suiteTest = jRadioButton = new JRadioButton();
        jRadioButton.setText("Suite");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(1);
        jPanel10.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 9, 0, 3, 0, null, null, null));
        JBRadioButton jBRadioButton = new JBRadioButton();
        this.patternTest = jBRadioButton;
        jBRadioButton.setText("Pattern");
        jPanel10.add((Component)jBRadioButton, new GridConstraints(0, 5, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel10.add((Component)spacer4, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private class AddActionButtonRunnable
    implements AnActionButtonRunnable {
        private final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");

        private AddActionButtonRunnable() {
        }

        @Nullable
        protected GlobalSearchScope getSearchScope(Module[] modules) {
            if (modules == null || modules.length == 0) {
                return null;
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)modules[0]);
            for (int i = 1; i < modules.length; ++i) {
                scope.uniteWith(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)modules[i]));
            }
            return scope;
        }

        @Nullable
        protected String selectListenerClass() {
            GlobalSearchScope searchScope = this.getSearchScope(TestNGConfigurationEditor.this.config.getModules());
            if (searchScope == null) {
                searchScope = GlobalSearchScope.allScope((Project)TestNGConfigurationEditor.this.project);
            }
            TestListenerFilter filter = new TestListenerFilter(searchScope, TestNGConfigurationEditor.this.project);
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)TestNGConfigurationEditor.this.project).createWithInnerClassesScopeChooser("Choose Listener Class", filter.getScope(), (ClassFilter)filter, null);
            chooser.showDialog();
            PsiClass psiclass = chooser.getSelected();
            if (psiclass == null) {
                return null;
            }
            return JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiclass);
        }

        public void run(AnActionButton button) {
            String className = this.selectListenerClass();
            if (className != null) {
                TestNGConfigurationEditor.this.listenerModel.addListener(className);
                this.LOGGER.info("Adding listener " + className + " to configuration.");
            }
        }
    }
}

