/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ComparatorDelegate;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgExecutableValidator;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectConfigurable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgRootsHandler;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVFSListener;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.provider.HgCachingCommittedChangesProvider;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.provider.HgCheckoutProvider;
import org.zmlx.hg4idea.provider.HgDiffProvider;
import org.zmlx.hg4idea.provider.HgHistoryProvider;
import org.zmlx.hg4idea.provider.HgMergeProvider;
import org.zmlx.hg4idea.provider.HgRollbackEnvironment;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationProvider;
import org.zmlx.hg4idea.provider.commit.HgCheckinEnvironment;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.provider.commit.HgCommitAndPushExecutor;
import org.zmlx.hg4idea.provider.update.HgUpdateEnvironment;
import org.zmlx.hg4idea.roots.HgIntegrationEnabler;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgHideableWidget;
import org.zmlx.hg4idea.status.ui.HgIncomingOutgoingWidget;
import org.zmlx.hg4idea.status.ui.HgStatusWidget;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgVcs
extends AbstractVcs<CommittedChangeList> {
    public static final Topic<HgUpdater> REMOTE_TOPIC = new Topic("hg4idea.remote", HgUpdater.class);
    public static final Topic<HgUpdater> STATUS_TOPIC = new Topic("hg4idea.status", HgUpdater.class);
    public static final Topic<HgHideableWidget> INCOMING_OUTGOING_CHECK_TOPIC = new Topic("hg4idea.incomingcheck", HgHideableWidget.class);
    private static final Logger LOG = Logger.getInstance(HgVcs.class);
    public static final String VCS_NAME = "hg4idea";
    public static final String DISPLAY_NAME = "Mercurial";
    private static final VcsKey ourKey = HgVcs.createKey((String)"hg4idea");
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private static final String ORIG_FILE_PATTERN = "*.orig";
    @Nullable
    public static final String HGENCODING = System.getenv("HGENCODING");
    private final HgChangeProvider changeProvider;
    private final HgRollbackEnvironment rollbackEnvironment;
    private final HgDiffProvider diffProvider;
    private final HgHistoryProvider historyProvider;
    private final HgCheckinEnvironment checkinEnvironment;
    private final HgAnnotationProvider annotationProvider;
    private final HgUpdateEnvironment updateEnvironment;
    private final HgCachingCommittedChangesProvider committedChangesProvider;
    private MessageBusConnection messageBusConnection;
    @NotNull
    private final HgGlobalSettings globalSettings;
    @NotNull
    private final HgProjectSettings projectSettings;
    private final ProjectLevelVcsManager myVcsManager;
    private HgVFSListener myVFSListener;
    private final HgMergeProvider myMergeProvider;
    private HgExecutableValidator myExecutableValidator;
    private final Object myExecutableValidatorLock;
    private File myPromptHooksExtensionFile;
    private final CommitExecutor myCommitAndPushExecutor;
    private final HgCloseBranchExecutor myCloseBranchExecutor;
    private HgRemoteStatusUpdater myHgRemoteStatusUpdater;
    private HgStatusWidget myStatusWidget;
    private HgIncomingOutgoingWidget myIncomingWidget;
    private HgIncomingOutgoingWidget myOutgoingWidget;
    @NotNull
    private HgVersion myVersion;

    public HgVcs(@NotNull Project project, @NotNull HgGlobalSettings globalSettings, @NotNull HgProjectSettings projectSettings, ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/HgVcs", "<init>"));
        }
        if (globalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalSettings", "org/zmlx/hg4idea/HgVcs", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "org/zmlx/hg4idea/HgVcs", "<init>"));
        }
        super(project, VCS_NAME);
        this.myExecutableValidatorLock = new Object();
        this.myVersion = HgVersion.NULL;
        this.globalSettings = globalSettings;
        this.projectSettings = projectSettings;
        this.myVcsManager = vcsManager;
        this.changeProvider = new HgChangeProvider(project, this.getKeyInstanceMethod());
        this.rollbackEnvironment = new HgRollbackEnvironment(project);
        this.diffProvider = new HgDiffProvider(project);
        this.historyProvider = new HgHistoryProvider(project);
        this.checkinEnvironment = new HgCheckinEnvironment(project);
        this.annotationProvider = new HgAnnotationProvider(project);
        this.updateEnvironment = new HgUpdateEnvironment(project);
        this.committedChangesProvider = new HgCachingCommittedChangesProvider(project, this);
        this.myMergeProvider = new HgMergeProvider(this.myProject);
        this.myCommitAndPushExecutor = new HgCommitAndPushExecutor(this.checkinEnvironment);
        this.myCloseBranchExecutor = new HgCloseBranchExecutor(this.checkinEnvironment);
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public Configurable getConfigurable() {
        return new HgProjectConfigurable(this.getProject(), this.projectSettings);
    }

    @NotNull
    public HgProjectSettings getProjectSettings() {
        HgProjectSettings hgProjectSettings = this.projectSettings;
        if (hgProjectSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgVcs", "getProjectSettings"));
        }
        return hgProjectSettings;
    }

    public ChangeProvider getChangeProvider() {
        return this.changeProvider;
    }

    @Nullable
    public RollbackEnvironment createRollbackEnvironment() {
        return this.rollbackEnvironment;
    }

    public DiffProvider getDiffProvider() {
        return this.diffProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return this.historyProvider;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.checkinEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public MergeProvider getMergeProvider() {
        return this.myMergeProvider;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.updateEnvironment;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.committedChangesProvider;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public <S> List<S> filterUniqueRoots(List<S> in, Convertor<S, VirtualFile> convertor) {
        Collections.sort(in, new ComparatorDelegate(convertor, (Comparator)FilePathComparator.getInstance()));
        block0: for (int i = 1; i < in.size(); ++i) {
            S sChild = in.get(i);
            VirtualFile child = (VirtualFile)convertor.convert(sChild);
            VirtualFile childRoot = HgUtil.getHgRootOrNull(this.myProject, child);
            if (childRoot == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                S sParent = in.get(j);
                VirtualFile parent = (VirtualFile)convertor.convert(sParent);
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false) || !VfsUtilCore.isAncestor((VirtualFile)childRoot, (VirtualFile)parent, (boolean)false)) continue;
                in.remove(i);
                --i;
                continue block0;
            }
        }
        return in;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return HgRootsHandler.getInstance(this.myProject);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return HgUtil.getNearestHgRoot(dir) != null;
    }

    @NotNull
    public File getPromptHooksExtensionFile() {
        if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
            this.myPromptHooksExtensionFile = HgUtil.getTemporaryPythonFile("prompthooks");
            if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
                LOG.error("prompthooks.py Mercurial extension is not found. Please reinstall " + ApplicationNamesInfo.getInstance().getProductName());
            }
        }
        File file = this.myPromptHooksExtensionFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgVcs", "getPromptHooksExtensionFile"));
        }
        return file;
    }

    public void activate() {
        this.checkExecutableAndVersion();
        this.myStatusWidget = new HgStatusWidget(this, this.getProject(), this.projectSettings);
        this.myStatusWidget.activate();
        this.myIncomingWidget = new HgIncomingOutgoingWidget(this, this.getProject(), this.projectSettings, true);
        this.myOutgoingWidget = new HgIncomingOutgoingWidget(this, this.getProject(), this.projectSettings, false);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                HgVcs.this.myIncomingWidget.activate();
                HgVcs.this.myOutgoingWidget.activate();
            }
        }, ModalityState.NON_MODAL);
        this.myHgRemoteStatusUpdater = new HgRemoteStatusUpdater(this, this.myIncomingWidget.getChangesetStatus(), this.myOutgoingWidget.getChangesetStatus(), this.projectSettings);
        this.myHgRemoteStatusUpdater.activate();
        this.messageBusConnection = this.myProject.getMessageBus().connect();
        this.myVFSListener = new HgVFSListener(this.myProject, this);
        String ignoredPattern = FileTypeManager.getInstance().getIgnoredFilesList();
        if (!ignoredPattern.contains(ORIG_FILE_PATTERN)) {
            final String newPattern = ignoredPattern + (ignoredPattern.endsWith(";") ? "" : ";") + ORIG_FILE_PATTERN;
            HgUtil.runWriteActionLater(new Runnable(){

                @Override
                public void run() {
                    FileTypeManager.getInstance().setIgnoredFilesList(newPattern);
                }
            });
        }
    }

    private void checkExecutableAndVersion() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            this.checkVersion();
        }
    }

    public void deactivate() {
        if (this.myHgRemoteStatusUpdater != null) {
            this.myHgRemoteStatusUpdater.deactivate();
            this.myHgRemoteStatusUpdater = null;
        }
        if (this.myStatusWidget != null) {
            this.myStatusWidget.deactivate();
            this.myStatusWidget = null;
        }
        if (this.myIncomingWidget != null) {
            this.myIncomingWidget.deactivate();
            this.myIncomingWidget = null;
        }
        if (this.myOutgoingWidget != null) {
            this.myOutgoingWidget.deactivate();
            this.myOutgoingWidget = null;
        }
        if (this.messageBusConnection != null) {
            this.messageBusConnection.disconnect();
        }
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        super.deactivate();
    }

    @Nullable
    public static HgVcs getInstance(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (vcsManager == null) {
            return null;
        }
        return (HgVcs)vcsManager.findVcsByName(VCS_NAME);
    }

    @NotNull
    public HgGlobalSettings getGlobalSettings() {
        HgGlobalSettings hgGlobalSettings = this.globalSettings;
        if (hgGlobalSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgVcs", "getGlobalSettings"));
        }
        return hgGlobalSettings;
    }

    public void showMessageInConsole(String message, TextAttributes style) {
        if (message.length() > 10000) {
            message = message.substring(0, 10000);
        }
        this.myVcsManager.addMessageToConsoleWindow(message, style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgExecutableValidator getExecutableValidator() {
        Object object = this.myExecutableValidatorLock;
        synchronized (object) {
            if (this.myExecutableValidator == null) {
                this.myExecutableValidator = new HgExecutableValidator(this.myProject, this);
            }
            return this.myExecutableValidator;
        }
    }

    public boolean reportsIgnoredDirectories() {
        return false;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return Collections.singletonList(this.myCommitAndPushExecutor);
    }

    @NotNull
    public HgCloseBranchExecutor getCloseBranchExecutor() {
        HgCloseBranchExecutor hgCloseBranchExecutor = this.myCloseBranchExecutor;
        if (hgCloseBranchExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgVcs", "getCloseBranchExecutor"));
        }
        return hgCloseBranchExecutor;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    public void enableIntegration() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)HgVcs.this.myProject, VcsRootDetector.class)).detect();
                new HgIntegrationEnabler(HgVcs.this).enable(roots);
            }
        });
    }

    public CheckoutProvider getCheckoutProvider() {
        return new HgCheckoutProvider();
    }

    public void checkVersion() {
        block5: {
            String executable = this.getGlobalSettings().getHgExecutable();
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
            String SETTINGS_LINK = "settings";
            String UPDATE_LINK = "update";
            NotificationListener.Adapter linkAdapter = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/zmlx/hg4idea/HgVcs$4", "hyperlinkActivated"));
                    }
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/HgVcs$4", "hyperlinkActivated"));
                    }
                    if ("settings".equals(e.getDescription())) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(HgVcs.this.myProject, HgVcs.this.getConfigurable().getDisplayName());
                    } else if ("update".equals(e.getDescription())) {
                        BrowserUtil.browse((String)"http://mercurial.selenic.com");
                    }
                }
            };
            try {
                this.myVersion = HgVersion.identifyVersion(executable);
                if (!this.myVersion.isSupported()) {
                    LOG.info("Unsupported Hg version: " + this.myVersion);
                    String message = String.format("The <a href='settings'>configured</a> version of Hg is not supported: %s.<br/> The minimal supported version is %s. Please <a href='update'>update</a>.", this.myVersion, HgVersion.MIN);
                    vcsNotifier.notifyError("Unsupported Hg version", message, (NotificationListener)linkAdapter);
                } else if (this.myVersion.hasUnsupportedExtensions()) {
                    String unsupportedExtensionsAsString = this.myVersion.getUnsupportedExtensions().toString();
                    LOG.warn("Unsupported Hg extensions: " + unsupportedExtensionsAsString);
                    String message = String.format("Some hg extensions %s are not found or not supported by your hg version and will be ignored.\nPlease, update your hgrc or Mercurial.ini file", unsupportedExtensionsAsString);
                    vcsNotifier.notifyWarning("Unsupported Hg version", message);
                }
            }
            catch (Exception e) {
                if (!this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block5;
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                String message = HgVcsMessages.message("hg4idea.unable.to.run.hg", executable);
                vcsNotifier.notifyError(message, reason + "<br/> Please check your hg executable path in <a href='" + "settings" + "'> settings </a>", (NotificationListener)linkAdapter);
            }
        }
    }

    @NotNull
    public HgVersion getVersion() {
        HgVersion hgVersion = this.myVersion;
        if (hgVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgVcs", "getVersion"));
        }
        return hgVersion;
    }
}

