/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memory.actions;

import com.android.tools.idea.memory.MemorySampler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import org.jetbrains.annotations.NotNull;

public class RecordingAction
extends ToggleAction {
    @NotNull
    private final MemorySampler myMemorySampler;

    public RecordingAction(@NotNull MemorySampler memorySampler) {
        if (memorySampler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memorySampler", "com/android/tools/idea/memory/actions/RecordingAction", "<init>"));
        }
        super(null, null, AllIcons.Debugger.Db_set_breakpoint);
        this.myMemorySampler = memorySampler;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myMemorySampler.isRunning();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (this.isSelected(e)) {
            presentation.setText("Stop");
            presentation.setDescription("Stops memory information recording.");
        } else {
            presentation.setText("Start");
            presentation.setDescription("Starts memory information recording.");
        }
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            this.myMemorySampler.start();
        } else {
            this.myMemorySampler.stop();
        }
    }
}

