/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.annotations.concurrency.GuardedBy;
import com.intellij.openapi.application.Application;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncValidator<V> {
    @NotNull
    private final Application myApplication;
    private final ResultReporter myResultReporter;
    @GuardedBy(value="this")
    private boolean myIsDirty;
    @GuardedBy(value="this")
    private boolean myIsScheduled;

    public AsyncValidator(@NotNull Application application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/android/tools/idea/wizard/AsyncValidator", "<init>"));
        }
        this.myResultReporter = new ResultReporter();
        this.myIsDirty = false;
        this.myIsScheduled = false;
        this.myApplication = application;
    }

    public final synchronized void invalidate() {
        this.myIsDirty = true;
        this.myResultReporter.setDirty();
        if (!this.myIsScheduled) {
            this.myIsScheduled = true;
            this.myApplication.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    AsyncValidator.this.revalidateUntilClean();
                }
            });
        }
    }

    private void revalidateUntilClean() {
        V result;
        do {
            this.markClean();
        } while (!this.submit(result = this.validate()));
    }

    private synchronized boolean submit(@NotNull V result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/wizard/AsyncValidator", "submit"));
        }
        this.myIsScheduled = this.myIsDirty;
        if (!this.myIsScheduled) {
            this.myResultReporter.report(result);
            return true;
        }
        return false;
    }

    private synchronized void markClean() {
        this.myIsDirty = false;
    }

    protected abstract void showValidationResult(V var1);

    @NotNull
    protected abstract V validate();

    private final class ResultReporter
    implements Runnable {
        @GuardedBy(value="this")
        private V myResult = null;
        @GuardedBy(value="this")
        private boolean myIsPending = false;

        private ResultReporter() {
        }

        public synchronized void report(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/wizard/AsyncValidator$ResultReporter", "report"));
            }
            this.myResult = value;
            if (!this.myIsPending) {
                this.myIsPending = true;
                AsyncValidator.this.myApplication.invokeLater((Runnable)this, AsyncValidator.this.myApplication.getAnyModalityState());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            Object result = this.myResult;
            this.myResult = null;
            try {
                if (result != null) {
                    AsyncValidator.this.showValidationResult(result);
                }
            }
            finally {
                this.myIsPending = false;
            }
        }

        public synchronized void setDirty() {
            this.myResult = null;
        }
    }
}

