/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.spike;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.model.dsl.internal.spike.ReferenceDetectingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExtractor
extends ReferenceDetectingVisitor {
    private static final String AST_NODE_REMOVE_KEY = ReferenceExtractor.class.getName() + ".remove";
    private final Map<String, String> outerScopeReferenceAliases;
    private ImmutableSet.Builder<String> referencedPaths = ImmutableSet.builder();
    private Map<String, String> referenceAliases = Maps.newHashMap();

    public ReferenceExtractor(SourceUnit sourceUnit, Map<String, String> outerScopeReferenceAliases) {
        super(sourceUnit, "Expression not allowed");
        this.outerScopeReferenceAliases = outerScopeReferenceAliases;
    }

    private Expression rewrittenOrOriginal(Expression expression) {
        String referencePath = (String)expression.getNodeMetaData((Object)AST_NODE_REFERENCE_PATH_KEY);
        return referencePath != null ? this.rewriteReferenceStatement(referencePath) : expression;
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        super.visitExpressionStatement(statement);
        Expression expression = statement.getExpression();
        Boolean shouldRemoveExpression = (Boolean)expression.getNodeMetaData((Object)AST_NODE_REMOVE_KEY);
        if (shouldRemoveExpression != null && shouldRemoveExpression.booleanValue()) {
            statement.setExpression((Expression)new EmptyExpression());
        } else {
            statement.setExpression(this.rewrittenOrOriginal(expression));
        }
    }

    public void visitConstantExpression(ConstantExpression expression) {
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        Expression leftExpression = expression.getLeftExpression();
        leftExpression.visit((GroovyCodeVisitor)this);
        expression.setLeftExpression(this.rewrittenOrOriginal(leftExpression));
        Expression rightExpression = expression.getRightExpression();
        rightExpression.visit((GroovyCodeVisitor)this);
        expression.setRightExpression(this.rewrittenOrOriginal(rightExpression));
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        Expression objectExpression = call.getObjectExpression();
        objectExpression.visit((GroovyCodeVisitor)this);
        call.setObjectExpression(this.rewrittenOrOriginal(objectExpression));
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        Expression rightExpression = expression.getRightExpression();
        rightExpression.visit((GroovyCodeVisitor)this);
        String referencePath = (String)rightExpression.getNodeMetaData((Object)AST_NODE_REFERENCE_PATH_KEY);
        if (referencePath != null) {
            expression.setNodeMetaData((Object)AST_NODE_REMOVE_KEY, (Object)true);
            this.referenceAliases.put(expression.getLeftExpression().getText(), referencePath);
        }
    }

    private MethodCallExpression rewriteReferenceStatement(String path) {
        this.referencedPaths.add((Object)path);
        Parameter it = new Parameter(ClassHelper.DYNAMIC_TYPE, "it");
        it.setOriginType(ClassHelper.OBJECT_TYPE);
        VariableExpression subject = new VariableExpression((Variable)it);
        ArgumentListExpression arguments = new ArgumentListExpression((Expression)new ConstantExpression((Object)path));
        return new MethodCallExpression((Expression)subject, "getAt", (Expression)arguments);
    }

    @Override
    protected String getReferenceAliasPath(String aliasName) {
        String path = this.referenceAliases.get(aliasName);
        return path != null ? path : this.outerScopeReferenceAliases.get(aliasName);
    }

    public ImmutableSet<String> getReferencedPaths() {
        return this.referencedPaths.build();
    }
}

