/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryType;

public class RepositoryLibraryEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryEditor(LibraryEditorComponent<RepositoryLibraryProperties> component, RepositoryLibraryType libraryType) {
        super(component, (LibraryType)libraryType, null);
    }

    protected void edit() {
        Project project = this.myEditorComponent.getProject();
        NewLibraryConfiguration configuration = RepositoryAttachHandler.chooseLibraryAndDownload(project, ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).getMavenId(), this.getMainPanel());
        if (configuration == null) {
            return;
        }
        LibraryEditorBase target = (LibraryEditorBase)this.myEditorComponent.getLibraryEditor();
        target.removeAllRoots();
        this.myEditorComponent.renameLibrary(configuration.getDefaultLibraryName());
        target.setType(this.myLibraryType);
        target.setProperties(configuration.getProperties());
        configuration.addRoots((LibraryEditor)target);
        this.myEditorComponent.updateRootsTree();
        this.setModified();
    }

    public void apply() {
    }
}

