/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.RearrangeCodeProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileInEditorProcessor {
    private static final Logger LOG = Logger.getInstance(FileInEditorProcessor.class);
    private final Editor myEditor;
    private boolean myNoChangesDetected = false;
    private final boolean myProcessChangesTextOnly;
    private final boolean myShouldOptimizeImports;
    private final boolean myShouldRearrangeCode;
    private final boolean myProcessSelectedText;
    private final Project myProject;
    private final PsiFile myFile;
    private AbstractLayoutCodeProcessor myProcessor;

    public FileInEditorProcessor(PsiFile file, Editor editor, LayoutCodeOptions runOptions) {
        this.myFile = file;
        this.myProject = file.getProject();
        this.myEditor = editor;
        this.myShouldOptimizeImports = runOptions.isOptimizeImports();
        this.myShouldRearrangeCode = runOptions.isRearrangeCode();
        this.myProcessSelectedText = this.myEditor != null && runOptions.getTextRangeType() == TextRangeType.SELECTED_TEXT;
        this.myProcessChangesTextOnly = runOptions.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT;
    }

    public void processCode() {
        if (this.myShouldOptimizeImports) {
            this.myProcessor = new OptimizeImportsProcessor(this.myProject, this.myFile);
        }
        if (this.myProcessChangesTextOnly && !FormatChangedTextUtil.hasChanges(this.myFile)) {
            this.myNoChangesDetected = true;
        }
        this.myProcessor = this.mixWithReformatProcessor(this.myProcessor);
        if (this.myShouldRearrangeCode) {
            this.myProcessor = this.mixWithRearrangeProcessor(this.myProcessor);
        }
        if (this.shouldNotify()) {
            this.myProcessor.setCollectInfo(true);
            this.myProcessor.setPostRunnable(new Runnable(){

                @Override
                public void run() {
                    String message = FileInEditorProcessor.this.prepareMessage();
                    if (!FileInEditorProcessor.this.myEditor.isDisposed() && FileInEditorProcessor.this.myEditor.getComponent().isShowing()) {
                        FileInEditorProcessor.showHint(FileInEditorProcessor.this.myEditor, message);
                    }
                }
            });
        }
        this.myProcessor.run();
    }

    private AbstractLayoutCodeProcessor mixWithRearrangeProcessor(@NotNull AbstractLayoutCodeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/actions/FileInEditorProcessor", "mixWithRearrangeProcessor"));
        }
        processor = this.myProcessSelectedText ? new RearrangeCodeProcessor(processor, this.myEditor.getSelectionModel()) : new RearrangeCodeProcessor(processor);
        return processor;
    }

    @NotNull
    private AbstractLayoutCodeProcessor mixWithReformatProcessor(@Nullable AbstractLayoutCodeProcessor processor) {
        processor = processor != null ? (this.myProcessSelectedText ? new ReformatCodeProcessor(processor, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(processor, this.myProcessChangesTextOnly)) : (this.myProcessSelectedText ? new ReformatCodeProcessor(this.myFile, this.myEditor.getSelectionModel()) : new ReformatCodeProcessor(this.myFile, this.myProcessChangesTextOnly));
        AbstractLayoutCodeProcessor abstractLayoutCodeProcessor = processor;
        if (abstractLayoutCodeProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileInEditorProcessor", "mixWithReformatProcessor"));
        }
        return abstractLayoutCodeProcessor;
    }

    @NotNull
    private String prepareMessage() {
        StringBuilder builder = new StringBuilder("<html>");
        LayoutCodeInfoCollector notifications = this.myProcessor.getInfoCollector();
        LOG.assertTrue(notifications != null);
        if (notifications.isEmpty() && !this.myNoChangesDetected) {
            if (this.myProcessChangesTextOnly) {
                builder.append("No lines changed: changes since last revision are already properly formatted").append("<br>");
            } else {
                builder.append("No lines changed: code is already properly formatted").append("<br>");
            }
        } else {
            if (notifications.hasReformatOrRearrangeNotification()) {
                String reformatInfo = notifications.getReformatCodeNotification();
                String rearrangeInfo = notifications.getRearrangeCodeNotification();
                builder.append(this.joinWithCommaAndCapitalize(reformatInfo, rearrangeInfo));
                if (this.myProcessChangesTextOnly) {
                    builder.append(" in changes since last revision");
                }
                builder.append("<br>");
            } else if (this.myNoChangesDetected) {
                builder.append("No lines changed: no changes since last revision").append("<br>");
            }
            String optimizeImportsNotification = notifications.getOptimizeImportsNotification();
            if (optimizeImportsNotification != null) {
                builder.append(StringUtil.capitalize((String)optimizeImportsNotification)).append("<br>");
            }
        }
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowReformatFileDialog"));
        String color = ColorUtil.toHex((Color)JBColor.gray);
        builder.append("<span style='color:#").append(color).append("'>").append("Show reformat dialog: ").append(shortcutText).append("</span>").append("</html>");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileInEditorProcessor", "prepareMessage"));
        }
        return string;
    }

    @NotNull
    private String joinWithCommaAndCapitalize(String reformatNotification, String rearrangeNotification) {
        String firstNotificationLine;
        String string = firstNotificationLine = reformatNotification != null ? reformatNotification : rearrangeNotification;
        if (reformatNotification != null && rearrangeNotification != null) {
            firstNotificationLine = firstNotificationLine + ", " + rearrangeNotification;
        }
        String string2 = firstNotificationLine = StringUtil.capitalize((String)firstNotificationLine);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileInEditorProcessor", "joinWithCommaAndCapitalize"));
        }
        return string2;
    }

    private static void showHint(@NotNull Editor editor, @NotNull String info) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/actions/FileInEditorProcessor", "showHint"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/actions/FileInEditorProcessor", "showHint"));
        }
        JComponent component = HintUtil.createInformationLabel(info);
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
    }

    private boolean shouldNotify() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return false;
        }
        return this.myEditor != null && !this.myProcessSelectedText;
    }
}

