/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.tagTreeHighlighting;

import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.breadcrumbs.BreadcrumbsPresentationProvider;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.DefaultCrumbsPresentation;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagTreeBreadcrumbsPresentationProvider
extends BreadcrumbsPresentationProvider {
    private static boolean isMyContext(@NotNull PsiElement deepestElement) {
        if (deepestElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deepestElement", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeBreadcrumbsPresentationProvider", "isMyContext"));
        }
        PsiFile file = deepestElement.getContainingFile();
        return file != null && XmlTagTreeHighlightingUtil.isTagTreeHighlightingActive(file);
    }

    public CrumbPresentation[] getCrumbPresentations(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/tagTreeHighlighting/XmlTagTreeBreadcrumbsPresentationProvider", "getCrumbPresentations"));
        }
        if (elements.length == 0 || !XmlTagTreeBreadcrumbsPresentationProvider.isMyContext(elements[elements.length - 1])) {
            return null;
        }
        if (!XmlTagTreeHighlightingUtil.containsTagsWithSameName(elements)) {
            return null;
        }
        CrumbPresentation[] result = new CrumbPresentation[elements.length];
        Color[] baseColors = XmlTagTreeHighlightingUtil.getBaseColors();
        int index = 0;
        for (int i = result.length - 1; i >= 0; --i) {
            if (!(elements[i] instanceof XmlTag)) continue;
            Color color = baseColors[index % baseColors.length];
            result[i] = new MyCrumbPresentation(color);
            ++index;
        }
        return result;
    }

    private static class MyCrumbPresentation
    extends DefaultCrumbsPresentation {
        private final Color myColor;

        private MyCrumbPresentation(@Nullable Color color) {
            this.myColor = color;
        }

        public Color getBackgroundColor(boolean selected, boolean hovered, boolean light) {
            Color baseColor = super.getBackgroundColor(selected, hovered, light);
            return this.myColor != null ? XmlTagTreeHighlightingUtil.makeTransparent(this.myColor, baseColor, 0.1) : baseColor;
        }
    }
}

