/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInspection.htmlInspections.RenameTagBeginOrEndIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagNameSynchronizer
extends CommandAdapter
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(XmlTagNameSynchronizer.class);
    private static final Set<String> SUPPORTED_LANGUAGES = ContainerUtil.set((Object[])new String[]{HTMLLanguage.INSTANCE.getID(), XMLLanguage.INSTANCE.getID(), XHTMLLanguage.INSTANCE.getID(), "JavaScript", "ECMA Script Level 4"});
    private static final Key<TagNameSynchronizer> SYNCHRONIZER_KEY = Key.create((String)"tag_name_synchronizer");
    private final FileDocumentManager myFileDocumentManager;

    public XmlTagNameSynchronizer(EditorFactory editorFactory, FileDocumentManager manager, CommandProcessor processor) {
        this.myFileDocumentManager = manager;
        editorFactory.addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$1", "editorCreated"));
                }
                XmlTagNameSynchronizer.this.installSynchronizer(event.getEditor());
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$1", "editorReleased"));
                }
                XmlTagNameSynchronizer.this.uninstallSynchronizer(event.getEditor());
            }
        }, (Disposable)ApplicationManager.getApplication());
        processor.addCommandListener((CommandListener)this);
    }

    public void uninstallSynchronizer(Editor editor) {
        Document document = editor.getDocument();
        TagNameSynchronizer synchronizer = this.findSynchronizer(document);
        if (synchronizer != null) {
            synchronizer.clearMarkers();
        }
        document.putUserData(SYNCHRONIZER_KEY, null);
    }

    private void installSynchronizer(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Document document = editor.getDocument();
        VirtualFile file = this.myFileDocumentManager.getFile(document);
        Language language = XmlTagNameSynchronizer.findXmlLikeLanguage(project, file);
        if (language != null) {
            new TagNameSynchronizer(editor, project, language);
        }
    }

    private static Language findXmlLikeLanguage(Project project, VirtualFile file) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = file != null && file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
        if (psiFile != null) {
            for (Language language : psiFile.getViewProvider().getLanguages()) {
                if (!SUPPORTED_LANGUAGES.contains(language.getID())) continue;
                return language;
            }
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("XmlTagNameSynchronizer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/XmlTagNameSynchronizer", "getComponentName"));
        }
        return "XmlTagNameSynchronizer";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nullable
    public TagNameSynchronizer findSynchronizer(Document document) {
        if (!WebEditorOptions.getInstance().isSyncTagEditing() || document == null) {
            return null;
        }
        return (TagNameSynchronizer)((Object)document.getUserData(SYNCHRONIZER_KEY));
    }

    public void beforeCommandFinished(CommandEvent event) {
        TagNameSynchronizer synchronizer = this.findSynchronizer(event.getDocument());
        if (synchronizer != null) {
            synchronizer.beforeCommandFinished();
        }
    }

    private static class TagNameSynchronizer
    extends DocumentAdapter {
        private final PsiDocumentManagerBase myDocumentManager;
        private final Language myLanguage;
        private final Editor myEditor;
        private State myState = State.INITIAL;
        private final List<Couple<RangeMarker>> myMarkers = new SmartList();

        public TagNameSynchronizer(Editor editor, Project project, Language language) {
            this.myEditor = editor;
            this.myLanguage = language;
            Disposable disposable = ((EditorImpl)editor).getDisposable();
            Document document = editor.getDocument();
            document.addDocumentListener((DocumentListener)this, disposable);
            document.putUserData(SYNCHRONIZER_KEY, (Object)this);
            this.myDocumentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project);
        }

        public void beforeDocumentChange(DocumentEvent event) {
            if (!WebEditorOptions.getInstance().isSyncTagEditing()) {
                return;
            }
            Document document = event.getDocument();
            if (this.myState == State.APPLYING || UndoManager.getInstance((Project)this.myEditor.getProject()).isUndoInProgress() || ((DocumentEx)document).isInBulkUpdate()) {
                return;
            }
            int offset = event.getOffset();
            int oldLength = event.getOldLength();
            CharSequence fragment = event.getNewFragment();
            int newLength = event.getNewLength();
            if (document.getUserData(XmlTagInsertHandler.ENFORCING_TAG) == Boolean.TRUE) {
                return;
            }
            for (int i = 0; i < newLength; ++i) {
                if (XmlUtil.isValidTagNameChar(fragment.charAt(i))) continue;
                this.clearMarkers();
                return;
            }
            if (this.myState == State.INITIAL) {
                PsiFile file = this.myDocumentManager.getPsiFile(document);
                if (file == null || this.myDocumentManager.getSynchronizer().isInSynchronization(document)) {
                    return;
                }
                SmartList leaders = new SmartList();
                for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                    RangeMarker leader = this.createTagNameMarker(caret);
                    if (leader == null) {
                        for (RangeMarker marker : leaders) {
                            marker.dispose();
                        }
                        return;
                    }
                    leader.setGreedyToLeft(true);
                    leader.setGreedyToRight(true);
                    leaders.add((Object)leader);
                }
                if (leaders.isEmpty()) {
                    return;
                }
                if (this.myDocumentManager.isUncommited(document)) {
                    this.myDocumentManager.commitDocument(document);
                }
                for (RangeMarker leader : leaders) {
                    RangeMarker support = this.findSupport(leader, file, document);
                    if (support == null) {
                        this.clearMarkers();
                        return;
                    }
                    support.setGreedyToLeft(true);
                    support.setGreedyToRight(true);
                    this.myMarkers.add((Couple<RangeMarker>)Couple.of((Object)leader, (Object)support));
                }
                if (!this.fitsInMarker(offset, oldLength)) {
                    this.clearMarkers();
                    return;
                }
                this.myState = State.TRACKING;
            }
            if (this.myMarkers.isEmpty()) {
                return;
            }
            boolean fitsInMarker = this.fitsInMarker(offset, oldLength);
            if (!fitsInMarker) {
                this.clearMarkers();
                this.beforeDocumentChange(event);
            }
        }

        public boolean fitsInMarker(int offset, int oldLength) {
            boolean fitsInMarker = false;
            for (Couple<RangeMarker> leaderAndSupport : this.myMarkers) {
                RangeMarker leader = (RangeMarker)leaderAndSupport.first;
                if (!leader.isValid()) {
                    fitsInMarker = false;
                    break;
                }
                fitsInMarker |= offset >= leader.getStartOffset() && offset + oldLength <= leader.getEndOffset();
            }
            return fitsInMarker;
        }

        public void clearMarkers() {
            for (Couple<RangeMarker> leaderAndSupport : this.myMarkers) {
                ((RangeMarker)leaderAndSupport.first).dispose();
                ((RangeMarker)leaderAndSupport.second).dispose();
            }
            this.myMarkers.clear();
            this.myState = State.INITIAL;
        }

        private RangeMarker createTagNameMarker(Caret caret) {
            char c;
            int i;
            int offset = caret.getOffset();
            Document document = this.myEditor.getDocument();
            CharSequence sequence = document.getCharsSequence();
            int start = -1;
            int end = -1;
            for (i = offset - 1; i >= Math.max(0, offset - 50); --i) {
                try {
                    c = sequence.charAt(i);
                    if (c == '<' || c == '/' && i > 0 && sequence.charAt(i - 1) == '<') {
                        start = i + 1;
                        break;
                    }
                    if (XmlUtil.isValidTagNameChar(c)) continue;
                    break;
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.error("incorrect offset:" + i + ", initial: " + offset, new Attachment[]{new Attachment("document.txt", ((Object)sequence).toString())});
                    return null;
                }
            }
            if (start < 0) {
                return null;
            }
            for (i = offset; i < Math.min(document.getTextLength(), offset + 50); ++i) {
                c = sequence.charAt(i);
                if (XmlUtil.isValidTagNameChar(c)) continue;
                end = i;
                break;
            }
            if (end < 0 || start >= end) {
                return null;
            }
            return document.createRangeMarker(start, end, true);
        }

        public void beforeCommandFinished() {
            if (this.myMarkers.isEmpty()) {
                return;
            }
            this.myState = State.APPLYING;
            final Document document = this.myEditor.getDocument();
            final Runnable apply = new Runnable(){

                @Override
                public void run() {
                    for (Couple couple : TagNameSynchronizer.this.myMarkers) {
                        RangeMarker leader = (RangeMarker)couple.first;
                        RangeMarker support = (RangeMarker)couple.second;
                        String name = document.getText(new TextRange(leader.getStartOffset(), leader.getEndOffset()));
                        document.replaceString(support.getStartOffset(), support.getEndOffset(), (CharSequence)name);
                    }
                }
            };
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(TagNameSynchronizer.this.myEditor);
                    if (lookup != null) {
                        lookup.performGuardedChange(apply);
                    } else {
                        apply.run();
                    }
                }
            });
            this.myState = State.TRACKING;
        }

        private RangeMarker findSupport(RangeMarker leader, PsiFile file, Document document) {
            int offset = leader.getStartOffset();
            PsiElement element = InjectedLanguageUtil.findElementAtNoCommit(file, offset);
            PsiElement support = TagNameSynchronizer.findSupportElement(element);
            if (support == null && file.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                element = file.getViewProvider().findElementAt(offset, this.myLanguage);
                support = TagNameSynchronizer.findSupportElement(element);
            }
            if (support == null) {
                return null;
            }
            int diff = offset - element.getTextRange().getStartOffset();
            TextRange range = support.getTextRange();
            return range != null ? document.createRangeMarker(range.getStartOffset() + diff, range.getEndOffset() + diff, true) : null;
        }

        private static PsiElement findSupportElement(PsiElement element) {
            if (element == null) {
                return null;
            }
            PsiElement support = RenameTagBeginOrEndIntentionAction.findOtherSide(element, false);
            support = support == null || element == support ? RenameTagBeginOrEndIntentionAction.findOtherSide(element, true) : support;
            return support != null && StringUtil.equals((CharSequence)element.getText(), (CharSequence)support.getText()) ? support : null;
        }

        private static enum State {
            INITIAL,
            TRACKING,
            APPLYING;

        }
    }
}

