/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class IntentionActionWithTextCaching
implements Comparable<IntentionActionWithTextCaching>,
PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching");
    private final List<IntentionAction> myOptionIntentions = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionErrorFixes = new ArrayList<IntentionAction>();
    private final List<IntentionAction> myOptionInspectionFixes = new ArrayList<IntentionAction>();
    private final String myText;
    private final IntentionAction myAction;
    private final String myDisplayName;
    private final Icon myIcon;

    IntentionActionWithTextCaching(IntentionAction action) {
        this(action, action.getText(), null);
    }

    IntentionActionWithTextCaching(HighlightInfo.IntentionActionDescriptor action) {
        this(action.getAction(), action.getDisplayName(), action.getIcon());
    }

    private IntentionActionWithTextCaching(IntentionAction action, String displayName, Icon icon) {
        this.myIcon = icon;
        this.myText = action.getText();
        LOG.assertTrue(this.myText != null, (Object)("action " + action.getClass() + " text returned null"));
        this.myAction = action;
        this.myDisplayName = displayName;
    }

    String getText() {
        return this.myText;
    }

    public void addIntention(IntentionAction action) {
        this.myOptionIntentions.add(action);
    }

    public void addErrorFix(IntentionAction action) {
        this.myOptionErrorFixes.add(action);
    }

    public void addInspectionFix(IntentionAction action) {
        this.myOptionInspectionFixes.add(action);
    }

    public IntentionAction getAction() {
        return this.myAction;
    }

    public List<IntentionAction> getOptionIntentions() {
        return this.myOptionIntentions;
    }

    public List<IntentionAction> getOptionErrorFixes() {
        return this.myOptionErrorFixes;
    }

    public List<IntentionAction> getOptionInspectionFixes() {
        return this.myOptionInspectionFixes;
    }

    public String getToolName() {
        return this.myDisplayName;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public int compareTo(@NotNull IntentionActionWithTextCaching other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching", "compareTo"));
        }
        if (this.myAction instanceof Comparable) {
            return ((Comparable)this.myAction).compareTo(other.getAction());
        }
        if (other.getAction() instanceof Comparable) {
            return ((Comparable)other.getAction()).compareTo(this.myAction);
        }
        return Comparing.compare((Comparable)((Object)this.getText()), (Comparable)((Object)other.getText()));
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isDumbAware() {
        return DumbService.isDumbAware((Object)this.myAction);
    }
}

