/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationPlaceAwareProvider;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTypeDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoTypeDeclarationAction gotoTypeDeclarationAction = this;
        if (gotoTypeDeclarationAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "getHandler"));
        }
        return gotoTypeDeclarationAction;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(AnActionEvent event) {
        if (((TypeDeclarationProvider[])Extensions.getExtensions(TypeDeclarationProvider.EP_NAME)).length == 0) {
            event.getPresentation().setVisible(false);
        } else {
            super.update(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
        try {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] symbolTypes = GotoTypeDeclarationAction.findSymbolTypes(editor, offset);
            if (symbolTypes == null || symbolTypes.length == 0) {
                return;
            }
            if (symbolTypes.length == 1) {
                GotoTypeDeclarationAction.navigate(project, symbolTypes[0]);
            } else {
                NavigationUtil.getPsiElementPopup(symbolTypes, CodeInsightBundle.message((String)"choose.type.popup.title", (Object[])new Object[0])).showInBestPositionFor(editor);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
        finally {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
        }
    }

    private static void navigate(@NotNull Project project, @NotNull PsiElement symbolType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "navigate"));
        }
        if (symbolType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolType", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "navigate"));
        }
        PsiElement element = symbolType.getNavigationElement();
        assert (element != null) : "SymbolType :" + symbolType + "; file: " + symbolType.getContainingFile();
        VirtualFile file = element.getContainingFile().getVirtualFile();
        if (file != null) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, element.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findSymbolType(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "findSymbolType"));
        }
        PsiElement[] psiElements = GotoTypeDeclarationAction.findSymbolTypes(editor, offset);
        if (psiElements != null && psiElements.length > 0) {
            return psiElements[0];
        }
        return null;
    }

    @Nullable
    public static PsiElement[] findSymbolTypes(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "findSymbolTypes"));
        }
        PsiElement targetElement = TargetElementUtilBase.getInstance().findTargetElement(editor, 11, offset);
        if (targetElement != null) {
            PsiElement[] symbolType = GotoTypeDeclarationAction.getSymbolTypeDeclarations(targetElement, editor, offset);
            return symbolType == null ? PsiElement.EMPTY_ARRAY : symbolType;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor, offset);
        if (psiReference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)psiReference).multiResolve(false);
            THashSet types = new THashSet();
            for (ResolveResult r : results) {
                PsiElement[] declarations;
                PsiElement element = r.getElement();
                if (element == null || (declarations = GotoTypeDeclarationAction.getSymbolTypeDeclarations(element, editor, offset)) == null) continue;
                for (PsiElement declaration : declarations) {
                    assert (declaration != null);
                    types.add(declaration);
                }
            }
            if (!types.isEmpty()) {
                return PsiUtilCore.toPsiElementArray((Collection)types);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement targetElement, Editor editor, int offset) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/codeInsight/navigation/actions/GotoTypeDeclarationAction", "getSymbolTypeDeclarations"));
        }
        for (TypeDeclarationProvider provider : (TypeDeclarationProvider[])Extensions.getExtensions(TypeDeclarationProvider.EP_NAME)) {
            PsiElement[] result = provider instanceof TypeDeclarationPlaceAwareProvider ? ((TypeDeclarationPlaceAwareProvider)provider).getSymbolTypeDeclarations(targetElement, editor, offset) : provider.getSymbolTypeDeclarations(targetElement);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

