/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.BitUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefEntityImpl
implements RefEntity {
    private static final String NO_NAME = InspectionsBundle.message((String)"inspection.reference.noname", (Object[])new Object[0]);
    private RefEntityImpl myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    private Map<Key, Object> myUserMap;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    protected RefEntityImpl(String name, @NotNull RefManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefEntityImpl", "<init>"));
        }
        this.myManager = (RefManagerImpl)manager;
        this.myName = name != null ? name : NO_NAME;
        this.myOwner = null;
        this.myChildren = null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getQualifiedName"));
        }
        return string;
    }

    public List<RefEntity> getChildren() {
        return this.myChildren;
    }

    public RefEntity getOwner() {
        return this.myOwner;
    }

    protected void setOwner(RefEntityImpl owner) {
        this.myOwner = owner;
    }

    public void add(RefEntity child) {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<RefEntity>(1);
        }
        this.myChildren.add(child);
        ((RefEntityImpl)child).setOwner(this);
    }

    protected void removeChild(RefEntity child) {
        if (this.myChildren != null) {
            this.myChildren.remove(child);
            ((RefEntityImpl)child).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "getUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                return null;
            }
            return (T)this.myUserMap.get(key);
        }
    }

    public void accept(final @NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refVisitor", "com/intellij/codeInspection/reference/RefEntityImpl", "accept"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                refVisitor.visitElement((RefEntity)RefEntityImpl.this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/reference/RefEntityImpl", "putUserData"));
        }
        RefEntityImpl refEntityImpl = this;
        synchronized (refEntityImpl) {
            if (this.myUserMap == null) {
                if (value == null) {
                    return;
                }
                this.myUserMap = new THashMap();
            }
            if (value != null) {
                this.myUserMap.put(key, value);
            } else {
                this.myUserMap.remove(key);
                if (this.myUserMap.isEmpty()) {
                    this.myUserMap = null;
                }
            }
        }
    }

    public boolean checkFlag(long mask) {
        return BitUtil.isSet((long)this.myFlags, (long)mask);
    }

    public void setFlag(boolean value, long mask) {
        this.myFlags = BitUtil.set((long)this.myFlags, (long)mask, (boolean)value);
    }

    public String getExternalName() {
        return this.myName;
    }

    @NotNull
    public RefManagerImpl getRefManager() {
        RefManagerImpl refManagerImpl = this.myManager;
        if (refManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefEntityImpl", "getRefManager"));
        }
        return refManagerImpl;
    }
}

