/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.LineFragmentCache;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    @NotNull
    public static final String DIFF_CONFIG = "$APP_CONFIG$/diff.xml";

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content, @NotNull CharSequence text) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content);
        if (highlighter == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@Nullable Project project, @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "initEmptyEditorHighlighter"));
        }
        return editorHighlighter;
    }

    @Nullable
    public static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createEditorHighlighter"));
        }
        FileType type = content.getContentType();
        VirtualFile file = content.getHighlightFile();
        if (file != null && file.getFileType() == type || file instanceof LightVirtualFile) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file);
        }
        if (type != null) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(project, type);
        }
        return null;
    }

    @NotNull
    public static EditorHighlighter createEmptyEditorHighlighter() {
        EmptyEditorHighlighter emptyEditorHighlighter = new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
        if (emptyEditorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEmptyEditorHighlighter"));
        }
        return emptyEditorHighlighter;
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "setEditorHighlighter"));
        }
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project, content);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "setEditorCodeStyle"));
        }
        if (project != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorEx editorEx = DiffUtil.createEditor(document, project, isViewer, false);
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project) : factory.createEditor(document, project));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.setSoftWrapAppliancePlace(SoftWrapAppliancePlaces.VCS_DIFF);
        editor.getSettings().setLineNumbersShown(true);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            editor.getSettings().setFoldingOutlineShown(true);
            editor.getSettings().setAutoCodeFoldingEnabled(false);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createEditor"));
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "configureEditor"));
        }
        DiffUtil.setEditorHighlighter(project, editor, content);
        DiffUtil.setEditorCodeStyle(project, editor, content.getContentType());
        editor.reinitSettings();
    }

    public static void scrollEditor(@Nullable Editor editor, int line) {
        DiffUtil.scrollEditor(editor, line, 0);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column) {
        DiffUtil.scrollEditor(editor, new LogicalPosition(line, column));
    }

    public static void scrollEditor(@Nullable Editor editor, @NotNull LogicalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/util/DiffUtil", "scrollEditor"));
        }
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(position);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
        scrollingModel.enableAnimation();
    }

    public static void scrollToLineAnimated(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.CENTER);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/diff/util/DiffUtil", "scrollToPoint"));
        }
        if (editor == null) {
            return;
        }
        editor.getScrollingModel().disableAnimation();
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        editor.getScrollingModel().enableAnimation();
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            Point point = new Point(0, 0);
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
            }
            return point;
        }
        ScrollingModel model = editor.getScrollingModel();
        Point point = new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPosition"));
        }
        return point;
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        LogicalPosition logicalPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCaretPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public static Point[] getScrollingPositions(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "getScrollingPositions"));
        }
        Point[] carets = new Point[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getScrollingPosition(editors.get(i));
        }
        if (carets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getScrollingPositions"));
        }
        return carets;
    }

    @NotNull
    public static LogicalPosition[] getCaretPositions(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "getCaretPositions"));
        }
        LogicalPosition[] carets = new LogicalPosition[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getCaretPosition(editors.get(i));
        }
        if (carets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getCaretPositions"));
        }
        return carets;
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        Pair<JPanel, JLabel> pair = DiffUtil.createMessagePanel();
        ((JLabel)pair.getSecond()).setText(message);
        JPanel jPanel = (JPanel)pair.getFirst();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return jPanel;
    }

    @NotNull
    public static Pair<JPanel, JLabel> createMessagePanel() {
        JLabel label = new JLabel();
        label.setForeground(UIUtil.getInactiveTextColor());
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        Pair pair = Pair.create((Object)wrapper, (Object)label);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createMessagePanel"));
        }
        return pair;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions.length == 0) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        for (AnAction action : actions) {
            if (action == null) continue;
            group.add(action);
        }
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/diff/util/DiffUtil", "addActionBlock"));
        }
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (group.getChildrenCount() != 0) {
            group.addSeparator();
        }
        group.addAll(actions);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        List titles = request.getContentTitles();
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (String title : titles) {
            components.add(DiffUtil.createTitle(title));
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSimpleTitles"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        List contents = request.getContents();
        List titles = request.getContentTitles();
        List charsets = ContainerUtil.map((Collection)contents, (Function)new Function<DiffContent, Charset>(){

            public Charset fun(DiffContent content) {
                if (content instanceof EmptyContent) {
                    return null;
                }
                return ((DocumentContent)content).getCharset();
            }
        });
        List separators = ContainerUtil.map((Collection)contents, (Function)new Function<DiffContent, LineSeparator>(){

            public LineSeparator fun(DiffContent content) {
                if (content instanceof EmptyContent) {
                    return null;
                }
                return ((DocumentContent)content).getLineSeparator();
            }
        });
        boolean equalCharsets = DiffUtil.isEqualElements(charsets);
        boolean equalSeparators = DiffUtil.isEqualElements(separators);
        ArrayList<JComponent> result = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && ContainerUtil.find((Iterable)titles, (Condition)Condition.NOT_NULL) == null) {
            List<Object> list = Collections.nCopies(titles.size(), null);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
            }
            return list;
        }
        for (int i = 0; i < contents.size(); ++i) {
            result.add(DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i))), (DiffContent)contents.get(i), equalCharsets, equalSeparators, editors.get(i)));
        }
        ArrayList<JComponent> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTextTitles"));
        }
        return arrayList;
    }

    private static boolean isEqualElements(@NotNull List elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/diff/util/DiffUtil", "isEqualElements"));
        }
        for (int i = 0; i < elements.size(); ++i) {
            for (int j = i + 1; j < elements.size(); ++j) {
                if (DiffUtil.isEqualElements(elements.get(i), elements.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isEqualElements(@Nullable Object element1, @Nullable Object element2) {
        if (element1 == null || element2 == null) {
            return true;
        }
        return element1.equals(element2);
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (content instanceof EmptyContent) {
            return null;
        }
        Charset charset = equalCharsets ? null : ((DocumentContent)content).getCharset();
        LineSeparator separator = equalSeparators ? null : ((DocumentContent)content).getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, charset, separator, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        JComponent jComponent = DiffUtil.createTitle(title, null, null, true);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jComponent;
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable Charset charset, @Nullable LineSeparator separator, boolean readOnly) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        if (readOnly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        panel.add((Component)DiffUtil.createTitlePanel(title), "Center");
        if (charset != null && separator != null) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 0));
            panel2.add(DiffUtil.createCharsetPanel(charset));
            panel2.add(Box.createRigidArea(new Dimension(4, 0)));
            panel2.add(DiffUtil.createSeparatorPanel(separator));
            panel.add((Component)panel2, "East");
        } else if (charset != null) {
            panel.add((Component)DiffUtil.createCharsetPanel(charset), "East");
        } else if (separator != null) {
            panel.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitle"));
        }
        return jPanel;
    }

    @NotNull
    private static JComponent createTitlePanel(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/util/DiffUtil", "createTitlePanel"));
        }
        if (title.isEmpty()) {
            title = " ";
        }
        JLabel jLabel = new JLabel(title);
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createTitlePanel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        JLabel label = new JLabel(charset.displayName());
        if (charset.equals(Charset.forName("UTF-8"))) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createCharsetPanel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        JLabel label = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "createSeparatorPanel"));
        }
        return jLabel;
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        return IdeFocusManager.getInstance((Project)project).getFocusedDescendantFor(component) != null;
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component, true);
    }

    @NotNull
    public static List<LineFragment> compareWithCache(@NotNull DiffRequest request, @NotNull DocumentData data, @NotNull DiffConfig config, @NotNull ProgressIndicator indicator) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        List<LineFragment> list = DiffUtil.compareWithCache(request, data.getText1(), data.getText2(), data.getStamp1(), data.getStamp2(), config, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<LineFragment> compareWithCache(@NotNull DiffRequest request, @NotNull CharSequence text1, @NotNull CharSequence text2, long stamp1, long stamp2, @NotNull DiffConfig diffConfig, @NotNull ProgressIndicator progressIndicator) {
        void indicator;
        void config;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (diffConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamp2", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        List<LineFragment> fragments = DiffUtil.doCompareWithCache(request, text1, text2, stamp1, stamp2, (DiffConfig)config, (ProgressIndicator)indicator);
        indicator.checkCanceled();
        List list = ComparisonManager.getInstance().processBlocks(fragments, text1, text2, config.policy, config.squashFragments, config.trimFragments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "compareWithCache"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static List<LineFragment> doCompareWithCache(@NotNull DiffRequest request, @NotNull CharSequence text1, @NotNull CharSequence text2, long stamp1, long stamp2, @NotNull DiffConfig diffConfig, @NotNull ProgressIndicator progressIndicator) {
        List newFragments;
        void config;
        void indicator;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        if (diffConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamp2", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        indicator.checkCanceled();
        LineFragmentCache.PolicyData cachedData = DiffUtil.getFromCache(request, (DiffConfig)config, stamp1, stamp2);
        if (cachedData != null) {
            if (cachedData.getFragments().isEmpty()) {
                List<LineFragment> list = cachedData.getFragments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
                }
                return list;
            }
            if (!config.innerFragments) {
                List<LineFragment> list = cachedData.getFragments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
                }
                return list;
            }
            if (cachedData.isInnerFragments()) {
                List<LineFragment> list = cachedData.getFragments();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
                }
                return list;
            }
            newFragments = ComparisonManager.getInstance().compareLinesInner(text1, text2, cachedData.getFragments(), config.policy, (ProgressIndicator)indicator);
        } else {
            newFragments = config.innerFragments ? ComparisonManager.getInstance().compareLinesInner(text1, text2, config.policy, (ProgressIndicator)indicator) : ComparisonManager.getInstance().compareLines(text1, text2, config.policy, (ProgressIndicator)indicator);
        }
        indicator.checkCanceled();
        DiffUtil.putToCache(request, (DiffConfig)config, stamp1, stamp2, newFragments, config.innerFragments);
        List list = newFragments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "doCompareWithCache"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static LineFragmentCache.PolicyData getFromCache(@NotNull DiffRequest request, @NotNull DiffConfig config, long stamp1, long l) {
        void stamp2;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "getFromCache"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/diff/util/DiffUtil", "getFromCache"));
        }
        LineFragmentCache cache = (LineFragmentCache)request.getUserData(DiffUserDataKeysEx.LINE_FRAGMENT_CACHE);
        if (cache != null && cache.checkStamps(stamp1, (long)stamp2)) {
            return cache.getData(config.policy);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void putToCache(@NotNull DiffRequest request, @NotNull DiffConfig config, long stamp1, long stamp2, @NotNull List<LineFragment> list, boolean bl) {
        void isInnerFragments;
        void fragments;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/util/DiffUtil", "putToCache"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/diff/util/DiffUtil", "putToCache"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stamp2", "com/intellij/diff/util/DiffUtil", "putToCache"));
        }
        LineFragmentCache oldCache = (LineFragmentCache)request.getUserData(DiffUserDataKeysEx.LINE_FRAGMENT_CACHE);
        LineFragmentCache cache = oldCache == null || !oldCache.checkStamps(stamp1, stamp2) ? new LineFragmentCache(stamp1, stamp2) : new LineFragmentCache(oldCache);
        cache.putData(config.policy, (List<LineFragment>)fragments, (boolean)isInnerFragments);
        request.putUserData(DiffUserDataKeysEx.LINE_FRAGMENT_CACHE, (Object)cache);
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret.getSelectionEnd() != document.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret.getLogicalPosition().line);
            if (caret.getOffset() != document.getTextLength()) continue;
            lines.set(totalLines);
        }
        BitSet bitSet = lines;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getSelectedLines"));
        }
        return bitSet;
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/diff/util/DiffUtil", "isSelectedByLine"));
        }
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    public static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "deleteLines"));
        }
        TextRange range = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    public static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text + "\n"));
        }
    }

    public static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text);
    }

    public static void insertLines(@NotNull Document document1, int line, @NotNull Document document2, int otherLine1, int otherLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "insertLines"));
        }
        DiffUtil.insertLines(document1, line, DiffUtil.getLinesContent(document2, otherLine1, otherLine2));
    }

    public static void replaceLines(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "replaceLines"));
        }
        DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/util/DiffUtil", "applyModification"));
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, document2, oLine1, oLine2);
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, document2, oLine1, oLine2);
        }
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        TextRange otherRange = DiffUtil.getLinesRange(document, line1, line2);
        CharSequence charSequence = document.getCharsSequence().subSequence(otherRange.getStartOffset(), otherRange.getEndOffset());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesContent"));
        }
        return charSequence;
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < DiffUtil.getLineCount(document) ? document.getLineStartOffset(line1) : document.getTextLength();
            TextRange textRange = new TextRange(lineStartOffset, lineStartOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
            }
            return textRange;
        }
        int startOffset = document.getLineStartOffset(line1);
        int endOffset = document.getLineEndOffset(line2 - 1);
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLinesRange"));
        }
        return textRange;
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1() || fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2() || fragment.getStartLine2() != fragment.getEndLine2();
        TextDiffType textDiffType = DiffUtil.getType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getLineDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        TextDiffType textDiffType = DiffUtil.getType(left, right);
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDiffType"));
        }
        return textDiffType;
    }

    private static TextDiffType getType(boolean left, boolean right) {
        if (left && right) {
            return TextDiffType.MODIFIED;
        }
        if (left) {
            return TextDiffType.DELETED;
        }
        if (right) {
            return TextDiffType.INSERTED;
        }
        throw new IllegalArgumentException();
    }

    public static void executeWriteCommand(@NotNull Document document, final @Nullable Project project, final @Nullable String name, final @NotNull Runnable task) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/diff/util/DiffUtil", "executeWriteCommand"));
        }
        if (!DiffUtil.makeWritable(project, document)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(project, task, name, null);
            }
        });
    }

    public static boolean isEditable(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffUtil", "isEditable"));
        }
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "canMakeWritable"));
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return file != null && file.isInLocalFileSystem();
    }

    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/util/DiffUtil", "makeWritable"));
        }
        if (document.isWritable()) {
            return true;
        }
        if (project == null) {
            return false;
        }
        return ReadonlyStatusHandler.ensureDocumentWritable((Project)project, (Document)document);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        Dimension dimension = new Dimension(400, 200);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffPanelSize"));
        }
        return dimension;
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        Dimension dimension = new Dimension(width, height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getDefaultDiffWindowSize"));
        }
        return dimension;
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        WindowWrapper.Mode mode = hints.getMode();
        if (mode == null) {
            boolean isUnderDialog = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() instanceof JDialog;
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "getWindowMode"));
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null) {
            if (component instanceof Window) {
                DiffUtil.closeWindow(component, modalOnly);
            }
            component = recursive ? component.getParent() : null;
        }
    }

    public static void closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/diff/util/DiffUtil", "closeWindow"));
        }
        if (window instanceof IdeFrameImpl) {
            return;
        }
        if (modalOnly && window instanceof Frame) {
            return;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return;
        }
        window.setVisible(false);
        window.dispose();
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "isUserDataFlagSet"));
        }
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable DiffRequest request, @Nullable DiffContext context, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "getUserData"));
        }
        if (request != null && (data = request.getUserData(key)) != null) {
            return (T)data;
        }
        if (context != null && (data = context.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    public static <T> T getUserData(@Nullable DiffContext context, @Nullable DiffRequest request, @NotNull Key<T> key) {
        Object data;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/diff/util/DiffUtil", "getUserData"));
        }
        if (context != null && (data = context.getUserData(key)) != null) {
            return (T)data;
        }
        if (request != null && (data = request.getUserData(key)) != null) {
            return (T)data;
        }
        return null;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        if (tools.size() < 2) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        final ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool : tools) {
            try {
                if (!(tool instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list = tools;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
            }
            return list;
        }
        List filteredTools = ContainerUtil.filter(tools, (Condition)new Condition<T>(){

            public boolean value(T tool) {
                return !suppressedTools.contains(tool.getClass());
            }
        });
        List list = filteredTools.isEmpty() ? tools : filteredTools;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil", "filterSuppressedTools"));
        }
        return list;
    }

    public static class DiffConfig {
        @NotNull
        public final ComparisonPolicy policy;
        public final boolean innerFragments;
        public final boolean squashFragments;
        public final boolean trimFragments;

        public DiffConfig(@NotNull ComparisonPolicy policy, boolean innerFragments, boolean squashFragments, boolean trimFragments) {
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this.policy = policy;
            this.innerFragments = innerFragments;
            this.squashFragments = squashFragments;
            this.trimFragments = trimFragments;
        }

        public DiffConfig(@NotNull IgnorePolicy ignorePolicy, @NotNull HighlightPolicy highlightPolicy) {
            if (ignorePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignorePolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            if (highlightPolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightPolicy", "com/intellij/diff/util/DiffUtil$DiffConfig", "<init>"));
            }
            this(ignorePolicy.getComparisonPolicy(), highlightPolicy.isFineFragments(), highlightPolicy.isShouldSquash(), ignorePolicy.isShouldTrimChunks());
        }

        public DiffConfig() {
            this(IgnorePolicy.DEFAULT, HighlightPolicy.BY_LINE);
        }
    }

    public static class DocumentData {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;
        private final long myStamp1;
        private final long myStamp2;

        /*
         * WARNING - void declaration
         */
        public DocumentData(@NotNull CharSequence text1, @NotNull CharSequence text2, long stamp1, long l) {
            void stamp2;
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/util/DiffUtil$DocumentData", "<init>"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/util/DiffUtil$DocumentData", "<init>"));
            }
            this.myText1 = text1;
            this.myText2 = text2;
            this.myStamp1 = stamp1;
            this.myStamp2 = stamp2;
        }

        @NotNull
        public CharSequence getText1() {
            CharSequence charSequence = this.myText1;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil$DocumentData", "getText1"));
            }
            return charSequence;
        }

        @NotNull
        public CharSequence getText2() {
            CharSequence charSequence = this.myText2;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil$DocumentData", "getText2"));
            }
            return charSequence;
        }

        public long getStamp1() {
            return this.myStamp1;
        }

        public long getStamp2() {
            return this.myStamp2;
        }
    }

    public static class EditorsVisiblePositions {
        public static final Key<EditorsVisiblePositions> KEY = Key.create((String)"Diff.EditorsVisiblePositions");
        @NotNull
        public final LogicalPosition[] myCaretPosition;
        @NotNull
        public final Point[] myPoints;

        public EditorsVisiblePositions(@NotNull LogicalPosition caretPosition, @NotNull Point points) {
            if (caretPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretPosition", "com/intellij/diff/util/DiffUtil$EditorsVisiblePositions", "<init>"));
            }
            if (points == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/diff/util/DiffUtil$EditorsVisiblePositions", "<init>"));
            }
            this.myCaretPosition = new LogicalPosition[]{caretPosition};
            this.myPoints = new Point[]{points};
        }

        public EditorsVisiblePositions(@NotNull LogicalPosition[] caretPosition, @NotNull Point[] points) {
            if (caretPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretPosition", "com/intellij/diff/util/DiffUtil$EditorsVisiblePositions", "<init>"));
            }
            if (points == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "points", "com/intellij/diff/util/DiffUtil$EditorsVisiblePositions", "<init>"));
            }
            this.myCaretPosition = caretPosition;
            this.myPoints = points;
        }

        public boolean isSame(LogicalPosition ... caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (this.myCaretPosition.length != caretPosition.length) {
                return false;
            }
            for (int i = 0; i < caretPosition.length; ++i) {
                if (caretPosition[i].equals((Object)this.myCaretPosition[i])) continue;
                return false;
            }
            return true;
        }
    }
}

