/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.CompositePrintable;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTestProxy
extends CompositePrintable {
    public static final DataKey<AbstractTestProxy> DATA_KEY = DataKey.create((String)"testProxy");
    protected Printer myPrinter = null;

    public abstract boolean isInProgress();

    public abstract boolean isDefect();

    public abstract boolean shouldRun();

    public abstract int getMagnitude();

    public abstract boolean isLeaf();

    public abstract boolean isInterrupted();

    public abstract boolean isIgnored();

    public abstract boolean isPassed();

    public abstract String getName();

    public abstract Location getLocation(Project var1, GlobalSearchScope var2);

    public abstract Navigatable getDescriptor(Location var1, TestConsoleProperties var2);

    public abstract AbstractTestProxy getParent();

    public abstract List<? extends AbstractTestProxy> getChildren();

    public abstract List<? extends AbstractTestProxy> getAllTests();

    @Nullable
    public Long getDuration() {
        return null;
    }

    public abstract boolean shouldSkipRootNodeForExport();

    public void fireOnNewPrintable(@NotNull Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/AbstractTestProxy", "fireOnNewPrintable"));
        }
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public void setPrinter(Printer printer) {
        this.myPrinter = printer;
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            abstractTestProxy.setPrinter(printer);
        }
    }

    @Override
    public void addLast(@NotNull Printable printable) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/AbstractTestProxy", "addLast"));
        }
        super.addLast(printable);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void insert(@NotNull Printable printable, int i) {
        if (printable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printable", "com/intellij/execution/testframework/AbstractTestProxy", "insert"));
        }
        super.insert(printable, i);
        this.fireOnNewPrintable(printable);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (AbstractTestProxy abstractTestProxy : this.getChildren()) {
            Disposer.dispose((Disposable)abstractTestProxy);
        }
    }

    public static void flushOutput(AbstractTestProxy testProxy) {
        testProxy.flush();
        for (AbstractTestProxy parent = testProxy.getParent(); parent != null; parent = parent.getParent()) {
            List<? extends AbstractTestProxy> children = parent.getChildren();
            if (testProxy.isInProgress() || !testProxy.equals(children.get(children.size() - 1))) break;
            parent.flush();
            testProxy = parent;
        }
    }

    @Override
    public int getExceptionMark() {
        if (this.myExceptionMark == 0 && this.getChildren().size() > 0) {
            return this.getChildren().get(0).getExceptionMark();
        }
        return this.myExceptionMark;
    }

    @Nullable
    public DiffHyperlink getDiffViewerProvider() {
        return null;
    }

    public static interface AssertEqualsDiffChain {
        public DiffHyperlink getPrevious();

        public DiffHyperlink getCurrent();

        public DiffHyperlink getNext();

        public void setCurrent(DiffHyperlink var1);
    }
}

