/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeTestLocationProvider
implements TestLocationProvider {
    private final TestLocationProvider myPrimaryLocator;

    public CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
        this.myPrimaryLocator = primaryLocator;
    }

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String locationData, Project project) {
        List<Location> locations;
        if (protocolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolId", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        if (this.myPrimaryLocator != null && !(locations = this.myPrimaryLocator.getLocation(protocolId, locationData, project)).isEmpty()) {
            List<Location> list = locations;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
            }
            return list;
        }
        boolean isDumbMode = DumbService.isDumb((Project)project);
        for (TestLocationProvider provider : (TestLocationProvider[])Extensions.getExtensions(TestLocationProvider.EP_NAME)) {
            List<Location> locations2;
            if (isDumbMode && !DumbService.isDumbAware((Object)provider) || (locations2 = provider.getLocation(protocolId, locationData, project)).isEmpty()) continue;
            List<Location> list = locations2;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/CompositeTestLocationProvider", "getLocation"));
        }
        return list;
    }
}

