/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptFileUtil {
    private static final Logger LOG = Logger.getInstance(ScriptFileUtil.class);
    private static final String SCHEME = "mem://";
    private static final Map<String, VirtualFile> ourFilesMap = ContainerUtil.createConcurrentWeakValueMap();
    private static final AtomicLong ourFileCounter = new AtomicLong();

    private ScriptFileUtil() {
    }

    public static boolean isMemoryScriptPath(@Nullable String url) {
        return url != null && url.startsWith(SCHEME);
    }

    public static String getScriptFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/util/ScriptFileUtil", "getScriptFilePath"));
        }
        if (file.isInLocalFileSystem()) {
            return file.getPath();
        }
        long id = ourFileCounter.incrementAndGet();
        String url = SCHEME + id + "/" + file.getName();
        ourFilesMap.put(url, file);
        return url;
    }

    @Nullable
    public static VirtualFile findScriptFileByPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        if (!path.startsWith(SCHEME)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return ourFilesMap.get(path);
    }

    @NotNull
    public static String getLocalFilePath(@NotNull String scriptPath) throws CantRunException {
        if (scriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptPath", "com/intellij/execution/util/ScriptFileUtil", "getLocalFilePath"));
        }
        if (ScriptFileUtil.isMemoryScriptPath(scriptPath)) {
            File tmpFile = ScriptFileUtil.copyToTempFile(scriptPath);
            String string = tmpFile.getAbsolutePath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "getLocalFilePath"));
            }
            return string;
        }
        if (SystemInfo.isWindows) {
            String string = PathUtil.driveLetterToLowerCase((String)scriptPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "getLocalFilePath"));
            }
            return string;
        }
        String string = scriptPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "getLocalFilePath"));
        }
        return string;
    }

    @NotNull
    public static File copyToTempFile(@NotNull String path) throws CantRunException {
        File file;
        File ioFile;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/util/ScriptFileUtil", "copyToTempFile"));
        }
        VirtualFile virtualFile = ScriptFileUtil.findScriptFileByPath(path);
        if (virtualFile == null) {
            throw new CantRunException("File not found: " + path);
        }
        try {
            ioFile = FileUtil.createTempFile((String)virtualFile.getName(), (String)"", (boolean)true);
        }
        catch (IOException e) {
            throw new CantRunException("Cannot create temporary file " + virtualFile.getName(), (Throwable)e);
        }
        try {
            ScriptFileUtil.copyFile(virtualFile, ioFile);
            file = ioFile;
        }
        catch (IOException e) {
            throw new CantRunException("Cannot write temp file " + virtualFile.getPath() + " to " + ioFile.getAbsolutePath(), (Throwable)e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "copyToTempFile"));
        }
        return file;
    }

    private static void copyFile(@NotNull VirtualFile srcFile, @NotNull File destFile) throws IOException {
        if (srcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcFile", "com/intellij/execution/util/ScriptFileUtil", "copyFile"));
        }
        if (destFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destFile", "com/intellij/execution/util/ScriptFileUtil", "copyFile"));
        }
        LOG.info("Copying to " + destFile.getPath());
        CharSequence content = ScriptFileUtil.getContent(srcFile);
        CharBuffer cb = CharBuffer.wrap(content);
        ByteBuffer bb = CharsetToolkit.UTF8_CHARSET.encode(cb);
        byte[] result = new byte[bb.remaining()];
        bb.get(result);
        FileUtil.writeToFile((File)destFile, (byte[])result, (boolean)false);
    }

    @NotNull
    private static CharSequence getContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/util/ScriptFileUtil", "getContent"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            String string = document.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "getContent"));
            }
            return string;
        }
        CharSequence charSequence = LoadTextUtil.loadText(file);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/ScriptFileUtil", "getContent"));
        }
        return charSequence;
    }
}

