/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoDirNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public class TodoTreeHelper {
    private final Project myProject;

    public static TodoTreeHelper getInstance(Project project) {
        return (TodoTreeHelper)ServiceManager.getService((Project)project, TodoTreeHelper.class);
    }

    public TodoTreeHelper(Project project) {
        this.myProject = project;
    }

    public void addPackagesToChildren(ArrayList<AbstractTreeNode> children, Module module, TodoTreeBuilder builder) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList roots = new ArrayList();
        ArrayList sourceRoots = new ArrayList();
        if (module == null) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
            ContainerUtil.addAll(roots, (Object[])projectRootManager.getContentRoots());
            ContainerUtil.addAll(sourceRoots, (Object[])projectRootManager.getContentSourceRoots());
        } else {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            ContainerUtil.addAll(roots, (Object[])moduleRootManager.getContentRoots());
            ContainerUtil.addAll(sourceRoots, (Object[])moduleRootManager.getSourceRoots());
        }
        roots.removeAll(sourceRoots);
        for (VirtualFile dir : roots) {
            TodoDirNode dirNode;
            Iterator<PsiFile> files;
            PsiDirectory directory = psiManager.findDirectory(dir);
            if (directory == null || !(files = builder.getFiles(directory)).hasNext() || children.contains(dirNode = new TodoDirNode(this.myProject, directory, builder))) continue;
            children.add((AbstractTreeNode)dirNode);
        }
    }

    public Collection<AbstractTreeNode> getDirectoryChildren(PsiDirectory psiDirectory, TodoTreeBuilder builder, boolean isFlatten) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        if (!isFlatten || !this.skipDirectory(psiDirectory)) {
            Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                if (psiDirectory.equals(containingDirectory) && !children.contains(todoFileNode)) {
                    children.add((AbstractTreeNode)todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null && !this.skipDirectory(_dir)) {
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder);
                    if (parentDirectory != null && psiDirectory.equals(parentDirectory) && !children.contains(todoDirNode)) {
                        children.add((AbstractTreeNode)todoDirNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
            if (parentDirectory == null || !this.skipDirectory(parentDirectory) || !ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex().isInContent(parentDirectory.getVirtualFile())) {
                Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                    if (psiDirectory.equals(psiFile.getContainingDirectory()) && !children.contains(todoFileNode)) {
                        children.add((AbstractTreeNode)todoFileNode);
                        continue;
                    }
                    PsiDirectory _dir = psiFile.getContainingDirectory();
                    if (this.skipDirectory(_dir)) continue;
                    TodoDirNode todoDirNode = new TodoDirNode(this.getProject(), _dir, builder);
                    if (!PsiTreeUtil.isAncestor((PsiElement)psiDirectory, (PsiElement)_dir, (boolean)true) || children.contains(todoDirNode) || builder.isDirectoryEmpty(_dir)) continue;
                    children.add((AbstractTreeNode)todoDirNode);
                }
            } else {
                Iterator<PsiFile> iterator = builder.getFiles(psiDirectory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = iterator.next();
                    PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                    TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, builder, false);
                    if (!psiDirectory.equals(containingDirectory) || children.contains(todoFileNode)) continue;
                    children.add((AbstractTreeNode)todoFileNode);
                }
            }
        }
        Collections.sort(children, TodoFileDirAndModuleComparator.INSTANCE);
        return children;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return false;
    }

    @Nullable
    public PsiElement getSelectedElement(Object userObject) {
        if (userObject instanceof TodoDirNode) {
            TodoDirNode descriptor = (TodoDirNode)userObject;
            return (PsiElement)descriptor.getValue();
        }
        if (userObject instanceof TodoFileNode) {
            TodoFileNode descriptor = (TodoFileNode)userObject;
            return (PsiElement)descriptor.getValue();
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }
}

