/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.ui.search.ConfigurableHit;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SingletonSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchableOptionsRegistrarImpl
extends SearchableOptionsRegistrar {
    private final Map<String, Set<OptionDescription>> myStorage = Collections.synchronizedMap(new THashMap(20, 0.9f));
    private final Map<String, String> myId2Name = Collections.synchronizedMap(new THashMap(20, 0.9f));
    private final Set<String> myStopWords = Collections.synchronizedSet(new HashSet());
    private final Map<Couple<String>, Set<String>> myHighlightOption2Synonym = Collections.synchronizedMap(new THashMap());
    private volatile boolean allTheseHugeFilesAreLoaded;
    private final StringInterner myIdentifierTable = new StringInterner(){

        @NotNull
        public synchronized String intern(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1", "intern"));
            }
            String string = (String)super.intern((Object)name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$1", "intern"));
            }
            return string;
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl");
    public static final int LOAD_FACTOR = 20;
    @NonNls
    private static final Pattern REG_EXP = Pattern.compile("[\\W&&[^-]]+");

    public SearchableOptionsRegistrarImpl() {
        if (ApplicationManager.getApplication().isCommandLine() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        try {
            String text = ResourceUtil.loadText((URL)ResourceUtil.getResource(SearchableOptionsRegistrarImpl.class, (String)"/search/", (String)"ignore.txt"));
            Object[] stopWords = text.split("[\\W]");
            ContainerUtil.addAll(this.myStopWords, (Object[])stopWords);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.loadExtensions();
    }

    private void loadExtensions() {
        final SearchableOptionProcessor processor = new SearchableOptionProcessor(){

            public void addOptions(@NotNull String text, @Nullable String path, @Nullable String hit, @NotNull String configurableId, @Nullable String configurableDisplayName, boolean applyStemming) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$2", "addOptions"));
                }
                if (configurableId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableId", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl$2", "addOptions"));
                }
                Set<String> words = applyStemming ? SearchableOptionsRegistrarImpl.this.getProcessedWords(text) : SearchableOptionsRegistrarImpl.this.getProcessedWordsWithoutStemming(text);
                for (String word : words) {
                    SearchableOptionsRegistrarImpl.this.addOption(word, path, hit, configurableId, configurableDisplayName);
                }
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                for (SearchableOptionContributor contributor : (SearchableOptionContributor[])SearchableOptionContributor.EP_NAME.getExtensions()) {
                    contributor.processOptions(processor);
                }
            }
        });
    }

    private void loadHugeFilesIfNecessary() {
        if (this.allTheseHugeFilesAreLoaded) {
            return;
        }
        this.allTheseHugeFilesAreLoaded = true;
        try {
            String groupName;
            String id;
            Element configurable;
            URL indexResource = ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"searchableOptions.xml");
            if (indexResource == null) {
                LOG.info("No /search/searchableOptions.xml found, settings search won't work!");
                return;
            }
            Document document = JDOMUtil.loadDocument((URL)indexResource);
            Element root = document.getRootElement();
            List configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    String path = optionElement.getAttributeValue("path");
                    String hit = optionElement.getAttributeValue("hit");
                    this.putOptionWithHelpId(option, id, groupName, hit, path);
                }
            }
            document = JDOMUtil.loadDocument((URL)ResourceUtil.getResource(SearchableOptionsRegistrar.class, (String)"/search/", (String)"synonyms.xml"));
            root = document.getRootElement();
            configurables = root.getChildren("configurable");
            for (Object o : configurables) {
                configurable = (Element)o;
                id = configurable.getAttributeValue("id");
                groupName = configurable.getAttributeValue("configurable_name");
                List synonyms = configurable.getChildren("synonym");
                for (Object o1 : synonyms) {
                    Element synonymElement = (Element)o1;
                    String synonym = synonymElement.getTextNormalize();
                    if (synonym == null) continue;
                    Set<String> words = this.getProcessedWords(synonym);
                    for (String word : words) {
                        this.putOptionWithHelpId(word, id, groupName, synonym, null);
                    }
                }
                List options = configurable.getChildren("option");
                for (Object o1 : options) {
                    Element optionElement = (Element)o1;
                    String option = optionElement.getAttributeValue("name");
                    List list = optionElement.getChildren("synonym");
                    for (Object o2 : list) {
                        Element synonymElement = (Element)o2;
                        String synonym = synonymElement.getTextNormalize();
                        if (synonym == null) continue;
                        Set<String> words = this.getProcessedWords(synonym);
                        for (String word : words) {
                            this.putOptionWithHelpId(word, id, groupName, synonym, null);
                        }
                        Couple key = Couple.of((Object)option, (Object)id);
                        THashSet foundSynonyms = this.myHighlightOption2Synonym.get(key);
                        if (foundSynonyms == null) {
                            foundSynonyms = new THashSet();
                            this.myHighlightOption2Synonym.put((Couple<String>)key, (Set<String>)foundSynonyms);
                        }
                        foundSynonyms.add((String)synonym);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        for (IdeaPluginDescriptor plugin : PluginManager.getPlugins()) {
            Set<String> words = this.getProcessedWordsWithoutStemming(plugin.getName());
            String description = plugin.getDescription();
            if (description != null) {
                words.addAll(this.getProcessedWordsWithoutStemming(description));
            }
            for (String word : words) {
                this.addOption(word, null, plugin.getName(), "preferences.pluginManager", PluginManagerConfigurable.DISPLAY_NAME);
            }
        }
    }

    private synchronized void putOptionWithHelpId(@NotNull String option, @NotNull String id, @Nullable String groupName, @Nullable String hit, @Nullable String path) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "putOptionWithHelpId"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "putOptionWithHelpId"));
        }
        if (this.isStopWord(option)) {
            return;
        }
        String stopWord = PorterStemmerUtil.stem(option);
        if (stopWord == null) {
            return;
        }
        if (this.isStopWord(stopWord)) {
            return;
        }
        if (!this.myId2Name.containsKey(id) && groupName != null) {
            this.myId2Name.put((String)this.myIdentifierTable.intern((Object)id), (String)this.myIdentifierTable.intern((Object)groupName));
        }
        OptionDescription description = new OptionDescription(null, ((String)this.myIdentifierTable.intern((Object)id)).trim(), hit != null ? ((String)this.myIdentifierTable.intern((Object)hit)).trim() : null, path != null ? ((String)this.myIdentifierTable.intern((Object)path)).trim() : null);
        SingletonSet configs = this.myStorage.get(option);
        if (configs == null) {
            configs = new SingletonSet((Object)description);
            this.myStorage.put(new String(option), (Set<OptionDescription>)configs);
        } else if (configs instanceof SingletonSet) {
            configs = new THashSet((Collection)configs);
            configs.add(description);
            this.myStorage.put(new String(option), (Set<OptionDescription>)configs);
        } else {
            configs.add(description);
        }
    }

    @NotNull
    public ConfigurableHit getConfigurables(ConfigurableGroup[] groups, DocumentEvent.EventType type, Set<Configurable> configurables, String option, Project project) {
        ConfigurableHit hits = new ConfigurableHit();
        Set contentHits = hits.getContentHits();
        Set<String> options = this.getProcessedWordsWithoutStemming(option);
        if (configurables == null) {
            for (ConfigurableGroup group : groups) {
                contentHits.addAll(SearchUtil.expandGroup(group));
            }
        } else {
            contentHits.addAll(configurables);
        }
        String optionToCheck = option.trim().toLowerCase();
        for (Configurable each : contentHits) {
            if (each.getDisplayName() == null) continue;
            String displayName = each.getDisplayName().toLowerCase();
            List allWords = StringUtil.getWordsIn((String)displayName);
            if (displayName.contains(optionToCheck)) {
                hits.getNameFullHits().add(each);
                hits.getNameHits().add(each);
            }
            for (String eachWord : allWords) {
                if (!eachWord.startsWith(optionToCheck)) continue;
                hits.getNameHits().add(each);
                break;
            }
            if (!options.isEmpty()) continue;
            hits.getNameHits().add(each);
            hits.getNameFullHits().add(each);
        }
        HashSet currentConfigurables = new HashSet(contentHits);
        if (options.isEmpty()) {
            String[] components = REG_EXP.split(optionToCheck);
            if (components.length > 0) {
                Collections.addAll(options, components);
            } else {
                options.add(option);
            }
        }
        HashSet<String> helpIds = null;
        for (String opt : options) {
            Set<OptionDescription> optionIds = this.getAcceptableDescriptions(opt);
            if (optionIds == null) {
                contentHits.clear();
                ConfigurableHit configurableHit = hits;
                if (configurableHit == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
                }
                return configurableHit;
            }
            HashSet<String> ids = new HashSet<String>();
            for (OptionDescription id : optionIds) {
                ids.add(id.getConfigurableId());
            }
            if (helpIds == null) {
                helpIds = ids;
            }
            helpIds.retainAll(ids);
        }
        if (helpIds != null) {
            Iterator it = contentHits.iterator();
            while (it.hasNext()) {
                Configurable configurable = (Configurable)it.next();
                if (CodeStyleFacade.getInstance((Project)project).isUnsuitableCodeStyleConfigurable(configurable)) {
                    it.remove();
                    continue;
                }
                if (configurable instanceof SearchableConfigurable && helpIds.contains(((SearchableConfigurable)configurable).getId())) continue;
                it.remove();
            }
        }
        if (((Object)currentConfigurables).equals(contentHits) && (configurables != null || type != DocumentEvent.EventType.CHANGE)) {
            ConfigurableHit configurableHit = this.getConfigurables(groups, DocumentEvent.EventType.CHANGE, null, option, project);
            if (configurableHit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
            }
            return configurableHit;
        }
        ConfigurableHit configurableHit = hits;
        if (configurableHit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getConfigurables"));
        }
        return configurableHit;
    }

    @Nullable
    public synchronized Set<OptionDescription> getAcceptableDescriptions(String prefix) {
        if (prefix == null) {
            return null;
        }
        String stemmedPrefix = PorterStemmerUtil.stem(prefix);
        if (StringUtil.isEmptyOrSpaces((String)stemmedPrefix)) {
            return null;
        }
        this.loadHugeFilesIfNecessary();
        Set result = null;
        for (Map.Entry<String, Set<OptionDescription>> entry : this.myStorage.entrySet()) {
            String stemmedOption;
            String option;
            Set<OptionDescription> descriptions = entry.getValue();
            if (descriptions == null || !(option = entry.getKey()).startsWith(prefix) && !option.startsWith(stemmedPrefix) && (stemmedOption = PorterStemmerUtil.stem(option)) != null && !stemmedOption.startsWith(prefix) && !stemmedOption.startsWith(stemmedPrefix)) continue;
            if (result == null) {
                result = new THashSet();
            }
            result.addAll(descriptions);
        }
        return result;
    }

    @Nullable
    public String getInnerPath(SearchableConfigurable configurable, @NonNls String option) {
        this.loadHugeFilesIfNecessary();
        HashSet<OptionDescription> path = null;
        Set<String> words = this.getProcessedWordsWithoutStemming(option);
        for (String word : words) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(word);
            if (configs == null) {
                return null;
            }
            HashSet<OptionDescription> paths = new HashSet<OptionDescription>();
            for (OptionDescription config : configs) {
                if (!Comparing.strEqual((String)config.getConfigurableId(), (String)configurable.getId())) continue;
                paths.add(config);
            }
            if (path == null) {
                path = paths;
            }
            path.retainAll(paths);
        }
        if (path == null || path.isEmpty()) {
            return null;
        }
        OptionDescription result = null;
        for (OptionDescription description : path) {
            String hit = description.getHit();
            if (hit != null) {
                boolean theBest = true;
                for (String word : words) {
                    if (hit.contains(word)) continue;
                    theBest = false;
                }
                if (theBest) {
                    return description.getPath();
                }
            }
            result = description;
        }
        return result != null ? result.getPath() : null;
    }

    public boolean isStopWord(String word) {
        return this.myStopWords.contains(word);
    }

    public Set<String> getSynonym(String option, @NotNull SearchableConfigurable configurable) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getSynonym"));
        }
        this.loadHugeFilesIfNecessary();
        return this.myHighlightOption2Synonym.get(Couple.of((Object)option, (Object)configurable.getId()));
    }

    public Map<String, Set<String>> findPossibleExtension(@NotNull String prefix, Project project) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "findPossibleExtension"));
        }
        this.loadHugeFilesIfNecessary();
        boolean perProject = CodeStyleFacade.getInstance((Project)project).projectUsesOwnSettings();
        THashMap result = new THashMap();
        int count = 0;
        Set<String> prefixes = this.getProcessedWordsWithoutStemming(prefix);
        for (String opt : prefixes) {
            Set<OptionDescription> configs = this.getAcceptableDescriptions(opt);
            if (configs == null) continue;
            for (OptionDescription description : configs) {
                Set foundHits;
                String groupName = this.myId2Name.get(description.getConfigurableId());
                if (perProject) {
                    if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]))) {
                        groupName = ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]);
                    }
                } else if (Comparing.strEqual((String)groupName, (String)ApplicationBundle.message((String)"title.project.code.style", (Object[])new Object[0]))) {
                    groupName = ApplicationBundle.message((String)"title.global.code.style", (Object[])new Object[0]);
                }
                if ((foundHits = (Set)result.get(groupName)) == null) {
                    foundHits = new THashSet();
                    result.put(groupName, foundHits);
                }
                foundHits.add(description.getHit());
                ++count;
            }
        }
        if (count > 20) {
            result.clear();
        }
        return result;
    }

    public void addOption(String option, String path, String hit, String configurableId, String configurableDisplayName) {
        this.putOptionWithHelpId(option, configurableId, configurableDisplayName, hit, path);
    }

    public Set<String> getProcessedWordsWithoutStemming(@NotNull String text) {
        String[] options;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getProcessedWordsWithoutStemming"));
        }
        HashSet<String> result = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        for (String opt : options = REG_EXP.split(toLowerCase)) {
            String processed;
            if (this.isStopWord(opt) || this.isStopWord(processed = PorterStemmerUtil.stem(opt))) continue;
            result.add(opt);
        }
        return result;
    }

    public Set<String> getProcessedWords(@NotNull String text) {
        String[] options;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/ui/search/SearchableOptionsRegistrarImpl", "getProcessedWords"));
        }
        HashSet<String> result = new HashSet<String>();
        String toLowerCase = text.toLowerCase();
        for (String opt : options = REG_EXP.split(toLowerCase)) {
            if (this.isStopWord(opt) || (opt = PorterStemmerUtil.stem(opt)) == null) continue;
            result.add(opt);
        }
        return result;
    }

    public Set<String> replaceSynonyms(Set<String> options, SearchableConfigurable configurable) {
        HashSet<String> result = new HashSet<String>(options);
        for (String option : options) {
            Set<String> synonyms = this.getSynonym(option, configurable);
            if (synonyms != null) {
                result.addAll(synonyms);
                continue;
            }
            result.add(option);
        }
        return result;
    }
}

