/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.internal.psiView.PsiViewerExtension;
import com.intellij.internal.psiView.PsiViewerSettings;
import com.intellij.internal.psiView.ViewerNodeDescriptor;
import com.intellij.internal.psiView.ViewerTreeBuilder;
import com.intellij.internal.psiView.ViewerTreeStructure;
import com.intellij.internal.psiView.formattingblocks.BlockTreeBuilder;
import com.intellij.internal.psiView.formattingblocks.BlockTreeNode;
import com.intellij.internal.psiView.formattingblocks.BlockTreeStructure;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiViewerDialog
extends DialogWrapper
implements DataProvider,
Disposable {
    private static final String REFS_CACHE = "References Resolve Cache";
    private static final Color BOX_COLOR = new JBColor(new Color(16542720), new Color(14576641));
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.internal.psiView.PsiViewerDialog");
    private final Project myProject;
    private JPanel myPanel;
    private JComboBox myFileTypeComboBox;
    private JCheckBox myShowWhiteSpacesBox;
    private JCheckBox myShowTreeNodesCheckBox;
    private JBLabel myDialectLabel;
    private JComboBox myDialectComboBox;
    private JLabel myExtensionLabel;
    private JComboBox myExtensionComboBox;
    private JPanel myTextPanel;
    private JPanel myStructureTreePanel;
    private JPanel myReferencesPanel;
    private JSplitPane myTextSplit;
    private JSplitPane myTreeSplit;
    private Tree myPsiTree;
    private ViewerTreeBuilder myPsiTreeBuilder;
    private JList myRefs;
    private Tree myBlockTree;
    private JPanel myBlockStructurePanel;
    private JSplitPane myBlockRefSplitPane;
    private JCheckBox myShowBlocksCheckBox;
    private TitledSeparator myTextSeparator;
    private TitledSeparator myPsiTreeSeparator;
    private TitledSeparator myRefsSeparator;
    private TitledSeparator myBlockTreeSeparator;
    @Nullable
    private BlockTreeBuilder myBlockTreeBuilder;
    private RangeHighlighter myHighlighter;
    private HashMap<PsiElement, BlockTreeNode> myPsiToBlockMap;
    private final Set<SourceWrapper> mySourceWrappers;
    private final EditorEx myEditor;
    private final EditorListener myEditorListener;
    private String myLastParsedText;
    private int myLastParsedTextHashCode;
    private int myNewDocumentHashCode;
    private int myIgnoreBlockTreeSelectionMarker;
    private PsiFile myCurrentFile;
    private String myInitText;
    private String myFileType;
    private static final Pattern EXT_PATTERN = Pattern.compile("[a-z0-9]*");

    private void createUIComponents() {
        this.myPsiTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myBlockTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myRefs = new JBList(new DefaultListModel());
    }

    public PsiViewerDialog(Project project, boolean modal, @Nullable PsiFile currentFile, @Nullable Editor currentEditor) {
        super(project, true);
        this.$$$setupUI$$$();
        this.mySourceWrappers = ContainerUtil.newTreeSet();
        this.myEditorListener = new EditorListener();
        this.myLastParsedText = null;
        this.myLastParsedTextHashCode = 17;
        this.myNewDocumentHashCode = 11;
        this.myIgnoreBlockTreeSelectionMarker = 0;
        this.myCurrentFile = currentFile;
        this.myProject = project;
        this.setModal(modal);
        this.setOKButtonText("&Build PSI Tree");
        this.setCancelButtonText("&Close");
        Disposer.register((Disposable)this.myProject, (Disposable)this.getDisposable());
        EditorEx editor = null;
        final Ref initOffset = Ref.create();
        if (this.myCurrentFile == null) {
            this.setTitle("PSI Viewer");
        } else {
            this.setTitle("PSI Context Viewer: " + this.myCurrentFile.getName());
            this.myFileType = this.myCurrentFile.getLanguage().getDisplayName();
            if (currentEditor != null) {
                this.myInitText = currentEditor.getSelectionModel().getSelectedText();
                if (this.myInitText == null) {
                    initOffset.set((Object)currentEditor.getCaretModel().getOffset());
                }
            }
            if (this.myInitText == null) {
                this.myInitText = currentFile.getText();
                editor = (EditorEx)EditorFactory.getInstance().createEditor(currentFile.getViewProvider().getDocument(), this.myProject);
            }
        }
        if (editor == null) {
            Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
            editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
        }
        editor.getSettings().setLineMarkerAreaShown(false);
        this.myEditor = editor;
        this.init();
        if (this.myCurrentFile != null) {
            this.doOKAction();
            if (!initOffset.isNull()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(((Integer)initOffset.get()).intValue());
                        PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        SourceWrapper wrapper;
        this.initMnemonics();
        PsiViewerDialog.initTree((JTree)this.myPsiTree);
        final TreeCellRenderer renderer = this.myPsiTree.getCellRenderer();
        this.myPsiTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject;
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/psiView/PsiViewerDialog$2", "getTreeCellRendererComponent"));
                }
                Component c = renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ViewerNodeDescriptor) {
                    Object element = ((ViewerNodeDescriptor)((Object)userObject)).getElement();
                    if (c instanceof NodeRenderer) {
                        ((NodeRenderer)c).setToolTipText(element == null ? null : element.getClass().getName());
                    }
                    if (element instanceof PsiElement && FileContextUtil.getFileContext(((PsiElement)element).getContainingFile()) != null || element instanceof ViewerTreeStructure.Inject) {
                        TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
                        c.setBackground(attr.getBackgroundColor());
                    }
                }
                return c;
            }
        });
        this.myPsiTreeBuilder = new ViewerTreeBuilder(this.myProject, (JTree)this.myPsiTree);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsiTreeBuilder);
        this.myPsiTree.addTreeSelectionListener((TreeSelectionListener)new MyPsiTreeSelectionListener());
        GoToListener listener = new GoToListener();
        this.myRefs.addKeyListener(listener);
        this.myRefs.addMouseListener(listener);
        this.myRefs.getSelectionModel().addListSelectionListener(listener);
        this.myRefs.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/internal/psiView/PsiViewerDialog$3", "getListCellRendererComponent"));
                }
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (PsiViewerDialog.this.resolve(index) == null) {
                    comp.setForeground((Color)JBColor.RED);
                }
                return comp;
            }
        });
        PsiViewerDialog.initTree((JTree)this.myBlockTree);
        this.myEditor.getSettings().setFoldingOutlineShown(false);
        this.myEditor.getDocument().addDocumentListener(this.myEditorListener);
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this.myEditorListener);
        this.myEditor.getCaretModel().addCaretListener((CaretListener)this.myEditorListener);
        this.getPeer().getWindow().setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getInitialComponent(@NotNull Window window) {
                if (window == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/internal/psiView/PsiViewerDialog$4", "getInitialComponent"));
                }
                return PsiViewerDialog.this.myEditor.getComponent();
            }
        });
        final PsiViewerSettings settings = PsiViewerSettings.getSettings();
        String type = this.myFileType != null ? this.myFileType : settings.type;
        SourceWrapper lastUsed = null;
        for (PsiViewerExtension extension : (PsiViewerExtension[])Extensions.getExtensions(PsiViewerExtension.EP_NAME)) {
            wrapper = new SourceWrapper(extension);
            this.mySourceWrappers.add(wrapper);
        }
        HashSet allFileTypes = ContainerUtil.newHashSet();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        Language curLanguage = this.myCurrentFile != null ? this.myCurrentFile.getLanguage() : null;
        for (LanguageFileType fileType : allFileTypes) {
            if (fileType == StdFileTypes.GUI_DESIGNER_FORM || fileType == StdFileTypes.IDEA_MODULE || fileType == StdFileTypes.IDEA_PROJECT || fileType == StdFileTypes.IDEA_WORKSPACE || fileType == FileTypes.ARCHIVE || fileType == FileTypes.UNKNOWN || fileType == FileTypes.PLAIN_TEXT || fileType instanceof AbstractFileType || fileType.isBinary() || fileType.isReadOnly()) continue;
            wrapper = new SourceWrapper((FileType)fileType);
            this.mySourceWrappers.add(wrapper);
            if (lastUsed == null && wrapper.getText().equals(type)) {
                lastUsed = wrapper;
            }
            if (this.myCurrentFile == null || !(wrapper.myFileType instanceof LanguageFileType) || !wrapper.myFileType.equals(curLanguage.getAssociatedFileType())) continue;
            lastUsed = wrapper;
        }
        this.myFileTypeComboBox.setModel(new CollectionComboBoxModel((List)ContainerUtil.newArrayList(this.mySourceWrappers), lastUsed));
        this.myFileTypeComboBox.setRenderer(new ListCellRendererWrapper<SourceWrapper>(){

            public void customize(JList list, SourceWrapper value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getText());
                    this.setIcon(value.getIcon());
                }
            }
        });
        new ComboboxSpeedSearch(this.myFileTypeComboBox){

            @Override
            protected String getElementText(Object element) {
                return element instanceof SourceWrapper ? ((SourceWrapper)element).getText() : null;
            }
        };
        this.myFileTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$7", "actionPerformed"));
                }
                PsiViewerDialog.this.updateDialectsCombo(null);
                PsiViewerDialog.this.updateExtensionsCombo();
                PsiViewerDialog.this.updateEditor();
            }
        });
        this.myDialectComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$8", "actionPerformed"));
                }
                PsiViewerDialog.this.updateEditor();
            }
        });
        this.myFileTypeComboBox.addFocusListener(new AutoExpandFocusListener(this.myFileTypeComboBox));
        if (this.myCurrentFile == null && lastUsed == null && this.mySourceWrappers.size() > 0) {
            this.myFileTypeComboBox.setSelectedIndex(0);
        }
        this.myDialectComboBox.setRenderer(new ListCellRendererWrapper<Language>(){

            public void customize(JList list, Language value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value.getDisplayName() : "<default>");
            }
        });
        this.myDialectComboBox.addFocusListener(new AutoExpandFocusListener(this.myDialectComboBox));
        this.myExtensionComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText("." + value);
                }
            }
        });
        this.myExtensionComboBox.addFocusListener(new AutoExpandFocusListener(this.myExtensionComboBox));
        final ViewerTreeStructure psiTreeStructure = (ViewerTreeStructure)this.myPsiTreeBuilder.getTreeStructure();
        this.myShowWhiteSpacesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$11", "actionPerformed"));
                }
                psiTreeStructure.setShowWhiteSpaces(PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected());
                PsiViewerDialog.this.myPsiTreeBuilder.queueUpdate();
            }
        });
        this.myShowTreeNodesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$12", "actionPerformed"));
                }
                psiTreeStructure.setShowTreeNodes(PsiViewerDialog.this.myShowTreeNodesCheckBox.isSelected());
                PsiViewerDialog.this.myPsiTreeBuilder.queueUpdate();
            }
        });
        this.myShowWhiteSpacesBox.setSelected(settings.showWhiteSpaces);
        psiTreeStructure.setShowWhiteSpaces(settings.showWhiteSpaces);
        this.myShowTreeNodesCheckBox.setSelected(settings.showTreeNodes);
        psiTreeStructure.setShowTreeNodes(settings.showTreeNodes);
        this.myShowBlocksCheckBox.setSelected(settings.showBlocks);
        this.myBlockStructurePanel.setVisible(settings.showBlocks);
        this.myShowBlocksCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$13", "actionPerformed"));
                }
                if (!PsiViewerDialog.this.myShowBlocksCheckBox.isSelected()) {
                    settings.blockRefDividerLocation = PsiViewerDialog.this.myBlockRefSplitPane.getDividerLocation();
                } else {
                    PsiViewerDialog.this.myBlockRefSplitPane.setDividerLocation(settings.blockRefDividerLocation);
                }
                PsiViewerDialog.this.myBlockStructurePanel.setVisible(PsiViewerDialog.this.myShowBlocksCheckBox.isSelected());
                PsiViewerDialog.this.myBlockStructurePanel.repaint();
            }
        });
        this.myTextPanel.setLayout(new BorderLayout());
        this.myTextPanel.add((Component)this.myEditor.getComponent(), "Center");
        String text = this.myCurrentFile == null ? settings.text : this.myInitText;
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(((Object)((Object)this)).getClass());
        try {
            this.myEditor.getDocument().setText(text);
            this.myEditor.getSelectionModel().setSelection(0, text.length());
        }
        finally {
            token.finish();
        }
        this.updateDialectsCombo(settings.dialect);
        this.updateExtensionsCombo();
        this.registerCustomKeyboardActions();
        Dimension size = DimensionService.getInstance().getSize(this.getDimensionServiceKey(), this.myProject);
        if (size == null) {
            DimensionService.getInstance().setSize(this.getDimensionServiceKey(), (Dimension)JBUI.size((int)800, (int)600));
        }
        this.myTextSplit.setDividerLocation(settings.textDividerLocation);
        this.myTreeSplit.setDividerLocation(settings.treeDividerLocation);
        this.myBlockRefSplitPane.setDividerLocation(settings.blockRefDividerLocation);
        this.updateEditor();
        super.init();
    }

    private static void initTree(JTree tree) {
        UIUtil.setLineStyleAngled((JTree)tree);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        ToolTipManager.sharedInstance().registerComponent(tree);
        TreeUtil.installActions((JTree)tree);
        new TreeSpeedSearch(tree);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.internal.psiView.PsiViewerDialog";
    }

    protected String getHelpId() {
        return "reference.psi.viewer";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    private void registerCustomKeyboardActions() {
        int mask = SystemInfo.isMac ? 256 : 512;
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$14", "actionPerformed"));
                }
                PsiViewerDialog.this.focusEditor();
            }
        }, KeyStroke.getKeyStroke(84, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$15", "actionPerformed"));
                }
                PsiViewerDialog.this.focusTree();
            }
        }, KeyStroke.getKeyStroke(83, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$16", "actionPerformed"));
                }
                PsiViewerDialog.this.focusBlockTree();
            }
        }, KeyStroke.getKeyStroke(75, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$17", "actionPerformed"));
                }
                PsiViewerDialog.this.focusRefs();
            }
        }, KeyStroke.getKeyStroke(82, mask));
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$18", "actionPerformed"));
                }
                if (PsiViewerDialog.this.myRefs.isFocusOwner()) {
                    PsiViewerDialog.this.focusBlockTree();
                } else if (PsiViewerDialog.this.myPsiTree.isFocusOwner()) {
                    PsiViewerDialog.this.focusRefs();
                } else if (PsiViewerDialog.this.myBlockTree.isFocusOwner()) {
                    PsiViewerDialog.this.focusTree();
                }
            }
        }, KeyStroke.getKeyStroke(9, 0));
    }

    private void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke) {
        this.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void focusEditor() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myEditor.getContentComponent(), true);
    }

    private void focusTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myPsiTree, true);
    }

    private void focusRefs() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myRefs, true);
        if (this.myRefs.getModel().getSize() > 0 && this.myRefs.getSelectedIndex() == -1) {
            this.myRefs.setSelectedIndex(0);
        }
    }

    private void focusBlockTree() {
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myBlockTree, true);
    }

    private void initMnemonics() {
        this.myTextSeparator.setLabelFor((Component)this.myEditor.getContentComponent());
        this.myPsiTreeSeparator.setLabelFor((Component)this.myPsiTree);
        this.myRefsSeparator.setLabelFor((Component)this.myRefs);
        this.myBlockTreeSeparator.setLabelFor((Component)this.myBlockTree);
    }

    @Nullable
    private PsiElement getPsiElement() {
        TreePath path = this.myPsiTree.getSelectionPath();
        return path == null ? null : PsiViewerDialog.getPsiElement((DefaultMutableTreeNode)path.getLastPathComponent());
    }

    @Nullable
    private static PsiElement getPsiElement(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof ViewerNodeDescriptor) {
            ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
            Object elementObject = descriptor.getElement();
            return elementObject instanceof PsiElement ? (PsiElement)elementObject : (elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
        }
        return null;
    }

    private void updateDialectsCombo(@Nullable String lastUsed) {
        Object source = this.getSource();
        ArrayList<Language> items = new ArrayList<Language>();
        if (source instanceof LanguageFileType) {
            Language baseLang = ((LanguageFileType)source).getLanguage();
            items.add(baseLang);
            Language[] dialects = LanguageUtil.getLanguageDialects((Language)baseLang);
            Arrays.sort(dialects, LanguageUtil.LANGUAGE_COMPARATOR);
            items.addAll(Arrays.asList(dialects));
        }
        this.myDialectComboBox.setModel(new CollectionComboBoxModel(items));
        int size = items.size();
        boolean visible = size > 1;
        this.myDialectLabel.setVisible(visible);
        this.myDialectComboBox.setVisible(visible);
        if (visible && (this.myCurrentFile != null || lastUsed != null)) {
            String curLanguage = this.myCurrentFile != null ? this.myCurrentFile.getLanguage().toString() : lastUsed;
            for (int i = 0; i < size; ++i) {
                if (!curLanguage.equals(((Language)items.get(i)).toString())) continue;
                this.myDialectComboBox.setSelectedIndex(i);
                return;
            }
            this.myDialectComboBox.setSelectedIndex(size > 0 ? 0 : -1);
        }
    }

    private void updateExtensionsCombo() {
        List<String> extensions;
        Object source = this.getSource();
        if (source instanceof LanguageFileType && (extensions = PsiViewerDialog.getAllExtensions((LanguageFileType)source)).size() > 1) {
            String fileExt;
            ExtensionComparator comp = new ExtensionComparator(extensions.get(0));
            Collections.sort(extensions, comp);
            SortedComboBoxModel model = new SortedComboBoxModel((Comparator)comp);
            model.setAll(extensions);
            this.myExtensionComboBox.setModel(model);
            this.myExtensionComboBox.setVisible(true);
            this.myExtensionLabel.setVisible(true);
            String string = fileExt = this.myCurrentFile != null ? FileUtilRt.getExtension((String)this.myCurrentFile.getName()) : "";
            if (fileExt.length() > 0 && extensions.contains(fileExt)) {
                this.myExtensionComboBox.setSelectedItem(fileExt);
                return;
            }
            this.myExtensionComboBox.setSelectedIndex(0);
            return;
        }
        this.myExtensionComboBox.setVisible(false);
        this.myExtensionLabel.setVisible(false);
    }

    private static List<String> getAllExtensions(LanguageFileType fileType) {
        List associations = FileTypeManager.getInstance().getAssociations((FileType)fileType);
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(fileType.getDefaultExtension().toLowerCase());
        for (FileNameMatcher matcher : associations) {
            String ext;
            String presentableString = matcher.getPresentableString().toLowerCase();
            if (!presentableString.startsWith("*.") || (ext = presentableString.substring(2)).length() <= 0 || extensions.contains(ext) || !EXT_PATTERN.matcher(ext).matches()) continue;
            extensions.add(ext);
        }
        return extensions;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    private Object getSource() {
        SourceWrapper wrapper = (SourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            return wrapper.myFileType != null ? wrapper.myFileType : wrapper.myExtension;
        }
        return null;
    }

    @NotNull
    protected Action[] createActions() {
        AbstractAction copyPsi = new AbstractAction("Cop&y PSI"){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$19", "actionPerformed"));
                }
                PsiElement element = PsiViewerDialog.this.parseText(PsiViewerDialog.this.myEditor.getDocument().getText());
                ArrayList<PsiElement> allToParse = new ArrayList<PsiElement>();
                if (element instanceof PsiFile) {
                    allToParse.addAll(((PsiFile)element).getViewProvider().getAllFiles());
                } else if (element != null) {
                    allToParse.add(element);
                }
                String data = "";
                for (PsiElement psiElement : allToParse) {
                    data = data + DebugUtil.psiToString(psiElement, !PsiViewerDialog.this.myShowWhiteSpacesBox.isSelected(), true);
                }
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(data));
            }
        };
        Action[] actionArray = (Action[])ArrayUtil.mergeArrays((Object[])new Action[]{copyPsi}, (Object[])super.createActions());
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/psiView/PsiViewerDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        Block rootBlock;
        if (this.myBlockTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myBlockTreeBuilder);
        }
        String text = this.myEditor.getDocument().getText();
        this.myEditor.getSelectionModel().removeSelection();
        this.myLastParsedText = text;
        this.myNewDocumentHashCode = this.myLastParsedTextHashCode = text.hashCode();
        PsiElement rootElement = this.parseText(text);
        this.focusTree();
        ViewerTreeStructure structure = (ViewerTreeStructure)this.myPsiTreeBuilder.getTreeStructure();
        structure.setRootPsiElement(rootElement);
        this.myPsiTreeBuilder.queueUpdate();
        this.myPsiTree.setRootVisible(true);
        this.myPsiTree.expandRow(0);
        this.myPsiTree.setRootVisible(false);
        if (!this.myShowBlocksCheckBox.isSelected()) {
            return;
        }
        Block block = rootBlock = rootElement == null ? null : PsiViewerDialog.buildBlocks(rootElement);
        if (rootBlock == null) {
            this.myBlockTreeBuilder = null;
            this.myBlockTree.setRootVisible(false);
            this.myBlockTree.setVisible(false);
            return;
        }
        this.myBlockTree.setVisible(true);
        BlockTreeStructure blockTreeStructure = new BlockTreeStructure();
        BlockTreeNode rootNode = new BlockTreeNode(rootBlock, null);
        blockTreeStructure.setRoot(rootNode);
        this.myBlockTreeBuilder = new BlockTreeBuilder((JTree)this.myBlockTree, blockTreeStructure);
        this.myPsiToBlockMap = new HashMap();
        PsiElement psiFile = ((ViewerTreeStructure)this.myPsiTreeBuilder.getTreeStructure()).getRootPsiElement();
        this.initMap(rootNode, psiFile);
        PsiElement rootPsi = rootNode.getBlock() instanceof ASTBlock ? ((ASTBlock)rootNode.getBlock()).getNode().getPsi() : rootElement;
        BlockTreeNode blockNode = this.myPsiToBlockMap.get(rootPsi);
        if (blockNode == null) {
            LOG.error((Object)LogMessageEx.createEvent("PsiViewer: rootNode not found", "Current language: " + rootElement.getContainingFile().getLanguage(), AttachmentFactory.createAttachment(rootElement.getContainingFile().getOriginalFile().getVirtualFile())));
            blockNode = this.findBlockNode(rootPsi);
        }
        blockTreeStructure.setRoot(blockNode);
        this.myBlockTree.addTreeSelectionListener((TreeSelectionListener)new MyBlockTreeSelectionListener());
        this.myBlockTree.setRootVisible(true);
        this.myBlockTree.expandRow(0);
        this.myBlockTreeBuilder.queueUpdate();
    }

    private PsiElement parseText(String text) {
        Object source = this.getSource();
        try {
            if (source instanceof PsiViewerExtension) {
                return ((PsiViewerExtension)source).createElement(this.myProject, text);
            }
            if (source instanceof FileType) {
                FileType type = (FileType)source;
                String ext = type.getDefaultExtension();
                if (this.myExtensionComboBox.isVisible()) {
                    ext = this.myExtensionComboBox.getSelectedItem().toString().toLowerCase();
                }
                if (type instanceof LanguageFileType) {
                    Language language = ((LanguageFileType)type).getLanguage();
                    Language dialect = (Language)this.myDialectComboBox.getSelectedItem();
                    return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, dialect == null ? language : dialect, (CharSequence)text);
                }
                return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("Dummy." + ext, type, (CharSequence)text);
            }
        }
        catch (IncorrectOperationException e) {
            Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)"Error", (Icon)Messages.getErrorIcon());
        }
        return null;
    }

    @Nullable
    private static Block buildBlocks(@NotNull PsiElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/internal/psiView/PsiViewerDialog", "buildBlocks"));
        }
        FormattingModelBuilder formattingModelBuilder = LanguageFormatting.INSTANCE.forContext(rootElement);
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)rootElement.getProject());
        if (formattingModelBuilder != null) {
            FormattingModel formattingModel = formattingModelBuilder.createModel(rootElement, settings);
            return formattingModel.getRootBlock();
        }
        return null;
    }

    private void initMap(BlockTreeNode rootBlockNode, PsiElement psiEl) {
        ASTNode node;
        PsiElement currentElem = null;
        if (rootBlockNode.getBlock() instanceof ASTBlock && (node = ((ASTBlock)rootBlockNode.getBlock()).getNode()) != null) {
            currentElem = node.getPsi();
        }
        if (currentElem == null) {
            currentElem = InjectedLanguageUtil.findElementAtNoCommit(psiEl.getContainingFile(), rootBlockNode.getBlock().getTextRange().getStartOffset());
        }
        this.myPsiToBlockMap.put(currentElem, rootBlockNode);
        TextRange curTextRange = currentElem.getTextRange();
        for (PsiElement parentElem = currentElem.getParent(); parentElem != null && parentElem.getTextRange().equals((Object)curTextRange); parentElem = parentElem.getParent()) {
            this.myPsiToBlockMap.put(parentElem, rootBlockNode);
        }
        for (BlockTreeNode block : rootBlockNode.getChildren()) {
            this.initMap(block, psiEl);
        }
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            Object value;
            String fqn = null;
            if (this.myPsiTree.hasFocus()) {
                TreePath path = this.myPsiTree.getSelectionPath();
                if (path != null) {
                    PsiElement element;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                        return null;
                    }
                    ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                    Object elementObject = descriptor.getElement();
                    Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                    if (element != null) {
                        fqn = element.getClass().getName();
                    }
                }
            } else if (this.myRefs.hasFocus() && (value = this.myRefs.getSelectedValue()) instanceof String) {
                fqn = (String)value;
            }
            if (fqn != null) {
                return this.getContainingFileForClass(fqn);
            }
        }
        return null;
    }

    @Nullable
    private BlockTreeNode findBlockNode(PsiElement element) {
        BlockTreeNode result = this.myPsiToBlockMap.get(element);
        if (result == null) {
            TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, element.getTextRange());
            result = this.findBlockNode(rangeInHostFile, true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectBlockNode(@Nullable BlockTreeNode currentBlockNode) {
        if (this.myBlockTreeBuilder == null) {
            return;
        }
        if (currentBlockNode != null) {
            ++this.myIgnoreBlockTreeSelectionMarker;
            this.myBlockTreeBuilder.select((Object)currentBlockNode, new Runnable(){

                @Override
                public void run() {
                    assert (PsiViewerDialog.this.myIgnoreBlockTreeSelectionMarker > 0);
                    PsiViewerDialog.this.myIgnoreBlockTreeSelectionMarker--;
                }
            });
        } else {
            ++this.myIgnoreBlockTreeSelectionMarker;
            try {
                this.myBlockTree.getSelectionModel().clearSelection();
            }
            finally {
                assert (this.myIgnoreBlockTreeSelectionMarker > 0);
                --this.myIgnoreBlockTreeSelectionMarker;
            }
        }
    }

    public void updateReferences(PsiElement element) {
        DefaultListModel model = (DefaultListModel)this.myRefs.getModel();
        model.clear();
        Object cache = this.myRefs.getClientProperty(REFS_CACHE);
        if (cache instanceof Map) {
            ((Map)cache).clear();
        } else {
            this.myRefs.putClientProperty(REFS_CACHE, new HashMap());
        }
        if (element != null) {
            for (PsiReference reference : element.getReferences()) {
                model.addElement(reference.getClass().getName());
            }
        }
    }

    private void clearSelection() {
        if (this.myHighlighter != null) {
            this.myEditor.getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter.dispose();
        }
    }

    public void doCancelAction() {
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        SourceWrapper wrapper = (SourceWrapper)this.myFileTypeComboBox.getSelectedItem();
        if (wrapper != null) {
            settings.type = wrapper.getText();
        }
        settings.text = this.myEditor.getDocument().getText();
        settings.showTreeNodes = this.myShowTreeNodesCheckBox.isSelected();
        settings.showWhiteSpaces = this.myShowWhiteSpacesBox.isSelected();
        Object selectedDialect = this.myDialectComboBox.getSelectedItem();
        settings.dialect = this.myDialectComboBox.isVisible() && selectedDialect != null ? selectedDialect.toString() : "";
        settings.textDividerLocation = this.myTextSplit.getDividerLocation();
        settings.treeDividerLocation = this.myTreeSplit.getDividerLocation();
        settings.showBlocks = this.myShowBlocksCheckBox.isSelected();
        if (this.myShowBlocksCheckBox.isSelected()) {
            settings.blockRefDividerLocation = this.myBlockRefSplitPane.getDividerLocation();
        }
        super.doCancelAction();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myPsiTreeBuilder);
        if (this.myBlockTreeBuilder != null) {
            Disposer.dispose((Disposable)this.myBlockTreeBuilder);
        }
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
        }
        super.dispose();
    }

    @Nullable
    private PsiElement resolve(int index) {
        PsiElement[] cache;
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return null;
        }
        HashMap<PsiElement, PsiElement[]> map = (HashMap<PsiElement, PsiElement[]>)this.myRefs.getClientProperty(REFS_CACHE);
        if (map == null) {
            map = new HashMap<PsiElement, PsiElement[]>();
            this.myRefs.putClientProperty(REFS_CACHE, map);
        }
        if ((cache = (PsiElement[])map.get(element)) == null) {
            PsiReference[] references = element.getReferences();
            cache = new PsiElement[references.length];
            for (int i = 0; i < references.length; ++i) {
                cache[i] = references[i].resolve();
            }
            map.put(element, cache);
        }
        return index >= cache.length ? null : cache[index];
    }

    @Nullable
    private PsiFile getContainingFileForClass(String fqn) {
        PsiFile[] files;
        String filename = fqn;
        if (fqn.contains(".")) {
            filename = fqn.substring(fqn.lastIndexOf(46) + 1);
        }
        if (filename.contains("$")) {
            filename = filename.substring(0, filename.indexOf(36));
        }
        if ((files = FilenameIndex.getFilesByName(this.myProject, filename = filename + ".java", GlobalSearchScope.allScope((Project)this.myProject))) != null && files.length > 0) {
            return files[0];
        }
        return null;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (childNode.getUserObject().equals(object)) {
                return childNode;
            }
            TreeNode node = PsiViewerDialog.findNodeWithObject(object, model, childNode);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private void updateEditor() {
        LightVirtualFile lightFile;
        Object source = this.getSource();
        String fileName = "Dummy." + (source instanceof FileType ? ((FileType)source).getDefaultExtension() : "txt");
        if (source instanceof PsiViewerExtension) {
            lightFile = new LightVirtualFile(fileName, ((PsiViewerExtension)source).getDefaultFileType(), (CharSequence)"");
        } else if (source instanceof LanguageFileType) {
            lightFile = new LightVirtualFile(fileName, (Language)ObjectUtils.chooseNotNull((Object)((Language)this.myDialectComboBox.getSelectedItem()), (Object)((LanguageFileType)source).getLanguage()), (CharSequence)"");
        } else if (source instanceof FileType) {
            lightFile = new LightVirtualFile(fileName, (FileType)source, (CharSequence)"");
        } else {
            return;
        }
        this.myEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)lightFile));
    }

    @Nullable
    private BlockTreeNode findBlockNode(TextRange range, boolean selectParentIfNotFound) {
        BlockTreeBuilder builder = this.myBlockTreeBuilder;
        if (builder == null || !this.myBlockStructurePanel.isVisible()) {
            return null;
        }
        AbstractTreeStructure treeStructure = builder.getTreeStructure();
        if (treeStructure == null) {
            return null;
        }
        BlockTreeNode node = (BlockTreeNode)((Object)treeStructure.getRootElement());
        block0: while (true) {
            if (node.getBlock().getTextRange().equals((Object)range)) {
                return node;
            }
            for (BlockTreeNode child : node.getChildren()) {
                if (!child.getBlock().getTextRange().contains(range)) continue;
                node = child;
                continue block0;
            }
            break;
        }
        return selectParentIfNotFound ? node : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TitledSeparator titledSeparator;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JBLabel jBLabel;
        JComboBox jComboBox3;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TitledSeparator titledSeparator2;
        JPanel jPanel;
        TitledSeparator titledSeparator3;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        TitledSeparator titledSeparator4;
        JPanel jPanel3;
        JSplitPane jSplitPane2;
        JPanel jPanel4;
        JSplitPane jSplitPane3;
        JPanel jPanel5;
        this.createUIComponents();
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTextSplit = jSplitPane3 = new JSplitPane();
        jSplitPane3.setDividerLocation(250);
        jSplitPane3.setDividerSize(4);
        jSplitPane3.setOrientation(0);
        jPanel5.add((Component)jSplitPane3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myTextPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane3.setLeftComponent(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane3.setRightComponent(jPanel6);
        this.myTreeSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setDividerLocation(200);
        jSplitPane2.setDividerSize(4);
        jPanel6.add((Component)jSplitPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myStructureTreePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane2.setLeftComponent(jPanel3);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = this.myPsiTree;
        jBScrollPane.setViewportView((Component)tree);
        this.myPsiTreeSeparator = titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("PSI &Structure");
        jPanel3.add((Component)titledSeparator4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBlockRefSplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(200);
        ((Component)jSplitPane).setEnabled(true);
        jSplitPane.setContinuousLayout(true);
        jSplitPane2.setRightComponent(jSplitPane);
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myReferencesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        JList jList = this.myRefs;
        jPanel2.add((Component)jList, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRefsSeparator = titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("&References");
        jPanel2.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myBlockStructurePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree2 = this.myBlockTree;
        jBScrollPane2.setViewportView((Component)tree2);
        this.myBlockTreeSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Bloc&k Structure");
        jPanel.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.setDoubleBuffered(true);
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 8, 2, 7, 0, null, null, null));
        this.myShowWhiteSpacesBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Show PsiWhiteSpace");
        jCheckBox3.setMnemonic('W');
        jCheckBox3.setDisplayedMnemonicIndex(8);
        jCheckBox3.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox3.setSelected(true);
        jPanel7.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowTreeNodesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show tree nodes");
        jCheckBox2.setMnemonic('N');
        jCheckBox2.setDisplayedMnemonicIndex(10);
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox2.setSelected(true);
        jPanel7.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myExtensionLabel = jLabel = new JLabel();
        jLabel.setText("Extension:");
        jLabel.setDisplayedMnemonic('X');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel8.add((Component)jLabel, "West");
        this.myExtensionComboBox = jComboBox3 = new JComboBox();
        jPanel8.add(jComboBox3, "Center");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel9, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDialectLabel = jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jBLabel.setDisplayedMnemonic('D');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel9.add((Component)jBLabel, "West");
        this.myDialectComboBox = jComboBox2 = new JComboBox();
        jPanel9.add(jComboBox2, "Center");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Show PSI structure for:");
        jLabel2.setDisplayedMnemonic('P');
        jLabel2.setDisplayedMnemonicIndex(5);
        jLabel2.setIconTextGap(0);
        jPanel10.add((Component)jLabel2, "West");
        this.myFileTypeComboBox = jComboBox = new JComboBox();
        jComboBox.setMaximumRowCount(30);
        jPanel10.add(jComboBox, "Center");
        this.myShowBlocksCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setLabel("Show formatting blocks");
        jCheckBox.setText("Show formatting blocks");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setSelected(true);
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 5, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTextSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText("&Text");
        jPanel5.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jBLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class AutoExpandFocusListener
    extends FocusAdapter {
        private final JComboBox myComboBox;
        private final Component myParent;

        private AutoExpandFocusListener(JComboBox comboBox) {
            this.myComboBox = comboBox;
            this.myParent = UIUtil.findUltimateParent((Component)this.myComboBox);
        }

        @Override
        public void focusGained(@NotNull FocusEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$AutoExpandFocusListener", "focusGained"));
            }
            Component from = e.getOppositeComponent();
            if (!e.isTemporary() && from != null && !this.myComboBox.isPopupVisible() && AutoExpandFocusListener.isUnder(from, this.myParent)) {
                this.myComboBox.setPopupVisible(true);
            }
        }

        private static boolean isUnder(Component component, Component parent) {
            while (component != null) {
                if (component == parent) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }
    }

    private class EditorListener
    extends CaretAdapter
    implements SelectionListener,
    DocumentListener {
        private EditorListener() {
        }

        public void caretPositionChanged(CaretEvent e) {
            if (!this.available() || PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure();
            PsiElement rootPsiElement = treeStructure.getRootPsiElement();
            if (rootPsiElement == null) {
                return;
            }
            PsiElement rootElement = ((ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure()).getRootPsiElement();
            int baseOffset = rootPsiElement.getTextRange().getStartOffset();
            int offset = PsiViewerDialog.this.myEditor.getCaretModel().getOffset() + baseOffset;
            PsiElement element = InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), offset);
            if (element != null && PsiViewerDialog.this.myBlockTreeBuilder != null) {
                TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                PsiViewerDialog.this.selectBlockNode(PsiViewerDialog.this.findBlockNode(rangeInHostFile, true));
            }
            PsiViewerDialog.this.myPsiTreeBuilder.select(element);
        }

        public void selectionChanged(SelectionEvent e) {
            if (!this.available() || !PsiViewerDialog.this.myEditor.getSelectionModel().hasSelection()) {
                return;
            }
            ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure();
            if (treeStructure == null) {
                return;
            }
            PsiElement rootElement = treeStructure.getRootPsiElement();
            if (rootElement == null) {
                return;
            }
            SelectionModel selection = PsiViewerDialog.this.myEditor.getSelectionModel();
            TextRange textRange = rootElement.getTextRange();
            int baseOffset = textRange != null ? textRange.getStartOffset() : 0;
            int start = selection.getSelectionStart() + baseOffset;
            int end = selection.getSelectionEnd() + baseOffset - 1;
            PsiElement element = this.findCommonParent(InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), start), InjectedLanguageUtil.findElementAtNoCommit(rootElement.getContainingFile(), end));
            if (element != null && PsiViewerDialog.this.myBlockTreeBuilder != null && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus()) {
                TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                PsiViewerDialog.this.selectBlockNode(PsiViewerDialog.this.findBlockNode(rangeInHostFile, true));
            }
            PsiViewerDialog.this.myPsiTreeBuilder.select(element);
        }

        @Nullable
        private PsiElement findCommonParent(PsiElement start, PsiElement end) {
            PsiElement parent;
            if (end == null || start == end) {
                return start;
            }
            TextRange endRange = end.getTextRange();
            for (parent = start.getContext(); parent != null && !parent.getTextRange().contains(endRange); parent = parent.getContext()) {
            }
            return parent;
        }

        private boolean available() {
            return PsiViewerDialog.this.myLastParsedTextHashCode == PsiViewerDialog.this.myNewDocumentHashCode && PsiViewerDialog.this.myEditor.getContentComponent().hasFocus();
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            PsiViewerDialog.this.myNewDocumentHashCode = event.getDocument().getText().hashCode();
        }
    }

    private class GoToListener
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private RangeHighlighter myListenerHighlighter;
        private final TextAttributes myAttributes = new TextAttributes((Color)JBColor.RED, null, null, null, 0);

        private GoToListener() {
        }

        private void navigate() {
            String fqn;
            PsiFile file;
            Object value = PsiViewerDialog.this.myRefs.getSelectedValue();
            if (value instanceof String && (file = PsiViewerDialog.this.getContainingFileForClass(fqn = (String)value)) != null) {
                file.navigate(true);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "keyPressed"));
            }
            if (e.getKeyCode() == 10) {
                this.navigate();
            }
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "mouseClicked"));
            }
            if (e.getClickCount() > 1) {
                this.navigate();
            }
        }

        @Override
        public void valueChanged(@NotNull ListSelectionEvent e) {
            PsiReference[] references;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "valueChanged"));
            }
            this.clearSelection();
            PsiViewerDialog.this.updateDialectsCombo(null);
            PsiViewerDialog.this.updateExtensionsCombo();
            int ind = PsiViewerDialog.this.myRefs.getSelectedIndex();
            PsiElement element = PsiViewerDialog.this.getPsiElement();
            if (ind > -1 && element != null && ind < (references = element.getReferences()).length) {
                TextRange textRange = references[ind].getRangeInElement();
                TextRange range = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                int start = range.getStartOffset();
                int end = range.getEndOffset();
                ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure();
                PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                if (rootPsiElement != null) {
                    int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                    start -= baseOffset;
                    end -= baseOffset;
                }
                end = (start += textRange.getStartOffset()) + textRange.getLength();
                this.myListenerHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 1001, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
            }
        }

        public void clearSelection() {
            if (this.myListenerHighlighter != null && ArrayUtil.contains((Object)this.myListenerHighlighter, (Object[])PsiViewerDialog.this.myEditor.getMarkupModel().getAllHighlighters())) {
                this.myListenerHighlighter.dispose();
                this.myListenerHighlighter = null;
            }
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "keyTyped"));
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "mousePressed"));
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "mouseReleased"));
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$GoToListener", "mouseExited"));
            }
        }
    }

    private class MyBlockTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        public MyBlockTreeSelectionListener() {
            this.myAttributes.setEffectColor(BOX_COLOR);
            this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$MyBlockTreeSelectionListener", "valueChanged"));
            }
            if (PsiViewerDialog.this.myIgnoreBlockTreeSelectionMarker > 0 || PsiViewerDialog.this.myBlockTreeBuilder == null) {
                return;
            }
            Set blockElementsSet = PsiViewerDialog.this.myBlockTreeBuilder.getSelectedElements();
            if (blockElementsSet.isEmpty()) {
                return;
            }
            BlockTreeNode descriptor = (BlockTreeNode)((Object)blockElementsSet.iterator().next());
            PsiElement rootPsi = ((ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure()).getRootPsiElement();
            int blockStart = descriptor.getBlock().getTextRange().getStartOffset();
            PsiFile file = rootPsi.getContainingFile();
            PsiElement currentPsiEl = InjectedLanguageUtil.findElementAtNoCommit(file, blockStart);
            if (currentPsiEl == null) {
                currentPsiEl = file;
            }
            int blockLength = descriptor.getBlock().getTextRange().getLength();
            while (currentPsiEl.getParent() != null && currentPsiEl.getTextRange().getStartOffset() == blockStart && currentPsiEl.getTextLength() != blockLength) {
                currentPsiEl = currentPsiEl.getParent();
            }
            BlockTreeStructure treeStructure = (BlockTreeStructure)PsiViewerDialog.this.myBlockTreeBuilder.getTreeStructure();
            BlockTreeNode rootBlockNode = treeStructure.getRootElement();
            int baseOffset = 0;
            if (rootBlockNode != null) {
                baseOffset = rootBlockNode.getBlock().getTextRange().getStartOffset();
            }
            if (currentPsiEl != null) {
                TextRange range = descriptor.getBlock().getTextRange();
                range = range.shiftRight(-baseOffset);
                int start = range.getStartOffset();
                int end = range.getEndOffset();
                int textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength();
                if (PsiViewerDialog.this.myBlockTree.hasFocus()) {
                    PsiViewerDialog.this.clearSelection();
                    if (end <= textLength) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                        PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    }
                }
                PsiViewerDialog.this.updateReferences(currentPsiEl);
                if (!PsiViewerDialog.this.myPsiTree.hasFocus()) {
                    PsiViewerDialog.this.myPsiTreeBuilder.select(currentPsiEl);
                }
            }
        }
    }

    private class MyPsiTreeSelectionListener
    implements TreeSelectionListener {
        private final TextAttributes myAttributes = new TextAttributes();

        public MyPsiTreeSelectionListener() {
            this.myAttributes.setEffectColor(BOX_COLOR);
            this.myAttributes.setEffectType(EffectType.ROUNDED_BOX);
        }

        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/psiView/PsiViewerDialog$MyPsiTreeSelectionListener", "valueChanged"));
            }
            if (!PsiViewerDialog.this.myEditor.getDocument().getText().equals(PsiViewerDialog.this.myLastParsedText) || PsiViewerDialog.this.myBlockTree.hasFocus()) {
                return;
            }
            TreePath path = PsiViewerDialog.this.myPsiTree.getSelectionPath();
            PsiViewerDialog.this.clearSelection();
            if (path != null) {
                PsiElement element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof ViewerNodeDescriptor)) {
                    return;
                }
                ViewerNodeDescriptor descriptor = (ViewerNodeDescriptor)((Object)node.getUserObject());
                Object elementObject = descriptor.getElement();
                Object object = elementObject instanceof PsiElement ? (PsiElement)elementObject : (element = elementObject instanceof ASTNode ? ((ASTNode)elementObject).getPsi() : null);
                if (element != null) {
                    BlockTreeNode currentBlockNode;
                    int textLength;
                    TextRange rangeInHostFile = InjectedLanguageManager.getInstance((Project)PsiViewerDialog.this.myProject).injectedToHost(element, element.getTextRange());
                    int start = rangeInHostFile.getStartOffset();
                    int end = rangeInHostFile.getEndOffset();
                    ViewerTreeStructure treeStructure = (ViewerTreeStructure)PsiViewerDialog.this.myPsiTreeBuilder.getTreeStructure();
                    PsiElement rootPsiElement = treeStructure.getRootPsiElement();
                    if (rootPsiElement != null) {
                        int baseOffset = rootPsiElement.getTextRange().getStartOffset();
                        start -= baseOffset;
                        end -= baseOffset;
                    }
                    if (end <= (textLength = PsiViewerDialog.this.myEditor.getDocument().getTextLength())) {
                        PsiViewerDialog.this.myHighlighter = PsiViewerDialog.this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        if (PsiViewerDialog.this.myPsiTree.hasFocus()) {
                            PsiViewerDialog.this.myEditor.getCaretModel().moveToOffset(start);
                            PsiViewerDialog.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                        }
                    }
                    if (PsiViewerDialog.this.myBlockTreeBuilder != null && PsiViewerDialog.this.myPsiTree.hasFocus() && (currentBlockNode = PsiViewerDialog.this.findBlockNode(element)) != null) {
                        PsiViewerDialog.this.selectBlockNode(currentBlockNode);
                    }
                    PsiViewerDialog.this.updateReferences(element);
                }
            }
        }
    }

    private static class SourceWrapper
    implements Comparable<SourceWrapper> {
        private final FileType myFileType;
        private final PsiViewerExtension myExtension;

        public SourceWrapper(FileType fileType) {
            this.myFileType = fileType;
            this.myExtension = null;
        }

        public SourceWrapper(PsiViewerExtension extension) {
            this.myFileType = null;
            this.myExtension = extension;
        }

        public String getText() {
            return this.myFileType != null ? this.myFileType.getName() + " file" : this.myExtension.getName();
        }

        @Nullable
        public Icon getIcon() {
            return this.myFileType != null ? this.myFileType.getIcon() : this.myExtension.getIcon();
        }

        @Override
        public int compareTo(@NotNull SourceWrapper o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/internal/psiView/PsiViewerDialog$SourceWrapper", "compareTo"));
            }
            return this.getText().compareToIgnoreCase(o.getText());
        }
    }

    private static class ExtensionComparator
    implements Comparator<String> {
        private final String myOnTop;

        public ExtensionComparator(String onTop) {
            this.myOnTop = onTop;
        }

        @Override
        public int compare(@NotNull String o1, @NotNull String o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/internal/psiView/PsiViewerDialog$ExtensionComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/internal/psiView/PsiViewerDialog$ExtensionComparator", "compare"));
            }
            if (o1.equals(this.myOnTop)) {
                return -1;
            }
            if (o2.equals(this.myOnTop)) {
                return 1;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

