/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.codeInsight.daemon.impl.quickfix.FetchExtResourceAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerExImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalResourcesRootsProvider
extends IndexableSetContributor {
    private final NotNullLazyValue<Set<String>> myStandardResources = new NotNullLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            ExternalResourceManagerExImpl manager = (ExternalResourceManagerExImpl)ExternalResourceManager.getInstance();
            THashSet dirs = new THashSet();
            THashSet set = new THashSet();
            for (Map<String, ExternalResourceManagerExImpl.Resource> map : manager.getStandardResources()) {
                for (ExternalResourceManagerExImpl.Resource resource : map.values()) {
                    String url;
                    ExternalResourceManagerExImpl.Resource dir = new ExternalResourceManagerExImpl.Resource(resource.directoryName(), resource);
                    if (!dirs.add(dir) || (url = resource.getResourceUrl()) == null) continue;
                    set.add(url.substring(0, url.lastIndexOf(47) + 1));
                }
            }
            THashSet tHashSet = set;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ExternalResourcesRootsProvider$1", "compute"));
            }
            return tHashSet;
        }
    };

    public Set<VirtualFile> getAdditionalRootsToIndex() {
        THashSet roots = new THashSet();
        for (String url : (Set)this.myStandardResources.getValue()) {
            VirtualFile file = VfsUtilCore.findRelativeFile((String)url, null);
            if (file == null) continue;
            roots.add(file);
        }
        String path = FetchExtResourceAction.getExternalResourcesPath();
        VirtualFile extResources = LocalFileSystem.getInstance().findFileByPath(path);
        ContainerUtil.addIfNotNull((Object)extResources, (Collection)roots);
        return roots;
    }
}

