/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooser;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.BaseFileConfigurableStoreImpl;
import com.intellij.openapi.components.impl.stores.DefaultProjectStoreImpl;
import com.intellij.openapi.components.impl.stores.FileBasedStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.ProjectStateStorageManager;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectStoreImpl
extends BaseFileConfigurableStoreImpl
implements IProjectStore {
    private static final Logger LOG = Logger.getInstance(ProjectStoreImpl.class);
    private static final Storage DEFAULT_STORAGE_ANNOTATION = new MyStorage();
    @NonNls
    private static final String OLD_PROJECT_SUFFIX = "_old.";
    @NonNls
    static final String OPTION_WORKSPACE = "workspace";
    private static int originalVersion = -1;
    protected ProjectImpl myProject;
    private StorageScheme myScheme;
    private String myPresentableUrl;
    private final StateStorageChooser<PersistentStateComponent<?>> myStateStorageChooser;

    ProjectStoreImpl(@NotNull ProjectImpl project, @NotNull PathMacroManager pathMacroManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "<init>"));
        }
        if (pathMacroManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathMacroManager", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "<init>"));
        }
        super(pathMacroManager);
        this.myScheme = StorageScheme.DEFAULT;
        this.myStateStorageChooser = new StateStorageChooser<PersistentStateComponent<?>>(){

            @NotNull
            public Storage[] selectStorages(@NotNull Storage[] storages, @NotNull PersistentStateComponent<?> component, @NotNull StateStorageOperation operation) {
                if (storages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storages", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                }
                if (operation == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                }
                if (operation == StateStorageOperation.READ) {
                    SmartList result = new SmartList();
                    for (int i = storages.length - 1; i >= 0; --i) {
                        Storage storage = storages[i];
                        if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                        result.add(storage);
                    }
                    for (Storage storage : storages) {
                        if (storage.scheme() != StorageScheme.DEFAULT) continue;
                        result.add(storage);
                    }
                    Storage[] storageArray = result.toArray(new Storage[result.size()]);
                    if (storageArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                    }
                    return storageArray;
                }
                if (operation == StateStorageOperation.WRITE) {
                    SmartList result = new SmartList();
                    for (Storage storage : storages) {
                        if (storage.scheme() != ProjectStoreImpl.this.myScheme) continue;
                        result.add(storage);
                    }
                    if (!result.isEmpty()) {
                        Storage[] storageArray = result.toArray(new Storage[result.size()]);
                        if (storageArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                        }
                        return storageArray;
                    }
                    for (Storage storage : storages) {
                        if (storage.scheme() != StorageScheme.DEFAULT) continue;
                        result.add(storage);
                    }
                    Storage[] storageArray = result.toArray(new Storage[result.size()]);
                    if (storageArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                    }
                    return storageArray;
                }
                Storage[] storageArray = new Storage[]{};
                if (storageArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$4", "selectStorages"));
                }
                return storageArray;
            }
        };
        this.myProject = project;
    }

    @Override
    public boolean checkVersion() {
        if (originalVersion >= 0 && originalVersion < 4) {
            final VirtualFile projectFile = this.getProjectFile();
            LOG.assertTrue(projectFile != null);
            String message = ProjectBundle.message((String)"project.convert.old.prompt", (Object[])new Object[]{projectFile.getName(), ApplicationNamesInfo.getInstance().getProductName(), projectFile.getNameWithoutExtension() + OLD_PROJECT_SUFFIX + projectFile.getExtension()});
            if (Messages.showYesNoDialog((String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            List<String> conversionProblems = ProjectStoreImpl.getConversionProblemsStorage();
            if (!ContainerUtil.isEmpty(conversionProblems)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(ProjectBundle.message((String)"project.convert.problems.detected", (Object[])new Object[0]));
                for (String s : conversionProblems) {
                    buffer.append('\n');
                    buffer.append(s);
                }
                buffer.append(ProjectBundle.message((String)"project.convert.problems.help", (Object[])new Object[0]));
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)buffer.toString(), (String)ProjectBundle.message((String)"project.convert.problems.title", (Object[])new Object[0]), (String)ProjectBundle.message((String)"project.convert.problems.help.button", (Object[])new Object[0]), (String)CommonBundle.getCloseButtonText(), (Icon)Messages.getWarningIcon()) == 0) {
                    HelpManager.getInstance().invokeHelp("project.migrationProblems");
                }
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        VirtualFile projectDir = projectFile.getParent();
                        assert (projectDir != null);
                        this.backup(projectDir, projectFile);
                        VirtualFile workspaceFile = ProjectStoreImpl.this.getWorkspaceFile();
                        if (workspaceFile != null) {
                            this.backup(projectDir, workspaceFile);
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private void backup(VirtualFile projectDir, VirtualFile vile) throws IOException {
                    String oldName = vile.getNameWithoutExtension() + ProjectStoreImpl.OLD_PROJECT_SUFFIX + vile.getExtension();
                    VfsUtil.saveText((VirtualFile)projectDir.findOrCreateChildData((Object)this, oldName), (String)VfsUtilCore.loadText((VirtualFile)vile));
                }
            });
        }
        return originalVersion <= 4 || ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)CommonBundle.getWarningTitle(), (String)ProjectBundle.message((String)"project.load.new.version.warning", (Object[])new Object[]{this.myProject.getName(), ApplicationNamesInfo.getInstance().getProductName()})).icon(Messages.getWarningIcon())).project((Project)this.myProject)).is();
    }

    @Override
    public TrackingPathMacroSubstitutor[] getSubstitutors() {
        return new TrackingPathMacroSubstitutor[]{this.getStateStorageManager().getMacroSubstitutor()};
    }

    @Override
    protected boolean optimizeTestLoading() {
        return this.myProject.isOptimiseTestLoadSpeed();
    }

    @Override
    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public void setProjectFilePath(final @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "setProjectFilePath"));
        }
        StateStorageManager stateStorageManager = this.getStateStorageManager();
        final LocalFileSystem fs = LocalFileSystem.getInstance();
        File file = new File(filePath);
        if (!ProjectStoreImpl.isIprPath(file)) {
            this.myScheme = StorageScheme.DIRECTORY_BASED;
            final File dirStore = file.isDirectory() ? new File(file, ".idea") : new File(file.getParentFile(), ".idea");
            stateStorageManager.addMacro("$PROJECT_FILE$", new File(dirStore, "misc.xml").getPath());
            File ws = new File(dirStore, "workspace.xml");
            stateStorageManager.addMacro("$WORKSPACE_FILE$", ws.getPath());
            if (!ws.exists() && !file.isDirectory()) {
                ProjectStoreImpl.useOldWsContent(filePath, ws);
            }
            stateStorageManager.addMacro("$PROJECT_CONFIG_DIR$", dirStore.getPath());
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByIoFile(dirStore)});
                }
            }, ModalityState.defaultModalityState());
        } else {
            this.myScheme = StorageScheme.DEFAULT;
            stateStorageManager.addMacro("$PROJECT_FILE$", filePath);
            final String workspacePath = ProjectStoreImpl.composeWsPath(filePath);
            stateStorageManager.addMacro("$WORKSPACE_FILE$", workspacePath);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByPath(filePath), fs.refreshAndFindFileByPath(workspacePath)});
                }
            }, ModalityState.defaultModalityState());
        }
        this.myPresentableUrl = null;
    }

    private static boolean isIprPath(File file) {
        return FileUtilRt.extensionEquals((String)file.getName(), (String)"ipr");
    }

    private static String composeWsPath(String filePath) {
        int lastDot = filePath.lastIndexOf(".");
        String filePathWithoutExt = lastDot > 0 ? filePath.substring(0, lastDot) : filePath;
        return filePathWithoutExt + ".iws";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void useOldWsContent(String filePath, File ws) {
        File oldWs = new File(ProjectStoreImpl.composeWsPath(filePath));
        if (oldWs.exists()) {
            try {
                FileInputStream is = new FileInputStream(oldWs);
                try {
                    byte[] bytes = FileUtil.loadBytes((InputStream)is, (int)((int)oldWs.length()));
                    FileOutputStream os = new FileOutputStream(ws);
                    try {
                        ((OutputStream)os).write(bytes);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public VirtualFile getProjectBaseDir() {
        if (this.myProject.isDefault()) {
            return null;
        }
        String path = this.getProjectBasePath();
        if (path == null) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @Override
    public String getProjectBasePath() {
        if (this.myProject.isDefault()) {
            return null;
        }
        String path = this.getProjectFilePath();
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            return this.getBasePath(new File(path));
        }
        StateStorage storage = this.getStateStorageManager().getStateStorage("$PROJECT_FILE$", RoamingType.PER_USER);
        if (!(storage instanceof FileBasedStorage)) {
            return null;
        }
        return this.getBasePath(((FileBasedStorage)storage).getFile());
    }

    private String getBasePath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getBasePath"));
        }
        if (this.myScheme == StorageScheme.DEFAULT) {
            return file.getParent();
        }
        File parentFile = file.getParentFile();
        return parentFile == null ? null : parentFile.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public String getProjectName() {
        int i;
        if (this.myScheme == StorageScheme.DIRECTORY_BASED) {
            VirtualFile baseDir;
            block14: {
                VirtualFile nameFile;
                baseDir = this.getProjectBaseDir();
                assert (baseDir != null) : "scheme=" + this.myScheme + " project file=" + this.getProjectFilePath();
                VirtualFile ideaDir = baseDir.findChild(".idea");
                if (ideaDir != null && ideaDir.isValid() && (nameFile = ideaDir.findChild(".name")) != null && nameFile.isValid()) {
                    BufferedReader in;
                    block13: {
                        in = new BufferedReader(new InputStreamReader(nameFile.getInputStream(), CharsetToolkit.UTF8_CHARSET));
                        String name = in.readLine();
                        if (name == null || name.length() <= 0) break block13;
                        String string = name.trim();
                        in.close();
                        String string2 = string;
                        if (string2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
                        }
                        return string2;
                    }
                    try {
                        in.close();
                        break block14;
                        {
                            catch (Throwable throwable) {
                                in.close();
                                throw throwable;
                            }
                        }
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
            String string = baseDir.getName().replace(":", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
            }
            return string;
        }
        String temp = PathUtilRt.getFileName((String)((FileBasedStorage)this.getProjectFileStorage()).getFilePath());
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(temp);
        if (fileType instanceof ProjectFileType) {
            temp = temp.substring(0, temp.length() - fileType.getDefaultExtension().length() - 1);
        }
        if ((i = temp.lastIndexOf(File.separatorChar)) >= 0) {
            temp = temp.substring(i + 1, temp.length() - i + 1);
        }
        String string = temp;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectName"));
        }
        return string;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myScheme;
        if (storageScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getStorageScheme"));
        }
        return storageScheme;
    }

    @Override
    public String getPresentableUrl() {
        if (this.myProject.isDefault()) {
            return null;
        }
        if (this.myPresentableUrl == null) {
            String url;
            String string = url = this.myScheme == StorageScheme.DIRECTORY_BASED ? this.getProjectBasePath() : this.getProjectFilePath();
            if (url != null) {
                this.myPresentableUrl = FileUtil.toSystemDependentName((String)url);
            }
        }
        return this.myPresentableUrl;
    }

    @Override
    public VirtualFile getProjectFile() {
        return this.myProject.isDefault() ? null : ((FileBasedStorage)this.getProjectFileStorage()).getVirtualFile();
    }

    @NotNull
    private XmlElementStorage getProjectFileStorage() {
        XmlElementStorage storage = (XmlElementStorage)this.getStateStorageManager().getStateStorage("$PROJECT_FILE$", RoamingType.PER_USER);
        assert (storage != null);
        XmlElementStorage xmlElementStorage = storage;
        if (xmlElementStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectFileStorage"));
        }
        return xmlElementStorage;
    }

    @Override
    public VirtualFile getWorkspaceFile() {
        if (this.myProject.isDefault()) {
            return null;
        }
        FileBasedStorage storage = (FileBasedStorage)this.getStateStorageManager().getStateStorage("$WORKSPACE_FILE$", RoamingType.DISABLED);
        assert (storage != null);
        return storage.getVirtualFile();
    }

    @Override
    public void loadProjectFromTemplate(@NotNull ProjectImpl defaultProject) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultProject", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "loadProjectFromTemplate"));
        }
        defaultProject.save();
        Element element = ((DefaultProjectStoreImpl)defaultProject.getStateStore()).getStateCopy();
        if (element != null) {
            this.getProjectFileStorage().setDefaultState(element);
        }
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        String string = this.myProject.isDefault() ? "" : ((FileBasedStorage)this.getProjectFileStorage()).getFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getProjectFilePath"));
        }
        return string;
    }

    @Override
    @NotNull
    protected XmlElementStorage getMainStorage() {
        XmlElementStorage xmlElementStorage = this.getProjectFileStorage();
        if (xmlElementStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getMainStorage"));
        }
        return xmlElementStorage;
    }

    @Override
    @NotNull
    protected StateStorageManager createStateStorageManager() {
        ProjectStateStorageManager projectStateStorageManager = new ProjectStateStorageManager(this.myPathMacroManager.createTrackingSubstitutor(), this.myProject);
        if (projectStateStorageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "createStateStorageManager"));
        }
        return projectStateStorageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doSave(@Nullable List<StateStorage.SaveSession> saveSessions, @NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "doSave"));
        }
        ProjectImpl.UnableToSaveProjectNotification[] notifications = (ProjectImpl.UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectImpl.UnableToSaveProjectNotification.class, (Project)this.myProject);
        if (notifications.length > 0) {
            throw new IComponentStore.SaveCancelledException();
        }
        this.beforeSave(readonlyFiles);
        super.doSave(saveSessions, readonlyFiles);
        if (!readonlyFiles.isEmpty()) {
            ReadonlyStatusHandler.OperationStatus status;
            AccessToken token = ReadAction.start();
            try {
                status = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(ProjectStoreImpl.getFilesList(readonlyFiles));
            }
            finally {
                token.finish();
            }
            if (status.hasReadonlyFiles()) {
                ProjectImpl.dropUnableToSaveProjectNotification(this.myProject, status.getReadonlyFiles());
                throw new IComponentStore.SaveCancelledException();
            }
            ArrayList<Pair<StateStorage.SaveSession, VirtualFile>> oldList = new ArrayList<Pair<StateStorage.SaveSession, VirtualFile>>(readonlyFiles);
            readonlyFiles.clear();
            List<Throwable> errors = null;
            for (Pair pair : oldList) {
                errors = ProjectStoreImpl.executeSave((StateStorage.SaveSession)pair.first, readonlyFiles, errors);
            }
            if (errors != null) {
                throw new CompoundRuntimeException(errors);
            }
            if (!readonlyFiles.isEmpty()) {
                ProjectImpl.dropUnableToSaveProjectNotification(this.myProject, ProjectStoreImpl.getFilesList(readonlyFiles));
                throw new IComponentStore.SaveCancelledException();
            }
        }
    }

    protected void beforeSave(@NotNull List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        if (readonlyFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readonlyFiles", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "beforeSave"));
        }
    }

    @NotNull
    private static VirtualFile[] getFilesList(List<Pair<StateStorage.SaveSession, VirtualFile>> readonlyFiles) {
        VirtualFile[] files = new VirtualFile[readonlyFiles.size()];
        int size = readonlyFiles.size();
        for (int i = 0; i < size; ++i) {
            files[i] = (VirtualFile)readonlyFiles.get((int)i).second;
        }
        if (files == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getFilesList"));
        }
        return files;
    }

    @Override
    protected StateStorageChooser<PersistentStateComponent<?>> getDefaultStateStorageChooser() {
        return this.myStateStorageChooser;
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = this.myProject.getMessageBus();
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getMessageBus"));
        }
        return messageBus;
    }

    @Override
    @NotNull
    protected <T> Storage[] getComponentStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Storage[] result;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        if (stateSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateSpec", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        for (Storage storage : result = super.getComponentStorageSpecs(component, stateSpec, operation)) {
            if (!storage.file().equals("$PROJECT_FILE$")) continue;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
            }
            return result;
        }
        Storage[] withProjectFileStorage = new Storage[result.length + 1];
        System.arraycopy(result, 0, withProjectFileStorage, 0, result.length);
        withProjectFileStorage[result.length] = DEFAULT_STORAGE_ANNOTATION;
        if (withProjectFileStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl", "getComponentStorageSpecs"));
        }
        return withProjectFileStorage;
    }

    private static class MyStorage
    implements Storage {
        private MyStorage() {
        }

        public String id() {
            return "___Default___";
        }

        public boolean isDefault() {
            return true;
        }

        public String file() {
            return "$PROJECT_FILE$";
        }

        public StorageScheme scheme() {
            return StorageScheme.DEFAULT;
        }

        public boolean deprecated() {
            return true;
        }

        public RoamingType roamingType() {
            return RoamingType.PER_USER;
        }

        public Class<? extends StateStorage> storageClass() {
            return StateStorage.class;
        }

        public Class<StateSplitterEx> stateSplitter() {
            return StateSplitterEx.class;
        }

        @NotNull
        public Class<? extends Annotation> annotationType() {
            throw new UnsupportedOperationException("Method annotationType not implemented in " + this.getClass());
        }
    }

    static class IprStorageData
    extends ProjectStorageData {
        IprStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        IprStorageData(IprStorageData storageData) {
            super(storageData);
        }

        @Override
        public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
            if (rootElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/ProjectStoreImpl$IprStorageData", "load"));
            }
            String v = rootElement.getAttributeValue("version");
            originalVersion = v != null ? Integer.parseInt(v) : 0;
            if (originalVersion != 4) {
                this.convert(rootElement, originalVersion);
            }
            super.load(rootElement, pathMacroSubstitutor, intern);
        }

        protected void convert(Element root, int originalVersion) {
        }

        @Override
        public StorageData clone() {
            return new IprStorageData(this);
        }
    }

    static class WsStorageData
    extends ProjectStorageData {
        WsStorageData(String rootElementName, Project project) {
            super(rootElementName, project);
        }

        WsStorageData(WsStorageData storageData) {
            super(storageData);
        }

        @Override
        public StorageData clone() {
            return new WsStorageData(this);
        }
    }

    static class ProjectStorageData
    extends BaseFileConfigurableStoreImpl.BaseStorageData {
        protected final Project myProject;

        ProjectStorageData(String rootElementName, Project project) {
            super(rootElementName);
            this.myProject = project;
        }

        protected ProjectStorageData(ProjectStorageData storageData) {
            super(storageData);
            this.myProject = storageData.myProject;
        }

        @Override
        public StorageData clone() {
            return new ProjectStorageData(this);
        }
    }
}

