/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.ex;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultColorSchemesManager", defaultStateAsResource=true, storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class DefaultColorSchemesManager
implements PersistentStateComponent<Element> {
    private final List<DefaultColorsScheme> mySchemes = new ArrayList<DefaultColorsScheme>();
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";

    public static DefaultColorSchemesManager getInstance() {
        return (DefaultColorSchemesManager)ServiceManager.getService(DefaultColorSchemesManager.class);
    }

    @Nullable
    public Element getState() {
        return null;
    }

    public void loadState(Element state) {
        for (Element schemeElement : state.getChildren(SCHEME_ELEMENT)) {
            DefaultColorsScheme newScheme = new DefaultColorsScheme();
            newScheme.readExternal(schemeElement);
            this.mySchemes.add(newScheme);
        }
    }

    public DefaultColorsScheme[] getAllSchemes() {
        return this.mySchemes.toArray(new DefaultColorsScheme[this.mySchemes.size()]);
    }

    @Nullable
    public EditorColorsScheme getScheme(String name) {
        for (DefaultColorsScheme scheme : this.mySchemes) {
            if (!name.equals(scheme.getName())) continue;
            return scheme;
        }
        return null;
    }
}

